/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.LineReader;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Neuron;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Pattern;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.PatternSet;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Randomizer;
import org.gcube.dataanalysis.ecoengine.models.cores.neuralnetworks.neurosolutions.Synapse;

public class NeuralNet
implements Serializable {
    Neuron[] neurons;
    Synapse[] synapses;
    int nolayers;
    Layer[] layers;
    private Randomizer randomizer;
    int[] topology;

    public NeuralNet(String path, Randomizer randomizer) {
        int i;
        this.randomizer = randomizer;
        LineReader linereader = new LineReader(path);
        while (linereader.NextLineSplitted()) {
            if (linereader.column[0].compareTo("#neurons") == 0) {
                this.neurons = new Neuron[Integer.parseInt(linereader.column[1])];
            }
            if (linereader.column[0].compareTo("#synapses") == 0) {
                this.synapses = new Synapse[Integer.parseInt(linereader.column[1])];
            }
            if (linereader.column[0].compareTo("i") == 0) {
                this.neurons[Integer.parseInt((String)linereader.column[1])] = new Neuron(Integer.parseInt(linereader.column[1]));
            }
            if (linereader.column[0].compareTo("n") == 0) {
                this.neurons[Integer.parseInt((String)linereader.column[1])] = new Neuron(Integer.parseInt(linereader.column[1]), Integer.parseInt(linereader.column[2]), Double.parseDouble(linereader.column[3]), linereader.column[4].charAt(0), Double.parseDouble(linereader.column[5]), Double.parseDouble(linereader.column[6]), randomizer);
            }
            if (linereader.column[0].compareTo("s") != 0) continue;
            this.synapses[Integer.parseInt((String)linereader.column[1])] = new Synapse(this.neurons[Integer.parseInt(linereader.column[2])], this.neurons[Integer.parseInt(linereader.column[3])], randomizer);
        }
        linereader = null;
        int temp_maxlayer = 0;
        for (i = 0; i < this.neurons.length; ++i) {
            if (this.neurons[i].layer <= temp_maxlayer) continue;
            temp_maxlayer = this.neurons[i].layer;
        }
        this.nolayers = temp_maxlayer + 1;
        this.layers = new Layer[this.nolayers];
        for (i = 0; i < this.nolayers; ++i) {
            this.layers[i] = new Layer(i);
        }
        this.NeuronsInOut();
    }

    public static double[] preprocessObjects(Object[] vector) {
        double[] out = new double[vector.length];
        for (int i = 0; i < vector.length; ++i) {
            double element = 0.0;
            if (vector[i] != null) {
                element = Double.parseDouble("" + vector[i]);
            }
            out[i] = element;
        }
        return out;
    }

    public double[] getNegativeCase() {
        double[] out = new double[]{};
        if (this.topology.length > 0) {
            out = new double[this.topology[this.topology.length - 1]];
            for (int i = 0; i < out.length; ++i) {
                out[i] = -1.0;
            }
        }
        return out;
    }

    public double[] getPositiveCase() {
        double[] out = new double[]{};
        if (this.topology.length > 0) {
            out = new double[this.topology[this.topology.length - 1]];
            for (int i = 0; i < out.length; ++i) {
                out[i] = 1.0;
            }
        }
        return out;
    }

    public static int[] setupInnerLayers(int ... numberOfNeurons) {
        int[] layers = null;
        if (numberOfNeurons.length > 0) {
            layers = new int[numberOfNeurons.length];
            for (int i = 0; i < numberOfNeurons.length; ++i) {
                layers[i] = numberOfNeurons[i];
            }
        }
        return layers;
    }

    public NeuralNet(int N, int M, int[] t) {
        Randomizer randomizer = new Randomizer();
        int[] noofneurons = null;
        double[] learnratecoeff = null;
        char[] axonfamily = null;
        double[] momentumrate = null;
        double[] flatness = null;
        int len = 2;
        if (t != null) {
            len += t.length;
        }
        noofneurons = new int[len];
        learnratecoeff = new double[len];
        axonfamily = new char[len];
        momentumrate = new double[len];
        flatness = new double[len];
        noofneurons[0] = N;
        learnratecoeff[0] = 1.0;
        axonfamily[0] = 116;
        momentumrate[0] = 0.0;
        flatness[0] = 1.0;
        for (int i = 1; i < len - 1; ++i) {
            noofneurons[i] = t[i - 1];
            learnratecoeff[i] = 1.0;
            axonfamily[i] = 116;
            momentumrate[i] = 0.4;
            flatness[i] = 1.0;
        }
        noofneurons[len - 1] = M;
        learnratecoeff[len - 1] = 1.0;
        axonfamily[len - 1] = 116;
        momentumrate[len - 1] = 0.4;
        flatness[len - 1] = 1.0;
        this.init(noofneurons, learnratecoeff, axonfamily, momentumrate, flatness, randomizer);
    }

    public void init(int[] noofneurons, double[] learningratecoefficient, char[] axonfamily, double[] momentumrate, double[] axonfuncflatness, Randomizer randomizer) {
        int i;
        this.randomizer = randomizer;
        this.topology = noofneurons;
        int temp_nooflayers = noofneurons.length;
        this.nolayers = noofneurons.length;
        int temp_noofneurons = 0;
        for (int i2 = 0; i2 < temp_nooflayers; ++i2) {
            temp_noofneurons += noofneurons[i2];
        }
        this.neurons = new Neuron[temp_noofneurons];
        int temp_noofsynapses = 0;
        for (int i3 = 0; i3 < temp_nooflayers - 1; ++i3) {
            temp_noofsynapses += noofneurons[i3] * noofneurons[i3 + 1];
        }
        this.synapses = new Synapse[temp_noofsynapses];
        int temp_neuronidcounter = 0;
        for (i = 0; i < noofneurons[0]; ++i) {
            this.neurons[temp_neuronidcounter] = new Neuron(temp_neuronidcounter);
            ++temp_neuronidcounter;
        }
        for (i = 1; i < temp_nooflayers; ++i) {
            for (int j = 0; j < noofneurons[i]; ++j) {
                this.neurons[temp_neuronidcounter] = new Neuron(temp_neuronidcounter, i, axonfuncflatness[i], axonfamily[i], momentumrate[i], learningratecoefficient[i], randomizer);
                ++temp_neuronidcounter;
            }
        }
        this.layers = new Layer[temp_nooflayers];
        for (i = 0; i < temp_nooflayers; ++i) {
            this.layers[i] = new Layer(i);
        }
        int temp_synapseidcounter = 0;
        for (int i4 = 0; i4 < temp_nooflayers - 1; ++i4) {
            for (int j = 0; j < this.layers[i4].neurons.length; ++j) {
                for (int k = 0; k < this.layers[i4 + 1].neurons.length; ++k) {
                    this.synapses[temp_synapseidcounter++] = new Synapse(this.layers[i4].neurons[j], this.layers[i4 + 1].neurons[k], randomizer);
                }
            }
        }
        this.NeuronsInOut();
    }

    public NeuralNet(int[] noofneurons, double[] learningratecoefficient, char[] axonfamily, double[] momentumrate, double[] axonfuncflatness, Randomizer randomizer) {
        this.init(noofneurons, learningratecoefficient, axonfamily, momentumrate, axonfuncflatness, randomizer);
    }

    private void NeuronsInOut() {
        for (int i = 0; i < this.neurons.length; ++i) {
            int j;
            Neuron[] temp_neuronsin = null;
            Neuron[] temp_neuronsout = null;
            int incounter = 0;
            int outcounter = 0;
            for (j = 0; j < this.synapses.length; ++j) {
                if (this.synapses[j].sourceunit == this.neurons[i]) {
                    ++outcounter;
                }
                if (this.synapses[j].targetunit != this.neurons[i]) continue;
                ++incounter;
            }
            temp_neuronsin = new Neuron[incounter];
            Synapse[] temp_synapsesin = new Synapse[incounter];
            temp_neuronsout = new Neuron[outcounter];
            Synapse[] temp_synapsesout = new Synapse[outcounter];
            incounter = 0;
            outcounter = 0;
            for (j = 0; j < this.synapses.length; ++j) {
                if (this.synapses[j].sourceunit == this.neurons[i]) {
                    temp_neuronsout[outcounter] = this.synapses[j].targetunit;
                    temp_synapsesout[outcounter++] = this.synapses[j];
                }
                if (this.synapses[j].targetunit != this.neurons[i]) continue;
                temp_neuronsin[incounter] = this.synapses[j].sourceunit;
                temp_synapsesin[incounter++] = this.synapses[j];
            }
            this.neurons[i].InsOuts(temp_neuronsin, temp_neuronsout, temp_synapsesin, temp_synapsesout);
        }
    }

    public void SaveConfig(String path) throws IOException {
        int i;
        File outputFile = new File(path);
        FileWriter out = new FileWriter(outputFile);
        out.write("// Input units:\n");
        out.write("#neurons;" + this.neurons.length + "\n");
        out.write("// type;ID;layer;flatness;axonfamily;momentum;learningrate\n");
        for (i = 0; i < this.neurons.length; ++i) {
            if (this.neurons[i].layer == 0) {
                out.write("i;" + i + ";0\n");
                continue;
            }
            out.write("n;" + i + ";" + this.neurons[i].layer + ";" + this.neurons[i].axonfuncflatness + ";" + this.neurons[i].axonfamily + ";" + this.neurons[i].momentumrate + ";" + this.neurons[i].learningratecoefficient + "\n");
        }
        out.write("#synapses;" + this.synapses.length + "\n");
        out.write("// type; ID; sourceunit; targetunit\n");
        for (i = 0; i < this.synapses.length; ++i) {
            out.write("s;" + i + ";" + this.synapses[i].sourceunit.id + ";" + this.synapses[i].targetunit.id + "\n");
        }
        out.close();
    }

    public void LoadWeights(String path) {
        LineReader linereader = new LineReader(path);
        while (linereader.NextLineSplitted()) {
            if (linereader.column[0].compareTo("w") == 0) {
                this.synapses[Integer.parseInt((String)linereader.column[1])].weight = Double.parseDouble(linereader.column[2]);
            }
            if (linereader.column[0].compareTo("t") != 0) continue;
            this.neurons[Integer.parseInt((String)linereader.column[1])].threshold = Double.parseDouble(linereader.column[2]);
        }
        linereader = null;
    }

    public void SaveWeights(String path) throws IOException {
        int i;
        File outputFile = new File(path);
        FileWriter out = new FileWriter(outputFile);
        for (i = 0; i < this.synapses.length; ++i) {
            out.write("w; " + i + "; " + this.synapses[i].weight + "\n");
        }
        out.write("\n");
        for (i = 0; i < this.neurons.length; ++i) {
            out.write("t; " + i + "; " + this.neurons[i].threshold + "\n");
        }
        out.close();
    }

    public void FeedForward(double[] inputs) {
        int i;
        for (i = 0; i < this.layers[0].neurons.length; ++i) {
            this.layers[0].neurons[i].output = inputs[i];
        }
        for (i = 1; i < this.nolayers; ++i) {
            for (int j = 0; j < this.layers[i].neurons.length; ++j) {
                this.layers[i].neurons[j].UpdateOutput();
            }
        }
    }

    public double[] Output(double[] inputs) {
        this.FeedForward(inputs);
        double[] tempoutputs = new double[this.layers[this.nolayers - 1].neurons.length];
        for (int i = 0; i < this.layers[this.nolayers - 1].neurons.length; ++i) {
            tempoutputs[i] = this.layers[this.nolayers - 1].neurons[i].output;
        }
        return tempoutputs;
    }

    public double CrossValErrorRatio(PatternSet patternset) {
        int noofoutputunits = this.layers[this.nolayers - 1].neurons.length;
        double[] abserrors = new double[noofoutputunits];
        for (int i = 0; i < noofoutputunits; ++i) {
            abserrors[i] = 0.0;
        }
        double errorratio = 0.0;
        double[] temp_output = new double[noofoutputunits];
        for (int j = 0; j < patternset.crossvalpatterns.length; ++j) {
            temp_output = this.Output(patternset.crossvalpatterns[j].input);
            for (int i = 0; i < noofoutputunits; ++i) {
                int n = i;
                abserrors[n] = abserrors[n] + Math.abs(temp_output[i] - patternset.crossvalpatterns[j].target[i]);
            }
        }
        for (int i = 0; i < noofoutputunits; ++i) {
            int n = i;
            abserrors[n] = abserrors[n] / (double)patternset.crossvalpatterns.length;
            errorratio += abserrors[i] / patternset.crossvaldeviations[i];
        }
        return errorratio /= (double)noofoutputunits;
    }

    public double TestErrorRatio(PatternSet patternset) {
        int noofoutputunits = this.layers[this.nolayers - 1].neurons.length;
        double[] abserrors = new double[noofoutputunits];
        for (int i = 0; i < noofoutputunits; ++i) {
            abserrors[i] = 0.0;
        }
        double errorratio = 0.0;
        double[] temp_output = new double[noofoutputunits];
        for (int j = 0; j < patternset.testpatterns.length; ++j) {
            temp_output = this.Output(patternset.testpatterns[j].input);
            for (int i = 0; i < noofoutputunits; ++i) {
                int n = i;
                abserrors[n] = abserrors[n] + Math.abs(temp_output[i] - patternset.testpatterns[j].target[i]);
            }
        }
        for (int i = 0; i < noofoutputunits; ++i) {
            int n = i;
            abserrors[n] = abserrors[n] / (double)patternset.testpatterns.length;
            errorratio += abserrors[i] / patternset.testdeviations[i];
        }
        return errorratio /= (double)noofoutputunits;
    }

    public void IncrementalTrainPatterns(Pattern[] patterns, double rate) {
        int i;
        int patternsnottrained = patterns.length;
        int indexofpatterntotrain = -1;
        for (i = 0; i < patterns.length; ++i) {
            patterns[i].selected = false;
        }
        for (i = 0; i < patterns.length; ++i) {
            int patterntotrain = this.randomizer.random.nextInt(patternsnottrained);
            int counter = 0;
            for (int j = 0; j < patterns.length; ++j) {
                if (patterns[j].selected) continue;
                if (counter != patterntotrain) {
                    ++counter;
                    continue;
                }
                if (counter != patterntotrain) continue;
                indexofpatterntotrain = j;
                break;
            }
            this.IncrementalTrain(rate, patterns[indexofpatterntotrain]);
            patterns[indexofpatterntotrain].selected = true;
            --patternsnottrained;
        }
        for (i = 0; i < patterns.length; ++i) {
            patterns[i].selected = false;
        }
    }

    public void IncrementalTrain(double rate, Pattern pattern) {
        this.FeedForward(pattern.input);
        for (int j = 0; j < this.layers[this.nolayers - 1].neurons.length; ++j) {
            this.layers[this.nolayers - 1].neurons[j].OutputIncrementalTrain(rate, pattern.target[j]);
        }
        for (int i = this.nolayers - 2; i > 0; --i) {
            for (int j = 0; j < this.layers[i].neurons.length; ++j) {
                this.layers[i].neurons[j].HiddenIncrementalTrain(rate);
            }
        }
    }

    public void MinibatchTrainPatterns(Pattern[] patterns, double rate, int nopatterns) {
        int i;
        int patternsnottrained = patterns.length;
        if (nopatterns > patterns.length) {
            nopatterns = patterns.length;
        }
        if (nopatterns < 1) {
            nopatterns = 1;
        }
        int indexofpatterntotrain = -1;
        int[] indexesofpatternstotrain = new int[nopatterns];
        for (i = 0; i < patterns.length; ++i) {
            patterns[i].selected = false;
        }
        while (patternsnottrained > 0) {
            int noofpatternsselected = 0;
            while (noofpatternsselected < nopatterns && patternsnottrained > 0) {
                int patterntotrain = this.randomizer.random.nextInt(patternsnottrained);
                --patternsnottrained;
                int counter = 0;
                for (i = 0; i < patterns.length; ++i) {
                    if (patterns[i].selected) continue;
                    if (counter != patterntotrain) {
                        ++counter;
                        continue;
                    }
                    if (counter != patterntotrain) continue;
                    indexofpatterntotrain = i;
                    break;
                }
                indexesofpatternstotrain[++noofpatternsselected - 1] = indexofpatterntotrain;
                patterns[indexofpatterntotrain].selected = true;
            }
            Pattern[] patternsselected = null;
            patternsselected = new Pattern[noofpatternsselected];
            for (i = 0; i < noofpatternsselected; ++i) {
                patternsselected[i] = patterns[indexesofpatternstotrain[i]];
            }
            this.BatchTrainPatterns(patternsselected, rate);
        }
        for (i = 0; i < patterns.length; ++i) {
            patterns[i].selected = false;
        }
    }

    public void BatchTrainPatterns(Pattern[] patterns, double rate) {
        int i;
        for (i = 0; i < patterns.length; ++i) {
            this.BatchTrain(rate, patterns[i]);
        }
        for (i = 0; i < this.neurons.length; ++i) {
            if (this.neurons[i].layer == 0) continue;
            this.neurons[i].BatchUpdateWeights(patterns.length);
        }
    }

    public void BatchTrain(double rate, Pattern pattern) {
        this.FeedForward(pattern.input);
        for (int j = 0; j < this.layers[this.nolayers - 1].neurons.length; ++j) {
            this.layers[this.nolayers - 1].neurons[j].OutputBatchTrain(rate, pattern.target[j]);
        }
        for (int i = this.nolayers - 2; i > 0; --i) {
            for (int j = 0; j < this.layers[i].neurons.length; ++j) {
                this.layers[i].neurons[j].HiddenBatchTrain(rate);
            }
        }
    }

    class Layer
    implements Serializable {
        Neuron[] neurons;

        public Layer(int layerno) {
            int i;
            int counter = 0;
            for (i = 0; i < NeuralNet.this.neurons.length; ++i) {
                if (NeuralNet.this.neurons[i].layer != layerno) continue;
                ++counter;
            }
            this.neurons = new Neuron[counter];
            counter = 0;
            for (i = 0; i < NeuralNet.this.neurons.length; ++i) {
                if (NeuralNet.this.neurons[i].layer != layerno) continue;
                this.neurons[counter++] = NeuralNet.this.neurons[i];
            }
        }
    }
}

