/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.treeStructure.graph;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JApplet;
import org.jgraph.JGraph;
import org.jgraph.graph.AttributeMap;
import org.jgraph.graph.DefaultGraphCell;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.GraphModel;
import org.jgrapht.Graph;
import org.jgrapht.ext.JGraphModelAdapter;
import org.jgrapht.graph.DefaultEdge;
import org.jgrapht.graph.ListenableDirectedGraph;

public class GraphGeneratorApplet
extends JApplet {
    private static final Color DEFAULT_BG_COLOR = Color.decode("#FAFBFF");
    private static final Dimension DEFAULT_SIZE = new Dimension(530, 320);
    private JGraphModelAdapter m_jgAdapter;

    @Override
    public void init() {
        ListenableDirectedGraph g = new ListenableDirectedGraph(DefaultEdge.class);
        this.m_jgAdapter = new JGraphModelAdapter((Graph)g);
        JGraph jgraph = new JGraph((GraphModel)this.m_jgAdapter);
        this.adjustDisplaySettings(jgraph);
        this.getContentPane().add((Component)jgraph);
        this.resize(DEFAULT_SIZE);
        g.addVertex((Object)"v1");
        g.addVertex((Object)"v2");
        g.addVertex((Object)"v3");
        g.addVertex((Object)"v4");
        g.addEdge((Object)"v1", (Object)"v2");
        g.addEdge((Object)"v2", (Object)"v3");
        g.addEdge((Object)"v3", (Object)"v1");
        g.addEdge((Object)"v4", (Object)"v3");
        this.positionVertexAt("v1", 130, 40);
        this.positionVertexAt("v2", 60, 200);
        this.positionVertexAt("v3", 310, 230);
        this.positionVertexAt("v4", 380, 70);
    }

    private void adjustDisplaySettings(JGraph jg) {
        jg.setPreferredSize(DEFAULT_SIZE);
        Color c = DEFAULT_BG_COLOR;
        String colorStr = null;
        try {
            colorStr = this.getParameter("bgcolor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (colorStr != null) {
            c = Color.decode(colorStr);
        }
        jg.setBackground(c);
    }

    private void positionVertexAt(Object vertex, int x, int y) {
        DefaultGraphCell cell = this.m_jgAdapter.getVertexCell(vertex);
        AttributeMap attr = cell.getAttributes();
        Rectangle2D b = GraphConstants.getBounds((Map)attr);
        GraphConstants.setBounds((Map)attr, (Rectangle2D)new Rectangle(x, y, (int)b.getWidth(), (int)b.getHeight()));
        HashMap<DefaultGraphCell, AttributeMap> cellAttr = new HashMap<DefaultGraphCell, AttributeMap>();
        cellAttr.put(cell, attr);
        this.m_jgAdapter.edit(cellAttr, null, null, null);
    }
}

