/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.lexicalmatcher.analysis.guesser.data;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.MathFunctions;

public class CategoryScores {
    private HashMap<String, Float> columnsScore = new HashMap();
    private int matchedElements = 0;
    private BigInteger maxElements;
    private BigInteger categoryElements;
    private LexicalEngineConfiguration config;

    public CategoryScores(BigInteger catElements, LexicalEngineConfiguration Config2) {
        this.setCategoryElements(catElements);
        this.config = Config2;
        this.maxElements = this.calculateMaxElements(catElements);
    }

    public double calculateCoverage() {
        double bd = new BigDecimal(this.matchedElements).divide(new BigDecimal(this.maxElements), 2, 3).doubleValue();
        if (this.maxElements.compareTo(BigInteger.valueOf(this.config.chunkSize)) <= 0) {
            bd *= 0.8;
        }
        if (this.categoryElements.compareTo(BigInteger.valueOf(10000L)) > 0) {
            bd = Math.max(0.01, bd);
        }
        return bd;
    }

    private BigInteger calculateMaxElements(BigInteger catElements) {
        BigInteger maxElements = BigInteger.ZERO;
        int maxNumberOfChunks = this.config.ReferenceChunksToTake;
        int chunkSize = this.config.chunkSize;
        int numberofcycles = 0;
        if (maxNumberOfChunks < 0) {
            return catElements;
        }
        try {
            BigDecimal catElementsDecimal = new BigDecimal(catElements);
            BigDecimal[] arraydecimal = catElementsDecimal.divideAndRemainder(new BigDecimal(BigInteger.valueOf(chunkSize)));
            BigDecimal intcycles = arraydecimal[0];
            BigDecimal oddcycles = arraydecimal[1];
            numberofcycles = intcycles.intValue();
            if (numberofcycles == 0 && oddcycles.intValue() > 0) {
                ++numberofcycles;
                maxElements = oddcycles.toBigInteger();
            } else {
                if (numberofcycles > maxNumberOfChunks) {
                    numberofcycles = maxNumberOfChunks;
                }
                maxElements = BigInteger.valueOf(chunkSize).multiply(BigInteger.valueOf(numberofcycles));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxElements;
    }

    public String showScores() {
        return this.columnsScore.toString() + ":" + this.calculateCoverage();
    }

    public void incrementScore(String columnName, float increment, boolean doIncrementMathes) {
        Float score = this.columnsScore.get(columnName);
        if (score == null) {
            score = new Float(0.0f);
        }
        score = Float.valueOf(MathFunctions.incrementPerc(score.floatValue(), increment, this.matchedElements));
        if (doIncrementMathes) {
            ++this.matchedElements;
        }
        this.columnsScore.put(columnName, score);
    }

    public float getScore(String columnName, boolean simpleMatch) {
        if (simpleMatch) {
            return this.getSimpleScore(columnName);
        }
        return this.getScore(columnName);
    }

    public float getScore(String columnName) {
        Float score = null;
        try {
            score = this.columnsScore.get(columnName);
            if (score != null) {
                return score.floatValue() * (float)this.calculateCoverage();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return score.floatValue();
    }

    public float getSimpleScore(String columnName) {
        Float score = null;
        try {
            score = this.columnsScore.get(columnName);
            if (score != null) {
                return score.floatValue();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return score.floatValue();
    }

    public String findBest() {
        String bestCol = null;
        Float bestscore = Float.valueOf(-1.0f);
        for (String column : this.columnsScore.keySet()) {
            Float score = new Float(0.0f);
            try {
                score = this.columnsScore.get(column);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().error((Object)("ERROR in getting SCORE " + e.getLocalizedMessage()));
            }
            if (bestscore.compareTo(score) >= 0) continue;
            bestscore = score;
            bestCol = column;
        }
        return bestCol;
    }

    public ArrayList<String> findBestList() {
        ArrayList<String> bestCols = new ArrayList<String>();
        for (String column : this.columnsScore.keySet()) {
            int size;
            Float score = new Float(0.0f);
            try {
                score = this.columnsScore.get(column);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().error((Object)("ERROR in getting SCORE " + e.getLocalizedMessage()));
            }
            int index = size = bestCols.size();
            for (int i = 0; i < size; ++i) {
                if (this.columnsScore.get(bestCols.get(i)).compareTo(score) > 0) continue;
                index = i;
                break;
            }
            bestCols.add(index, column);
        }
        return bestCols;
    }

    public void setCategoryElements(BigInteger categoryElements) {
        this.categoryElements = categoryElements;
    }

    public BigInteger getCategoryElements() {
        return this.categoryElements;
    }
}

