/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.wps.client;

import java.math.BigInteger;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.opengis.ows.x11.BoundingBoxType;
import net.opengis.wps.x100.CapabilitiesDocument;
import net.opengis.wps.x100.ComplexDataType;
import net.opengis.wps.x100.ExecuteDocument;
import net.opengis.wps.x100.ExecuteResponseDocument;
import net.opengis.wps.x100.InputDescriptionType;
import net.opengis.wps.x100.InputType;
import net.opengis.wps.x100.OutputDescriptionType;
import net.opengis.wps.x100.ProcessBriefType;
import net.opengis.wps.x100.ProcessDescriptionType;
import net.opengis.wps.x100.ResponseDocumentType;
import net.opengis.wps.x100.StatusType;
import net.opengis.wps.x100.impl.ExecuteResponseDocumentImpl;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.geo.wps.mappings.WPS2SM;
import org.n52.wps.client.ExecuteRequestBuilder;
import org.n52.wps.client.WPSClientSession;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WPSClient {
    private ProcessBriefType[] processesList;
    private String wpsServiceURL;
    private InputDescriptionType[] currentInputs;
    private OutputDescriptionType[] currentOutputs;
    public float wpsstatus = 0.0f;
    private List<StatisticalType> currentInputStatisticalTypes;
    private LinkedHashMap<String, StatisticalType> currentOutputStatisticalTypes;
    private ProcessDescriptionType currentProcessDescription;
    private String currentProcessID;
    private String currentProcessTitle;
    private String currentProcessAbstract;

    public OutputDescriptionType[] getCurrentOutputs() {
        return this.currentOutputs;
    }

    public void setCurrentOutputs(OutputDescriptionType[] currentOutputs) {
        this.currentOutputs = currentOutputs;
    }

    public LinkedHashMap<String, StatisticalType> getCurrentOutputStatisticalTypes() {
        return this.currentOutputStatisticalTypes;
    }

    public void setCurrentOutputStatisticalTypes(LinkedHashMap<String, StatisticalType> currentOutputStatisticalTypes) {
        this.currentOutputStatisticalTypes = currentOutputStatisticalTypes;
    }

    public String getWpsServiceURL() {
        return this.wpsServiceURL;
    }

    public void setWpsServiceURL(String wpsServiceURL) {
        this.wpsServiceURL = wpsServiceURL;
    }

    public InputDescriptionType[] getCurrentInputs() {
        return this.currentInputs;
    }

    public void setCurrentInputs(InputDescriptionType[] currentInputs) {
        this.currentInputs = currentInputs;
    }

    public List<StatisticalType> getCurrentInputStatisticalTypes() {
        return this.currentInputStatisticalTypes;
    }

    public void setCurrentInputStatisticalTypes(List<StatisticalType> currentStatisticalTypes) {
        this.currentInputStatisticalTypes = currentStatisticalTypes;
    }

    public String getCurrentProcessID() {
        return this.currentProcessID;
    }

    public void setCurrentProcessID(String currentProcessID) {
        this.currentProcessID = currentProcessID;
    }

    public String getCurrentProcessTitle() {
        return this.currentProcessTitle;
    }

    public void setCurrentProcessTitle(String currentProcessTitle) {
        this.currentProcessTitle = currentProcessTitle;
    }

    public String getCurrentProcessAbstract() {
        return this.currentProcessAbstract;
    }

    public void setCurrentProcessAbstract(String currentProcessAbstract) {
        this.currentProcessAbstract = currentProcessAbstract;
    }

    public WPSClient(String wpsServiceURL) throws Exception {
        this.wpsServiceURL = wpsServiceURL;
    }

    public void describeProcess(String processID) throws Exception {
        this.describeProcess(processID, null);
    }

    public void describeProcess(String processID, URL processDescriptionURL) throws Exception {
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        try {
            AnalysisLogger.getLogger().debug((Object)("Describe Process WPS URL: " + this.wpsServiceURL));
            ProcessDescriptionType processDescription = null;
            for (int k = 0; k <= 3; ++k) {
                block12: {
                    try {
                        processDescription = wpsClient.getProcessDescription(this.wpsServiceURL, processID);
                    }
                    catch (Exception e) {
                        AnalysisLogger.getLogger().debug((Object)("Retrying with WPS URL: " + this.wpsServiceURL));
                        if (k != 3) break block12;
                        throw e;
                    }
                }
                if (processDescription != null) break;
            }
            this.currentProcessDescription = processDescription;
            if (processDescriptionURL != null) {
                processDescription.set((XmlObject)XmlString.Factory.parse((URL)processDescriptionURL));
            }
            AnalysisLogger.getLogger().debug((Object)processDescription.toString());
            this.currentProcessID = processDescription.getIdentifier().getStringValue();
            this.currentProcessTitle = processDescription.getTitle().getStringValue();
            this.currentProcessAbstract = processDescription.getAbstract() != null ? processDescription.getAbstract().getStringValue() : "";
            AnalysisLogger.getLogger().debug((Object)("WPSClient->Process ID:" + this.currentProcessID));
            AnalysisLogger.getLogger().debug((Object)("WPSClient->Process Title:" + this.currentProcessTitle));
            AnalysisLogger.getLogger().debug((Object)("WPSClient->Process Abstract:" + this.currentProcessAbstract));
            InputDescriptionType[] inputList = processDescription.getDataInputs().getInputArray();
            AnalysisLogger.getLogger().debug((Object)"WPSClient->Fetching Inputs");
            this.currentInputStatisticalTypes = new ArrayList<StatisticalType>();
            for (InputDescriptionType input : inputList) {
                StatisticalType stype = WPS2SM.convert2SMType(input);
                this.currentInputStatisticalTypes.add(stype);
                AnalysisLogger.getLogger().debug((Object)("WPSClient->Converted Into a Statistical Type: " + stype));
            }
            AnalysisLogger.getLogger().debug((Object)"WPSClient->Fetching Outputs");
            OutputDescriptionType[] outputList = processDescription.getProcessOutputs().getOutputArray();
            this.currentOutputStatisticalTypes = new LinkedHashMap();
            this.currentOutputs = outputList;
            for (OutputDescriptionType output : outputList) {
                AnalysisLogger.getLogger().debug((Object)("WPSClient->Output id:" + output.getIdentifier().getStringValue()));
                if (output.getAbstract() != null) {
                    AnalysisLogger.getLogger().debug((Object)("WPSClient->Abstract:" + output.getAbstract().getStringValue()));
                }
                AnalysisLogger.getLogger().debug((Object)("WPSClient->Name:" + output.getTitle().getStringValue()));
                StatisticalType stype = WPS2SM.convert2SMType(output);
                this.currentOutputStatisticalTypes.put(output.getIdentifier().getStringValue(), stype);
                AnalysisLogger.getLogger().debug((Object)("WPSClient->Converted Into a Statistical Type: " + stype));
            }
            this.currentInputs = inputList;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            wpsClient.disconnect(this.wpsServiceURL);
        }
    }

    public void requestGetCapabilities() throws Exception {
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        wpsClient.connect(this.wpsServiceURL);
        try {
            ProcessBriefType[] processList;
            CapabilitiesDocument capabilities = wpsClient.getWPSCaps(this.wpsServiceURL);
            for (ProcessBriefType process : processList = capabilities.getCapabilities().getProcessOfferings().getProcessArray()) {
                AnalysisLogger.getLogger().debug((Object)("WPSClient->Process id:" + process.getIdentifier().getStringValue()));
                AnalysisLogger.getLogger().debug((Object)("WPSClient->title:" + process.getTitle().getStringValue()));
                AnalysisLogger.getLogger().debug((Object)("WPSClient->abstract:" + process.getAbstract()));
            }
            this.setProcessesList(processList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            wpsClient.disconnect(this.wpsServiceURL);
        }
    }

    public ProcessBriefType[] getProcessesList() {
        return this.processesList;
    }

    public void setProcessesList(ProcessBriefType[] processesList) {
        this.processesList = processesList;
    }

    public ProcessDescriptionType getProcessDescription() {
        return this.currentProcessDescription;
    }

    public void setProcessDescription(ProcessDescriptionType processDescription) {
        this.currentProcessDescription = processDescription;
    }

    public ExecuteResponseDocument.ExecuteResponse.ProcessOutputs executeProcess(ExecuteRequestBuilder executeBuilder, ProcessDescriptionType processDescription) throws Exception {
        try {
            OutputDescriptionType[] odts;
            for (OutputDescriptionType odt : odts = processDescription.getProcessOutputs().getOutputArray()) {
                if (!odt.isSetComplexOutput()) continue;
                executeBuilder.setMimeTypeForOutput("text/xml", odt.getIdentifier().getStringValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)"Execute Process-> Warning, no xml structured objects will be provided");
        }
        ExecuteDocument execute = executeBuilder.getExecute();
        execute.getExecute().setService("WPS");
        WPSClientSession wpsClient = WPSClientSession.getInstance();
        try {
            wpsClient.connect(this.wpsServiceURL);
            AnalysisLogger.getLogger().debug((Object)("Sending:\n" + execute));
            if (execute.getExecute().getResponseForm() != null) {
                ResponseDocumentType documentType = execute.getExecute().getResponseForm().getResponseDocument();
                documentType.setStoreExecuteResponse(true);
                documentType.setStatus(true);
                documentType.setLineage(false);
                execute.getExecute().getResponseForm().setResponseDocument(documentType);
            }
            boolean end = false;
            Object responseObject = wpsClient.execute(this.wpsServiceURL, execute);
            String statusLocation = null;
            if (responseObject != null) {
                statusLocation = ((ExecuteResponseDocumentImpl)responseObject).getExecuteResponse().getStatusLocation();
            } else {
                throw new Exception("" + responseObject);
            }
            while (!end) {
                if (responseObject instanceof ExecuteResponseDocumentImpl) {
                    String paused;
                    StatusType statusType = ((ExecuteResponseDocumentImpl)responseObject).getExecuteResponse().getStatus();
                    int status = statusType.getProcessStarted() == null ? -1 : statusType.getProcessStarted().getPercentCompleted();
                    String failure = statusType.getProcessFailed() == null ? null : statusType.getProcessFailed().getExceptionReport().toString();
                    String accepted = statusType.getProcessAccepted() == null ? null : statusType.getProcessAccepted();
                    String success = statusType.getProcessSucceeded() == null ? null : statusType.getProcessSucceeded();
                    String string = paused = statusType.getProcessPaused() == null ? null : statusType.getProcessPaused().getStringValue();
                    if (failure != null && failure.length() > 0 || paused != null && paused.length() > 0) {
                        AnalysisLogger.getLogger().debug((Object)("WPS FAILURE: " + failure + " OR PAUSED: " + paused));
                        this.wpsstatus = 100.0f;
                        throw new Exception(failure);
                    }
                    if (accepted != null && accepted.length() > 0) {
                        AnalysisLogger.getLogger().debug((Object)"WPS ACCEPTED");
                        this.wpsstatus = 0.0f;
                    } else if (success != null && success.length() > 0) {
                        AnalysisLogger.getLogger().debug((Object)"WPS SUCCESS");
                        this.wpsstatus = 100.0f;
                        end = true;
                    } else if (status >= 0) {
                        Float statusd = Float.valueOf(status);
                        try {
                            statusd = Float.valueOf(Float.parseFloat(statusType.getProcessStarted().getStringValue()));
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        AnalysisLogger.getLogger().debug((Object)("WPS STATUS:" + statusd));
                        this.wpsstatus = statusd.floatValue();
                    }
                    Thread.sleep(2000L);
                    if (statusLocation != null && statusLocation.length() > 0) {
                        responseObject = wpsClient.executeViaGET(statusLocation, "");
                        continue;
                    }
                    if (this.wpsstatus == 100.0f) continue;
                    throw new Exception("Cannot retrieve process status");
                }
                throw new Exception("" + responseObject);
            }
            AnalysisLogger.getLogger().debug((Object)("Response:\n" + responseObject));
            this.wpsstatus = 100.0f;
            ExecuteResponseDocument.ExecuteResponse.ProcessOutputs processOutputs = ((ExecuteResponseDocument)responseObject).getExecuteResponse().getProcessOutputs();
            return processOutputs;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            wpsClient.disconnect(this.wpsServiceURL);
        }
    }

    public static void main(String[] args) throws Exception {
        AnalysisLogger.setLogger((String)"./cfg/ALog.properties");
        WPSClient client = new WPSClient("http://geoprocessing.demo.52north.org:8080/wps/WebProcessingService");
        client.requestGetCapabilities();
        client.describeProcess("org.n52.wps.server.algorithm.SimpleBufferAlgorithm");
    }

    public static int calculateBBDimensions(String bbstring) {
        String[] bbinput = bbstring.split(",");
        int dimcounter = 0;
        try {
            for (int i = 0; i < bbinput.length; ++i) {
                Double.parseDouble(bbinput[i]);
                ++dimcounter;
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("Dimensions Count: " + dimcounter));
        }
        return dimcounter;
    }

    public static void addBoundingBoxInput(ExecuteRequestBuilder executeBuilder, String identifier, String BBstring) {
        ExecuteDocument executor = executeBuilder.getExecute();
        InputType input1 = executor.getExecute().getDataInputs().addNewInput();
        input1.addNewIdentifier().setStringValue(identifier);
        BoundingBoxType bbtype = input1.addNewData().addNewBoundingBoxData();
        String[] bbinput = BBstring.split(",");
        int dimensions = WPSClient.calculateBBDimensions(BBstring);
        ArrayList<String> lc = new ArrayList<String>();
        for (int i = 0; i < dimensions / 2; ++i) {
            lc.add(bbinput[i]);
        }
        ArrayList<String> uc = new ArrayList<String>();
        for (int i = dimensions / 2; i < dimensions; ++i) {
            uc.add(bbinput[i]);
        }
        bbtype.setLowerCorner(lc);
        bbtype.setUpperCorner(uc);
        String crs = bbinput[dimensions];
        bbtype.setCrs(crs);
        bbtype.setDimensions(new BigInteger("" + dimensions / 2));
    }

    public static List<String> retrieveURLsFromWPSResponse(ComplexDataType cdt) {
        Node node = cdt.getDomNode();
        List<String> urls = WPSClient.getURLFromXML(node);
        return urls;
    }

    private static List<String> getURLFromXML(Node node) {
        ArrayList<String> urls = new ArrayList<String>();
        if (node == null) {
            return urls;
        }
        NodeList listnodes = node.getChildNodes();
        int nChildren = listnodes.getLength();
        if (nChildren == 0) {
            String text = node.getNodeValue();
            if (text != null && (text.startsWith("https:") || text.startsWith("http:") || text.startsWith("ftp:") || text.startsWith("smp:") || text.startsWith("file:"))) {
                urls.add(text.trim());
            }
        } else {
            for (int i = 0; i < nChildren; ++i) {
                List<String> childrenurls = WPSClient.getURLFromXML(listnodes.item(i));
                urls.addAll(childrenurls);
            }
        }
        return urls;
    }
}

