/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.executor.util.StorageUtils;
import org.gcube.datatransfer.agent.library.AgentLibrary;
import org.gcube.datatransfer.agent.library.exceptions.MonitorTransferException;
import org.gcube.datatransfer.agent.library.proxies.Proxies;
import org.gcube.datatransfer.common.agent.Types;
import org.gcube.datatransfer.common.options.TransferOptions;
import org.gcube.datatransfer.common.outcome.FileTransferOutcome;
import org.gcube.datatransfer.common.outcome.TransferStatus;

public class DataTransferer {
    public static void main(String[] args) throws Exception {
        String scope = "/gcube/devsec/devVRE";
        ScopeProvider.instance.set(scope);
        String transferGHN = "access.d4science.org";
        int transferPort = 8080;
        AgentLibrary library = (AgentLibrary)Proxies.transferAgent().at(transferGHN, transferPort).build();
        ArrayList<URI> input = new ArrayList<URI>();
        String urlStorage = "http://goo.gl/Vq8QVY";
        System.out.println("URL for storage: " + urlStorage);
        URI uri = new URI("http://dl.dropboxusercontent.com/u/12809149/wind1.tif");
        input.add(uri);
        String outPath = "/var/www/html/test/";
        String fileToTransfer = "C:\\Users\\coro\\Dropbox\\Public\\3_Aquamaps.jpg";
        DataTransferer.transferFileToService(scope, "gianpaolo.coro", transferGHN, transferPort, fileToTransfer, outPath);
    }

    public static boolean transferFileToService(String scope, String username, String service, int port, String fileAbsolutePath, String remoteFolder) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Transferring file " + fileAbsolutePath + " to " + service + ":" + port));
        ScopeProvider.instance.set(scope);
        AgentLibrary library = (AgentLibrary)Proxies.transferAgent().at(service, port).build();
        ArrayList<URI> input = new ArrayList<URI>();
        File localFile = new File(fileAbsolutePath);
        if (!localFile.exists()) {
            throw new Exception("Local file does not exist: " + localFile);
        }
        String localfolder = localFile.getParent();
        String file = localFile.getName();
        AnalysisLogger.getLogger().debug((Object)("Uploading file " + file + " onto storage"));
        ScopeProvider.instance.set(scope);
        AnalysisLogger.getLogger().info((Object)("Loading file on scope: " + scope));
        String storagesmpurl = StorageUtils.uploadFilesOnStorage(scope, username, localfolder, "/", file, true);
        AnalysisLogger.getLogger().debug((Object)("SMP url generated: " + storagesmpurl));
        URI uri = new URI(storagesmpurl);
        input.add(uri);
        TransferOptions options = new TransferOptions();
        options = new TransferOptions();
        options.setOverwriteFile(false);
        options.setType(Types.storageType.DataStorage);
        options.setUnzipFile(false);
        options.setTransferTimeout(3L, TimeUnit.HOURS);
        AnalysisLogger.getLogger().debug((Object)"Transferring...");
        ArrayList<URI> outputURI = new ArrayList<URI>();
        outputURI.add(new URI("file://" + remoteFolder.replace(" ", "%20") + file.replace(" ", "%20")));
        AnalysisLogger.getLogger().debug((Object)("Remote file name will be: " + outputURI.get(0)));
        String transferId = library.startTransfer(input, outputURI, options);
        TransferStatus transferStatus = null;
        do {
            try {
                Thread.sleep(1000L);
                transferStatus = TransferStatus.valueOf((String)library.monitorTransfer(transferId));
            }
            catch (MonitorTransferException e) {
                e.printStackTrace();
            }
        } while (!transferStatus.hasCompleted());
        ArrayList outcomes = library.getTransferOutcomes(transferId, FileTransferOutcome.class);
        AnalysisLogger.getLogger().debug((Object)"Transferring complete");
        boolean success = false;
        String outcomeString = "";
        for (FileTransferOutcome outcome : outcomes) {
            AnalysisLogger.getLogger().debug((Object)("Outcome " + outcome));
            outcomeString = outcome.toString();
            AnalysisLogger.getLogger().debug((Object)("Transferred file name " + outcome.fileName()));
            AnalysisLogger.getLogger().debug((Object)("Transferring success " + outcome.isSuccess()));
            AnalysisLogger.getLogger().debug((Object)("Transferred bytes " + outcome.getTotal_size()));
            AnalysisLogger.getLogger().debug((Object)("Transfer time " + outcome.getTransferTime()));
            success = outcome.isSuccess();
        }
        if (!success) {
            throw new Exception("No Bytes were transferred to the Thredds server: " + outcomeString);
        }
        return success;
    }
}

