/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers.bionym;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;

public class CometMatcherManager {
    List<String> scores = new ArrayList<String>();
    List<String> matchednames = new ArrayList<String>();

    public static void cometParse(String pathToComet, String parser, String outFile, String inFile) throws Exception {
        if (!pathToComet.endsWith("/")) {
            pathToComet = String.valueOf(pathToComet) + "/";
        }
        String execution = "java -Xmx512m -Xmx1024m -jar " + pathToComet + "SpeciMEn1.0.71.jar -pt 6 -parser " + parser + " -parseOnly -parserOutFile " + outFile + " -inFile " + inFile;
        System.out.println("Executing: " + execution);
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec(execution);
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));
                String line = br.readLine();
                System.out.println(line);
                while (line != null) {
                    line = br.readLine();
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                System.out.println("Unable to execute the program");
                throw e;
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static void cometMatch(String pathToComet, String parser, String reference, String outFile, String inFile, float sxnw, int maxresults) throws Exception {
        if (!pathToComet.endsWith("/")) {
            pathToComet = String.valueOf(pathToComet) + "/";
        }
        String execution = "java -Xmx512m -Xmx1024m -jar " + pathToComet + "SpeciMEn1.0.71.jar -parser " + parser + " -inFile " + inFile + " " + "-outFile " + outFile + " " + "-man " + "-may " + "-mc " + maxresults + " -mSn " + "-mt " + "-ps " + "-pt 6" + " -sxw " + sxnw + " " + "-targets " + reference + " " + "-xml -xslTemplate csv";
        System.out.println("Executing: " + execution);
        Process process = null;
        try {
            try {
                process = Runtime.getRuntime().exec(execution);
                BufferedReader br = new BufferedReader(new InputStreamReader(process.getErrorStream()));
                String line = br.readLine();
                System.out.println(line);
                while (line != null) {
                    line = br.readLine();
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                System.out.println("Unable to execute the program");
                throw e;
            }
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
    }

    public static List<Tuple<String>> parseCometParserOutput(String parserOutput) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(parserOutput)), "UTF-8"));
        String line = br.readLine();
        line = br.readLine();
        ArrayList<Tuple<String>> parsednames = new ArrayList<Tuple<String>>();
        while (line != null) {
            System.out.println("reading from parser output: " + line);
            if (line.trim().length() > 0) {
                List tokens = Transformations.parseCVSString((String)line, (String)";");
                int tokenslength = tokens.size();
                String scientificname = "";
                if (tokenslength > 2) {
                    scientificname = ((String)tokens.get(2)).replace(",", "").trim();
                }
                String author = "";
                if (tokenslength > 3) {
                    author = ((String)tokens.get(3)).replace(",", "").trim();
                }
                if (scientificname.length() == 0 && author.length() == 0) {
                    scientificname = line.replace(",", "");
                }
                Tuple t = new Tuple((Object[])new String[]{scientificname, author});
                parsednames.add((Tuple<String>)t);
            }
            line = br.readLine();
        }
        br.close();
        return parsednames;
    }

    public List<String> getScores() {
        return this.scores;
    }

    public List<String> getMatches() {
        return this.matchednames;
    }

    public List<Tuple<String>> parseCometOutput(String parserOutput) throws Exception {
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(new File(parserOutput)), "UTF-8"));
        String line = br.readLine();
        line = br.readLine();
        ArrayList<Tuple<String>> parsednames = new ArrayList<Tuple<String>>();
        while (line != null) {
            if (line.trim().length() > 0) {
                System.out.println("Processing Comet output. Line: " + line);
                List tokens = Transformations.parseCVSString((String)line, (String)",");
                int tokenslength = tokens.size();
                String score = "";
                if (tokenslength > 4) {
                    score = ((String)tokens.get(4)).trim();
                }
                String scientificname = "";
                if (tokenslength > 7) {
                    scientificname = ((String)tokens.get(7)).trim();
                }
                String author = "";
                if (tokenslength > 8) {
                    author = ((String)tokens.get(8)).replace("(", "").replace(")", "").trim();
                }
                String matched = scientificname.replace("(", "").replace(")", "").replace(",", "").replace(";", "");
                parsednames.add((Tuple<String>)new Tuple((Object[])new String[]{matched, author, score}));
            }
            line = br.readLine();
        }
        br.close();
        return parsednames;
    }

    public static void dumpCometInput(String inputFile, List<Tuple<String>> rawNames) throws Exception {
        BufferedWriter bw = new BufferedWriter(new FileWriter(new File(inputFile)));
        int size = rawNames.size();
        int i = 0;
        while (i < size) {
            System.out.println("Writing the following to file: " + rawNames.get(i));
            Tuple<String> t = rawNames.get(i);
            String author = "";
            if (((String)t.getElements().get(1)).length() > 0) {
                author = " (" + (String)t.getElements().get(1) + ")";
            }
            bw.append(String.valueOf((String)t.getElements().get(0)) + author);
            if (i < size - 1) {
                bw.append("\n");
            }
            ++i;
        }
        bw.close();
    }

    public List<Tuple<String>> match(String parser, String reference, String sandboxFolder, List<Tuple<String>> inputNamesList, float soundexweightF, int maxResults) throws Exception {
        File FmatcherinputFile = new File(sandboxFolder, "inputCometMatcher.csv");
        File FmatcheroutputFile = new File(sandboxFolder, "outputCometMatcher.csv");
        try {
            FmatcherinputFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            FmatcheroutputFile.delete();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String matcherinputFile = FmatcherinputFile.getAbsolutePath();
        String matcheroutputFile = FmatcheroutputFile.getAbsolutePath();
        CometMatcherManager.dumpCometInput(matcherinputFile, inputNamesList);
        CometMatcherManager.cometMatch(sandboxFolder, parser, reference, matcheroutputFile, matcherinputFile, soundexweightF, maxResults);
        List<Tuple<String>> outputNames = this.parseCometOutput(matcheroutputFile);
        return outputNames;
    }

    public static enum Parsers {
        SIMPLE,
        GNI;

    }

    public static enum Reference {
        ASFIS,
        FISHBASE,
        OBIS;

    }

    public static enum Weights {
        SOUNDEX,
        EDIT_DISTANCE,
        MIXED;

    }
}

