/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers.bionym;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.gcube.dataanalysis.executor.generators.D4ScienceDistributedProcessing;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.BionymFlexibleWorkflowTransducer;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.MatcherOutput;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.SingleEntry;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.implementations.workflows.BiOnymWF;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.interfaces.Matcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.utils.YasmeenGlobalParameters;
import org.gcube.dataanalysis.executor.scripts.OSCommand;
import scala.actors.threadpool.Arrays;

public class BionymLocalTransducer
implements Transducerer {
    public float status = 0.0f;
    AlgorithmConfiguration config = null;
    public static String speciesName = "SpeciesAuthorName";
    public LinkedHashMap<String, String> outputmap = new LinkedHashMap();

    public List<StatisticalType> getInputParameters() {
        List<StatisticalType> types = new BionymFlexibleWorkflowTransducer().getInputParameters();
        PrimitiveType p1 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, speciesName, "The scientific name of the species, possibly with authorship", "Gadus morhua (Linnaeus, 1758)");
        types.remove(0);
        types.remove(0);
        types.remove(0);
        types.remove(0);
        types.add(0, (StatisticalType)p1);
        return types;
    }

    public String getResourceLoad() {
        ResourceFactory resourceManager = new ResourceFactory();
        return resourceManager.getResourceLoad(1);
    }

    public String getResources() {
        if (this.status > 0.0f && this.status < 100.0f) {
            return ResourceFactory.getResources((float[])new float[]{100.0f});
        }
        return ResourceFactory.getResources((float[])new float[]{0.0f});
    }

    public float getStatus() {
        return this.status;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap(this.outputmap), PrimitiveTypes.MAP, "RetrievedTaxaNames", "Retrieved Taxa Names");
        return p;
    }

    public void init() throws Exception {
    }

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    public void shutdown() {
    }

    public String getDescription() {
        return "A fast version of the algorithm implementing BiOnym, a flexible workflow approach to taxon name matching. The workflow allows to activate several taxa names matching algorithms and to get the list of possible transcriptions for a list of input raw species names with possible authorship indication.";
    }

    public void compute() throws Exception {
        this.status = 10.0f;
        String uuid = ("" + UUID.randomUUID()).replace("-", "");
        String inputParserFile = "inputParser" + uuid + ".txt";
        String outputParserFile = "outputParser" + uuid + ".txt";
        String sandboxFolder = "";
        try {
            try {
                String parser = this.config.getParam(YasmeenGlobalParameters.parserNameParam);
                String accuracyvsspeed = this.config.getParam(YasmeenGlobalParameters.performanceParam);
                String reference = this.config.getParam(YasmeenGlobalParameters.taxaAuthorityFileParam);
                String doPreprocess = this.config.getParam(YasmeenGlobalParameters.activatePreParsingProcessing);
                String usestemming = this.config.getParam(YasmeenGlobalParameters.useStemmedGenusAndSpecies);
                String overallMaxResults = this.config.getParam(YasmeenGlobalParameters.overallMaxResults);
                String inputSpecies = this.config.getParam(speciesName);
                sandboxFolder = new File(this.config.getPersistencePath(), D4ScienceDistributedProcessing.defaultContainerFolder).getAbsolutePath();
                AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> Species Name: " + inputSpecies));
                AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> Parser to use: " + parser));
                AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> Accuracy vs Speed: " + accuracyvsspeed));
                AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> Reference Dataset: " + reference));
                AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> Do Preprocessing: " + doPreprocess));
                AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> Use Stemming:" + usestemming));
                AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> Overall MaxResults:" + overallMaxResults));
                HashMap<String, String> globalparameters = new HashMap<String, String>();
                globalparameters.put(YasmeenGlobalParameters.parserInputFileParam, inputParserFile);
                globalparameters.put(YasmeenGlobalParameters.parserOutputFileParam, outputParserFile);
                globalparameters.put(YasmeenGlobalParameters.activatePreParsingProcessing, doPreprocess);
                globalparameters.put(YasmeenGlobalParameters.parserNameParam, parser);
                globalparameters.put(YasmeenGlobalParameters.performanceParam, accuracyvsspeed);
                globalparameters.put(YasmeenGlobalParameters.taxaAuthorityFileParam, reference);
                globalparameters.put(YasmeenGlobalParameters.useStemmedGenusAndSpecies, usestemming);
                globalparameters.put(YasmeenGlobalParameters.staticFilesFolderParam, this.config.getConfigPath());
                inputSpecies = inputSpecies.replaceAll("^'", "").replaceAll("'$", "");
                ArrayList<String> rawnamesFiltered = new ArrayList<String>();
                rawnamesFiltered.add(inputSpecies);
                try {
                    OSCommand.ExecuteGetLine("chmod +x *", null);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"BiOnymLocal-> WARNING: could not change the permissions");
                }
                int overallMR = 10;
                if (overallMaxResults != null) {
                    overallMR = Integer.parseInt(overallMaxResults);
                }
                AnalysisLogger.getLogger().debug((Object)"BiOnymLocal-> Executing WF");
                BiOnymWF bionym = new BiOnymWF(sandboxFolder, overallMR, globalparameters);
                List<Matcher> matchers = new BionymFlexibleWorkflowTransducer().buildMatcherList(this.config, sandboxFolder, globalparameters);
                if (matchers != null) {
                    bionym.resetMatchers(matchers);
                }
                AnalysisLogger.getLogger().debug((Object)"BiOnymLocal-> WorkFlow: ");
                int mcounter = 1;
                for (Matcher matcher : matchers) {
                    AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> " + mcounter + ": " + matcher));
                    ++mcounter;
                }
                this.status = 20.0f;
                MatcherOutput output = bionym.executeChainedWorkflow(rawnamesFiltered);
                AnalysisLogger.getLogger().debug((Object)"BiOnymLocal-> Workflow Executed");
                this.status = 70.0f;
                int nEntries = output.getEntriesNumber();
                this.outputmap.put("HEADER", BionymFlexibleWorkflowTransducer.headers.toString());
                int i = 0;
                while (i < nEntries) {
                    SingleEntry se = output.getEntry(i);
                    Object[] srow = new String[]{"\"" + se.originalName + "\"", "\"" + se.targetScientificName + "\"", "\"" + se.targetAuthor + "\"", "\"" + se.matchingScore + "\"", "\"" + reference + "\"", "\"" + se.targetID + "\""};
                    this.outputmap.put("" + (i + 1), Arrays.toString((Object[])srow));
                    ++i;
                }
                if (nEntries == 0) {
                    AnalysisLogger.getLogger().debug((Object)"BiOnymLocal-> Warning no output found!");
                }
                AnalysisLogger.getLogger().debug((Object)("BiOnymLocal-> map of outputs:\n" + this.outputmap));
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            new File(sandboxFolder, inputParserFile).delete();
            new File(sandboxFolder, outputParserFile).delete();
            AnalysisLogger.getLogger().debug((Object)"BiOnymLocal-> deleting auxiliary files");
            AnalysisLogger.getLogger().debug((Object)"BiOnymLocal-> shutting down");
            this.status = 100.0f;
        }
    }
}

