/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.io.File;
import java.util.List;
import java.util.UUID;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.ZipTools;
import org.gcube.dataanalysis.geo.meta.PolyMapMetadata;
import org.gcube.dataanalysis.geo.utils.GdalConverter;
import org.gcube.dataanalysis.geo.utils.GeospatialDataPublicationLevel;
import org.gcube.spatial.data.gis.model.report.PublishResponse;

public class ShapefilePublisher
extends StandardLocalExternalAlgorithm {
    private static String layerTitleParam = "MapTitle";
    private static String layerAbstractParam = "MapAbstract";
    private static String FileParam = "ShapeFileZip";
    private static String ShapeFileParam = "ShapeFileName";
    private static String TopicsParam = "Topics";
    private static String DBUserParam = "DBUser";
    private static String DBPasswordParam = "DBPassword";
    private static String DBUrlParameter = "DBUrl";
    static String publicationLevel = "PublicationLevel";
    static String shapeImporting = "shp2pgsql -s 4326 -g the_geom -d %1$s public.%6$s | PGPASSWORD=%2$s psql -h %3$s -p 5432 -U %4$s %5$s";

    public void init() throws Exception {
        this.log("ShapefilePublisher->initialised");
    }

    public String getDescription() {
        String description = "An algorithm to publish shapefiles under WMS and WFS standards in the e-Infrastructure. The produced WMS, WFS links are reported as output of this process. The map will be available in the VRE for consultation.";
        return description;
    }

    protected void process() throws Exception {
        this.status = 10.0f;
        String databaseJdbc = this.getInputParameter(DBUrlParameter);
        String databaseUser = this.getInputParameter(DBUserParam);
        String databasePwd = this.getInputParameter(DBPasswordParam);
        String zipFile = this.getInputParameter(FileParam);
        String shapeFileName = this.getInputParameter(ShapeFileParam);
        String layerName = this.getInputParameter(layerTitleParam);
        String layerAbstract = this.getInputParameter(layerAbstractParam);
        String topics = this.getInputParameter(TopicsParam);
        String username = this.getInputParameter("ServiceUserName");
        String publicationLevelValue = this.getInputParameter(publicationLevel);
        this.log("ShapefilePublisher->" + databasePwd);
        this.log("ShapefilePublisher->Parameters:");
        this.log("ShapefilePublisher->zipFile:" + zipFile);
        this.log("ShapefilePublisher->shapeFileName:" + shapeFileName);
        this.log("ShapefilePublisher->layerName:" + layerName);
        this.log("ShapefilePublisher->layerAbstract:" + layerAbstract);
        this.log("ShapefilePublisher->topics:" + topics);
        this.log("ShapefilePublisher->databaseJdbc:" + databaseJdbc);
        this.log("ShapefilePublisher->databaseUser:" + databaseUser);
        this.log("ShapefilePublisher->service user name:" + username);
        if (topics == null || topics.trim().length() == 0) {
            throw new Exception("Error topics missing!");
        }
        File tempFolder = new File(this.config.getConfigPath(), "" + UUID.randomUUID());
        this.log("ShapefilePublisher->Creating temp folder " + tempFolder);
        boolean created = tempFolder.mkdir();
        this.log("ShapefilePublisher->Temp Folder creation check " + created);
        this.log("ShapefilePublisher->unzipping file :" + zipFile + " in folder " + tempFolder.getAbsolutePath());
        ZipTools.unZip((String)zipFile, (String)tempFolder.getAbsolutePath());
        String databaseName = databaseJdbc.substring(databaseJdbc.lastIndexOf("/") + 1);
        String databaseAddress = databaseJdbc.substring(databaseJdbc.indexOf("//") + 2, databaseJdbc.lastIndexOf(":"));
        this.log("ShapefilePublisher->Parsed database Info:" + databaseName + " [" + databaseAddress + "]");
        String shapefile = new File(tempFolder, shapeFileName).getAbsolutePath();
        this.log("ShapefilePublisher->Shape file to search for:" + shapefile);
        String gisTableName = shapeFileName;
        String gisRandomTableName = ("shp_" + UUID.randomUUID()).replace("-", "");
        try {
            gisTableName = shapeFileName.substring(0, shapeFileName.lastIndexOf("."));
        }
        catch (Exception e) {
            throw new Exception("Error - Wrong file name " + shapeFileName);
        }
        this.log("ShapefilePublisher->Original table name :" + gisTableName);
        this.log("ShapefilePublisher->Table name to produce :" + gisRandomTableName);
        String shapeImportCommand = String.format(shapeImporting, shapefile, databasePwd, databaseAddress, databaseUser, databaseName, gisRandomTableName);
        this.log("ShapefilePublisher->Shape file command:" + shapeImportCommand);
        this.status = 50.0f;
        List<String> commandsExecuted = GdalConverter.command(shapeImportCommand, tempFolder.getAbsolutePath());
        String commandExecuted = commandsExecuted.toString();
        this.log("ShapefilePublisher->Command executed output:" + commandExecuted);
        if (!commandExecuted.contains("COMMIT")) {
            throw new Exception("An error occurred when importing the file " + commandExecuted);
        }
        this.log("ShapefilePublisher->Publishing the table " + gisRandomTableName);
        String scope = this.config.getGcubeScope();
        double resolution = 0.0;
        String datastore = "timeseriesws";
        String defaultStyle = "polygon";
        String workspace = "aquamaps";
        String purpose = "To Publish Geometric Layers for user-provided Vector Maps";
        String credits = "Generated via the DataMiner Service";
        String keywords = topics.replace(AlgorithmConfiguration.listSeparator, ",");
        boolean isprivate = false;
        if (GeospatialDataPublicationLevel.valueOf(publicationLevelValue) == GeospatialDataPublicationLevel.PRIVATE) {
            isprivate = true;
        }
        PublishResponse response = null;
        try {
            response = PolyMapMetadata.publishTable(scope, gisRandomTableName, resolution, username, layerName, defaultStyle, workspace, datastore, purpose, credits, keywords, isprivate);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log("ShapefilePublisher->Error during table publication: " + e.getLocalizedMessage());
            throw new Exception("Error during the publication of the shapefile on the SDI");
        }
        this.log("ShapefilePublisher->Finished publishing the table");
        if (response == null) {
            this.log("ShapefilePublisher->Error in generating map");
            throw new Exception("Impossible to publish on GeoNetwork or GeoServer this table: " + gisRandomTableName + " possibly it is already present!");
        }
        this.addOutputString("GIS map title", layerName);
        this.addOutputString("GIS map UUID", response.getPublishedMetadata().getFileIdentifier());
        this.addOutputString("GIS Table ", gisRandomTableName);
        this.addOutputString("Generated by ", username);
        this.addOutputString("Resolution", "" + resolution);
        this.addOutputString("Style", defaultStyle);
        this.addOutputString("Keyword", topics);
        this.log("ShapefilePublisher->Output produced:" + this.outputParameters);
        this.log("ShapefilePublisher->All done!");
        this.status = 100.0f;
    }

    protected void setInputParameters() {
        try {
            PrimitiveType e = new PrimitiveType(Enum.class.getName(), (Object)GeospatialDataPublicationLevel.values(), PrimitiveTypes.ENUMERATED, publicationLevel, "The visibility level of the produced map", "" + (Object)((Object)GeospatialDataPublicationLevel.PRIVATE));
            this.inputs.add(e);
            this.addStringInput(layerTitleParam, "Title of the geospatial dataset to be shown on GeoExplorer", "Generic Vector Layer");
            this.addStringInput(ShapeFileParam, "Name of the shape file inside the zip", "shapefile.shp");
            this.addStringInput(layerAbstractParam, "Abstract defining the content, the references and usage policies", "Abstract");
            this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, FileParam, "Shapefile zip file to process"));
            this.inputs.add(new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, TopicsParam, "Topics to be attached to the published dataset. E.g. Biodiversity, D4Science, Environment, Weather", false));
            this.inputs.add(new ServiceType(ServiceParameters.USERNAME, "ServiceUserName", "The final user Name"));
            this.addRemoteDatabaseInput("UsersGisTablesDB", DBUrlParameter, DBUserParam, DBPasswordParam, "driver", "dialect");
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
    }
}

