/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.asc;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.connectors.asc.AscRaster;
import org.gcube.dataanalysis.geo.connectors.asc.AscRasterReader;

public class AscDataExplorer {
    public double xOrigin;
    public double yOrigin;
    public int ncolumns;
    public int nrows;
    public double cellsize;
    public double dx;
    public double dy;
    AscRaster ascFile;

    public AscDataExplorer(String file) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Managing Asc File: " + file));
        AscRasterReader reader = new AscRasterReader();
        int i = 0;
        while (i < 10) {
            try {
                this.ascFile = reader.readRaster(file);
                break;
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("Error in reading remote file: " + file));
                ++i;
            }
        }
        if (i == 10) {
            throw new Exception("Reading Timeout for the file " + file);
        }
        this.xOrigin = this.ascFile.getXll();
        this.yOrigin = this.ascFile.getYll();
        this.ncolumns = this.ascFile.getCols();
        this.nrows = this.ascFile.getRows();
        this.cellsize = this.ascFile.getCellsize();
        this.dx = this.ascFile.getdx();
        this.dy = this.ascFile.getdy();
        AnalysisLogger.getLogger().debug((Object)("Origin: " + this.xOrigin + "," + this.yOrigin));
        AnalysisLogger.getLogger().debug((Object)("Cellsize: " + this.cellsize));
        AnalysisLogger.getLogger().debug((Object)("dx: " + this.dx + " dy:" + this.dy));
        AnalysisLogger.getLogger().debug((Object)("Rows: " + this.nrows + " Cols:" + this.ncolumns));
    }

    public int longitude2Index(double longitude) {
        if (this.dx > 0.0) {
            return (int)Math.round((longitude - this.xOrigin) / this.dx);
        }
        return (int)Math.round((longitude - this.xOrigin) / this.cellsize);
    }

    public int latitude2Index(double latitude) {
        if (this.dy > 0.0) {
            return (int)Math.round((latitude - this.yOrigin) / this.dy);
        }
        return (int)Math.round((latitude - this.yOrigin) / this.cellsize);
    }

    public List<Double> retrieveDataFromAsc(List<Tuple<Double>> triplets, int time) throws Exception {
        if (time > 0) {
            throw new Exception("No Time Dimension For ASC Files!");
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (Tuple<Double> triplet : triplets) {
            double x = (Double)triplet.getElements().get(0);
            double y = (Double)triplet.getElements().get(1);
            int j = this.longitude2Index(x);
            int i = this.latitude2Index(y);
            if (j > this.ncolumns || j < 0 || i > this.nrows || i < 0) {
                values.add(Double.NaN);
                continue;
            }
            double value = this.ascFile.getValue(i, j);
            if (value == Double.parseDouble(this.ascFile.NDATA)) {
                values.add(Double.NaN);
                continue;
            }
            values.add(value);
        }
        return values;
    }

    public static void testReaders() throws Exception {
        AscRasterReader reader = new AscRasterReader();
        AscRaster r1 = reader.readRaster("ph.asc");
        System.out.println("center:" + r1.getXll() + "," + r1.getYll());
        System.out.println("cols:" + r1.getCols());
        System.out.println("data:" + r1.getValue(1, 1));
    }

    public static void main(String[] args) throws Exception {
        AscDataExplorer ade = new AscDataExplorer("https://dl.dropboxusercontent.com/u/12809149/geoserver-GetCoverage.image.asc");
        ArrayList<Tuple<Double>> triplets = new ArrayList<Tuple<Double>>();
        triplets.add(new Tuple((Object[])new Double[]{-180.0, -90.0}));
        triplets.add(new Tuple((Object[])new Double[]{0.0, 0.0}));
        triplets.add(new Tuple((Object[])new Double[]{180.0, 90.0}));
        triplets.add(new Tuple((Object[])new Double[]{18.620429, 20.836419}));
        List<Double> values = ade.retrieveDataFromAsc(triplets, 0);
        for (Double value : values) {
            AnalysisLogger.getLogger().debug((Object)("val:" + value));
        }
    }
}

