package org.gcube.dataanalysis.geo.connectors.wfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.interfaces.GISDataConnector;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;

public class WFS implements GISDataConnector {

	@Override
	public List<Double> getFeaturesInTimeInstantAndArea(String layerURL, String layerName, int time, List<Tuple<Double>> coordinates3d, double BBxL, double BBxR, double BByL, double BByR) throws Exception {

		if (time>0)
			throw new Exception("Error Time Dimension is not supported for WFS!");
		if (layerURL == null)
			return null;

		List<FeaturedPolygon> featuresInTime = new ArrayList<FeaturedPolygon>();
		AnalysisLogger.getLogger().debug("taking WFS features");
		featuresInTime = WFSDataExplorer.getFeatures(layerURL, layerName, BBxL, BByL, BBxR, BByR);
		int tsize = coordinates3d.size();
		AnalysisLogger.getLogger().debug("Intersecting " + tsize + " vs " + featuresInTime.size() + " elements");
		int ttc = 0;
		Double[] featuresarray = new Double[tsize];
		int k = 0;
		GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 4326);
		for (Tuple<Double> triplet : coordinates3d) {
			ArrayList<Double> elements = triplet.getElements();
			CoordinateArraySequence pcoords = new CoordinateArraySequence(new Coordinate[] { new Coordinate(elements.get(0), elements.get(1)), });
			Point po = new Point(pcoords, factory);
			boolean found = false;

			for (FeaturedPolygon poly : featuresInTime) {
				if (poly != null && poly.p != null && poly.p.covers(po)) {
					featuresarray[k] = poly.value;
					found = true;
					break;
				}
			}

			po = null;

			if (!found) {
				featuresarray[k] = Double.NaN;
			}

			if (ttc % 10000 == 0) {
				AnalysisLogger.getLogger().debug("Status: " + ((double) ttc * 100d / (double) tsize));
			}
			ttc++;
			k++;
		}

		List<Double> features = Arrays.asList(featuresarray);
		return features;
	}

	@Override
	public double getMinZ(String layerURL, String layerName) {
		return 0;
	}

	@Override
	public double getMaxZ(String layerURL, String layerName) {
		return 0;
	}

}
