/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gcube.dataanalysis.geo.utils.AscRaster;

public class AscRasterReader {
    String noData = "-9999";
    Pattern header = Pattern.compile("^(\\w+)\\s+(-?\\d+(.\\d+)?)");

    public static void main(String[] args) throws IOException {
        AscRasterReader rt = new AscRasterReader();
        rt.readRaster("data/test.asc");
    }

    public AscRaster readRaster(String filename) throws IOException, RuntimeException {
        AscRaster raster = new AscRaster();
        BufferedReader input = null;
        URLConnection urlConn = null;
        if (filename.startsWith("http")) {
            URL fileurl = new URL(filename);
            urlConn = fileurl.openConnection();
            urlConn.setConnectTimeout(60000);
            urlConn.setReadTimeout(60000);
            urlConn.setAllowUserInteraction(false);
            urlConn.setDoOutput(true);
            input = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
        } else {
            input = new BufferedReader(new FileReader(filename));
        }
        while (input.ready()) {
            String line = input.readLine();
            Matcher headMatch = this.header.matcher(line);
            if (headMatch.matches()) {
                String head = headMatch.group(1);
                String value = headMatch.group(2);
                if (head.equalsIgnoreCase("nrows")) {
                    raster.rows = Integer.parseInt(value);
                    continue;
                }
                if (head.equalsIgnoreCase("ncols")) {
                    raster.cols = Integer.parseInt(value);
                    continue;
                }
                if (head.equalsIgnoreCase("xllcorner")) {
                    raster.xll = Double.parseDouble(value);
                    continue;
                }
                if (head.equalsIgnoreCase("yllcorner")) {
                    raster.yll = Double.parseDouble(value);
                    continue;
                }
                if (head.equalsIgnoreCase("NODATA_value")) {
                    raster.NDATA = value;
                    continue;
                }
                if (head.equals("cellsize")) {
                    raster.cellsize = Double.parseDouble(value);
                    continue;
                }
                System.out.println("Unknown setting: " + line);
                continue;
            }
            if (line.matches("^-?\\d+.*")) {
                int row = 0;
                double[][] data = new double[raster.rows][];
                while (true) {
                    double[] numData;
                    String[] inData;
                    if ((inData = line.split("\\s+")).length != (numData = new double[raster.cols]).length) {
                        throw new RuntimeException("Wrong number of columns: Expected " + raster.cols + " got " + inData.length + " for line \n" + line);
                    }
                    for (int col = 0; col < raster.cols; ++col) {
                        numData[col] = inData[col].equals(this.noData) ? Double.NaN : Double.parseDouble(inData[col]);
                    }
                    data[row] = numData;
                    if (!input.ready()) break;
                    line = input.readLine();
                    ++row;
                }
                if (row != raster.rows - 1) {
                    throw new RuntimeException("Wrong number of rows: expected " + raster.rows + " got " + (row + 1));
                }
                raster.data = data;
                continue;
            }
            if (line.length() < 0 || line.matches("^\\s*$")) continue;
            System.out.println("Unknown line: " + line);
        }
        if (input != null) {
            input.close();
            if (urlConn != null && urlConn.getInputStream() != null) {
                urlConn.getInputStream().close();
            }
        }
        return raster;
    }
}

