/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.utils.AscRaster;
import org.gcube.dataanalysis.geo.utils.AscRasterReader;

public class AscDataExplorer {
    public double xOrigin;
    public double yOrigin;
    public int ncolumns;
    public int nrows;
    public double cellsize;
    AscRaster ascFile;

    public AscDataExplorer(String file) throws Exception {
        int i;
        AnalysisLogger.getLogger().debug((Object)("Managing Asc File: " + file));
        AscRasterReader reader = new AscRasterReader();
        for (i = 0; i < 10; ++i) {
            try {
                this.ascFile = reader.readRaster(file);
                break;
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().debug((Object)("Error in reading remote file: " + file));
                continue;
            }
        }
        if (i == 10) {
            throw new Exception("Reading Timeout for the file " + file);
        }
        this.xOrigin = this.ascFile.getXll();
        this.yOrigin = this.ascFile.getYll();
        this.ncolumns = this.ascFile.getCols();
        this.nrows = this.ascFile.getRows();
        this.cellsize = this.ascFile.getCellsize();
        AnalysisLogger.getLogger().debug((Object)("Origin: " + this.xOrigin + "," + this.yOrigin));
        AnalysisLogger.getLogger().debug((Object)("Cellsize: " + this.cellsize));
        AnalysisLogger.getLogger().debug((Object)("Rows: " + this.nrows + " Cols:" + this.ncolumns));
    }

    public int longitude2Index(double longitude) {
        return (int)Math.round((longitude - this.xOrigin) / this.cellsize);
    }

    public int latitude2Index(double latitude) {
        return (int)Math.round((latitude - this.yOrigin) / this.cellsize);
    }

    public List<Double> retrieveDataFromAsc(List<Tuple<Double>> triplets) {
        ArrayList<Double> values = new ArrayList<Double>();
        for (Tuple<Double> triplet : triplets) {
            double x = (Double)triplet.getElements().get(0);
            double y = (Double)triplet.getElements().get(1);
            int j = this.longitude2Index(x);
            int i = this.latitude2Index(y);
            if (j > this.ncolumns) {
                AnalysisLogger.getLogger().debug((Object)"Warning: Column Overflow: adjusting!");
                AnalysisLogger.getLogger().debug((Object)("Overflow: y:" + y + "," + "x:" + x));
                AnalysisLogger.getLogger().debug((Object)("Overflow: iy:" + i + "," + "jx:" + j));
                j = this.ncolumns;
            }
            if (i > this.nrows) {
                AnalysisLogger.getLogger().debug((Object)"Warning: Row Overflow: adjusting!");
                AnalysisLogger.getLogger().debug((Object)("Overflow: y:" + y + "," + "x:" + x));
                AnalysisLogger.getLogger().debug((Object)("Overflow: iy:" + i + "," + "jx:" + j));
                i = this.nrows;
            }
            double value = this.ascFile.getValue(i, j);
            values.add(value);
        }
        return values;
    }

    public static void testReaders() throws Exception {
        AscRasterReader reader = new AscRasterReader();
        AscRaster r1 = reader.readRaster("ph.asc");
        System.out.println("center:" + r1.getXll() + "," + r1.getYll());
        System.out.println("cols:" + r1.getCols());
        System.out.println("data:" + r1.getValue(1, 1));
    }

    public static void main(String[] args) throws Exception {
        AscDataExplorer ade = new AscDataExplorer("http://thredds.d4science.org/thredds/fileServer/public/netcdf/ph.asc");
        ArrayList<Tuple<Double>> triplets = new ArrayList<Tuple<Double>>();
        triplets.add(new Tuple((Object[])new Double[]{-180.0, -90.0}));
        triplets.add(new Tuple((Object[])new Double[]{0.0, 0.0}));
        triplets.add(new Tuple((Object[])new Double[]{180.0, 90.0}));
        List<Double> values = ade.retrieveDataFromAsc(triplets);
        for (Double value : values) {
            AnalysisLogger.getLogger().debug((Object)("val:" + value));
        }
    }
}

