/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.impl.CoordinateArraySequence;
import com.vividsolutions.jts.operation.overlay.snap.GeometrySnapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.geo.meta.OGCFormatter;
import org.gcube.dataanalysis.geo.utils.FeaturedPolygon;
import org.gcube.dataanalysis.geo.utils.JsonMapper;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.IndexIterator;

public class EnvDataExplorer {
    private static String callWFS(String geoServer, String layer, double x, double y) {
        float tolerance = 0.25f;
        String wfsURL = OGCFormatter.getWfsUrl(geoServer, layer, OGCFormatter.pointToBoundingBox(x, y, tolerance), 1, "json");
        AnalysisLogger.getLogger().debug((Object)("EnvDataExplorer-> Requesting URL: " + wfsURL));
        String returned = null;
        try {
            returned = HttpRequest.sendGetRequest((String)wfsURL, null);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("EnvDataExplorer-> ERROR " + e.getLocalizedMessage()));
        }
        if (returned != null) {
            AnalysisLogger.getLogger().debug((Object)"EnvDataExplorer-> Found Intersection");
        } else {
            AnalysisLogger.getLogger().debug((Object)"EnvDataExplorer-> Found Nothing!");
        }
        return returned;
    }

    private static String callWFS(String geoServer, String layer, double xL, double yL, double xR, double yR) {
        String wfsURL = OGCFormatter.getWfsUrl(geoServer, layer, null, 0, "json");
        AnalysisLogger.getLogger().debug((Object)("EnvDataExplorer-> Requesting URL: " + wfsURL));
        String returned = null;
        try {
            returned = HttpRequest.sendGetRequest((String)wfsURL, null);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("EnvDataExplorer-> ERROR " + e.getLocalizedMessage()));
        }
        if (returned != null) {
            AnalysisLogger.getLogger().debug((Object)"EnvDataExplorer-> Found Intersection");
        } else {
            AnalysisLogger.getLogger().debug((Object)"EnvDataExplorer-> Found Nothing!");
        }
        return returned;
    }

    public static LinkedHashMap<String, Double> getFeatures(String geoserver, String layer, double x, double y) {
        try {
            AnalysisLogger.getLogger().debug((Object)("Calling WFS towards Geoserver:" + geoserver + " and layer:" + layer));
            String jsonString = EnvDataExplorer.callWFS(geoserver, layer, x, y);
            LinkedHashMap<String, Object> map = JsonMapper.parse(jsonString);
            LinkedHashMap mapout = (LinkedHashMap)((HashMap)map.get("features")).get("properties");
            LinkedHashMap<String, Double> values = new LinkedHashMap<String, Double>();
            for (String key : mapout.keySet()) {
                values.put(key, Double.parseDouble((String)mapout.get(key)));
            }
            return values;
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"EnvDataExplorer-> Error in getting properties");
            return null;
        }
    }

    public static List<FeaturedPolygon> getFeatures(String geoserver, String layer, double xL, double yL, double xR, double yR) {
        try {
            AnalysisLogger.getLogger().debug((Object)("Calling WFS towards Geoserver:" + geoserver + " and layer:" + layer));
            String jsonString = EnvDataExplorer.callWFS(geoserver, layer, xL, yL, xR, yR);
            LinkedHashMap<String, Object> map = JsonMapper.parse(jsonString);
            ArrayList<FeaturedPolygon> fpolygons = new ArrayList<FeaturedPolygon>();
            FeaturedPolygon poly = null;
            for (String key : map.keySet()) {
                if (!key.contains("features")) continue;
                HashMap propertiesMap = (HashMap)map.get(key);
                for (String properties : propertiesMap.keySet()) {
                    List<double[]> coords;
                    Geometry p;
                    LinkedHashMap props;
                    if (properties.contains("properties")) {
                        if (poly == null) {
                            poly = new FeaturedPolygon();
                        }
                        props = (LinkedHashMap)propertiesMap.get(properties);
                        for (String keyprop : props.keySet()) {
                            try {
                                String value = (String)props.get(keyprop);
                                try {
                                    String lowcaseprop = keyprop.toLowerCase();
                                    if (poly.value == null && !lowcaseprop.startsWith("id") && !lowcaseprop.endsWith("id")) {
                                        poly.setValue(Double.parseDouble(value));
                                        continue;
                                    }
                                    poly.addFeature(keyprop, value);
                                }
                                catch (Exception e2) {
                                    poly.addFeature(keyprop, value);
                                }
                            }
                            catch (Exception e) {}
                        }
                        continue;
                    }
                    if (!properties.contains("geometry") || properties.contains("geometry_")) continue;
                    if (poly == null) {
                        poly = new FeaturedPolygon();
                    } else if (poly.p != null) {
                        if (poly.value == null) {
                            poly.value = Double.NaN;
                        }
                        fpolygons.add(poly);
                        poly = new FeaturedPolygon();
                    }
                    if ((p = EnvDataExplorer.buildGeometryFromCoordinates(coords = EnvDataExplorer.WFS2Coordinates((props = (LinkedHashMap)propertiesMap.get(properties)).toString()))) == null) continue;
                    poly.setPolygon(p);
                }
            }
            if (poly != null) {
                if (poly.value == null) {
                    poly.value = Double.NaN;
                }
                fpolygons.add(poly);
            }
            return fpolygons;
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"EnvDataExplorer-> Error in getting properties");
            e.printStackTrace();
            return null;
        }
    }

    public static Geometry buildGeometryFromCoordinates(List<double[]> coords) {
        MultiPolygon p = null;
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 4326);
        int idx = -1;
        List<Object> coordinatesArray = new ArrayList<Coordinate>();
        ArrayList<Polygon> polys = new ArrayList<Polygon>();
        ArrayList<LinearRing> holespolys = new ArrayList<LinearRing>();
        int j = 1;
        int i = 1;
        for (double[] pair : coords) {
            Coordinate coordPair = new Coordinate(pair[0], pair[1]);
            idx = coordinatesArray.indexOf(coordPair);
            if (idx >= 0) {
                coordinatesArray.add(coordPair);
                if (idx == 0) {
                    ++j;
                    i = 1;
                    Polygon pp = EnvDataExplorer.sequence2Polygon(factory, coordinatesArray.subList(idx, coordinatesArray.size()), holespolys);
                    polys.add(pp);
                    coordinatesArray = new ArrayList();
                    continue;
                }
                ++i;
                LinearRing ring = EnvDataExplorer.sequence2Ring(factory, coordinatesArray.subList(idx, coordinatesArray.size()));
                holespolys.add(ring);
                coordinatesArray = coordinatesArray.subList(0, idx);
                continue;
            }
            coordinatesArray.add(coordPair);
        }
        if (polys.size() > 0) {
            ArrayList<Polygon> polysnoholes = new ArrayList<Polygon>();
            for (Polygon pp : polys) {
                boolean found = false;
                int h = 0;
                for (Polygon polnh : polysnoholes) {
                    boolean covers = false;
                    try {
                        covers = polnh.covers((Geometry)pp);
                    }
                    catch (Exception e) {
                        AnalysisLogger.getLogger().debug((Object)"Error in calculating superpositions: Snapping the geometries");
                        double snapTol = GeometrySnapper.computeOverlaySnapTolerance((Geometry)polnh, (Geometry)pp);
                        pp = (Polygon)EnvDataExplorer.selfSnap((Geometry)pp, snapTol);
                        polnh = (Polygon)EnvDataExplorer.selfSnap((Geometry)polnh, snapTol);
                        AnalysisLogger.getLogger().debug((Object)"Geometries have been snapped");
                        covers = polnh.covers((Geometry)pp);
                    }
                    if (covers) {
                        EnvDataExplorer.addDifference(h, polysnoholes, polnh, pp);
                        found = true;
                    } else if (pp.covers((Geometry)polnh)) {
                        EnvDataExplorer.addDifference(h, polysnoholes, pp, polnh);
                        found = true;
                    }
                    ++h;
                }
                if (found) continue;
                polysnoholes.add(pp);
            }
            Polygon[] polyrawarray = polysnoholes.toArray(new Polygon[polysnoholes.size()]);
            p = new MultiPolygon(polyrawarray, factory);
        }
        return p;
    }

    private static Geometry selfSnap(Geometry g, double snapTolerance) {
        GeometrySnapper snapper = new GeometrySnapper(g);
        Geometry snapped = snapper.snapTo(g, snapTolerance);
        Geometry fix = snapped.buffer(0.0);
        return fix;
    }

    private static void addDifference(int h, List<Polygon> polysnoholes, Polygon polnh, Polygon pp) {
        Geometry mp = polnh.difference((Geometry)pp);
        if (mp instanceof Polygon) {
            polysnoholes.set(h, (Polygon)mp);
        } else {
            MultiPolygon mup = (MultiPolygon)mp;
            int innerpolygons = mup.getNumGeometries();
            for (int k = 0; k < innerpolygons; ++k) {
                Polygon ip = (Polygon)mup.getGeometryN(k);
                polysnoholes.set(h, ip);
            }
        }
    }

    private static LinearRing sequence2Ring(GeometryFactory factory, List<Coordinate> coordinatesArray) {
        Coordinate[] coordrawarray = coordinatesArray.toArray(new Coordinate[coordinatesArray.size()]);
        CoordinateArraySequence coordseq = new CoordinateArraySequence(coordrawarray);
        LinearRing ring = new LinearRing((CoordinateSequence)coordseq, factory);
        return ring;
    }

    private static Polygon sequence2Polygon(GeometryFactory factory, List<Coordinate> coordinatesArray, List<LinearRing> holespolys) {
        Coordinate[] coordrawarray = coordinatesArray.toArray(new Coordinate[coordinatesArray.size()]);
        LinearRing[] holes = holespolys.toArray(new LinearRing[holespolys.size()]);
        CoordinateArraySequence coordseq = new CoordinateArraySequence(coordrawarray);
        LinearRing ring = new LinearRing((CoordinateSequence)coordseq, factory);
        Polygon p = new Polygon(ring, holes, factory);
        return p;
    }

    public static List<double[]> WFS2Coordinates(String wfsgeometry) {
        String[] coordinatePairs = null;
        ArrayList<double[]> dpairs = new ArrayList<double[]>();
        if (wfsgeometry.toLowerCase().contains("multipolygon")) {
            String coordString = "coordinates=";
            String coordinates = wfsgeometry.substring(wfsgeometry.indexOf(coordString) + coordString.length());
            if ((coordinates = coordinates.substring(coordinates.indexOf("=") + 1)).contains("=")) {
                coordinates = coordinates.replaceAll("([A-Za-z0-9]|-|_)+=", "");
                coordinates = coordinates.replaceAll("\\],( )+\\[", "],[");
            }
            for (String coord : coordinatePairs = coordinates.split("\\],\\[")) {
                coord = coord.replaceAll("(\\[|\\]|\\}|\\{|)", "");
                String[] coordpair = coord.split(",");
                double[] dd = new double[2];
                dd[1] = Double.parseDouble(coordpair[0]);
                dd[0] = Double.parseDouble(coordpair[1]);
                dpairs.add(dd);
            }
        }
        return dpairs;
    }

    public static void main1(String[] args) {
        String geom = "{type=MultiPolygon, coordinates={cce4daf3-966e-4b5f-adea-f88ea2b93d03=[[[-16,-146.49999999999997],[-16,-146.99999999999994],[-15.5,-146.99999999999994],[-15.5,-146.49999999999997],[-16,-146.49999999999997]]]}}";
        List<double[]> coords = EnvDataExplorer.WFS2Coordinates(geom);
        GeometryFactory factory = new GeometryFactory(new PrecisionModel(), 4326);
        if (coords != null) {
            Coordinate[] coordarray = new Coordinate[coords.size()];
            int i = 0;
            for (double[] pair : coords) {
                coordarray[i] = new Coordinate(pair[0], pair[1]);
                ++i;
            }
            CoordinateArraySequence coordseq = new CoordinateArraySequence(coordarray);
            LinearRing ring = new LinearRing((CoordinateSequence)coordseq, factory);
            Polygon p = new Polygon(ring, new LinearRing[0], factory);
            CoordinateArraySequence pcoords = new CoordinateArraySequence(new Coordinate[]{new Coordinate(-150.0, -16.0)});
            Point po = new Point((CoordinateSequence)pcoords, factory);
            System.out.println("contains: " + p.contains((Geometry)po) + " boundary: " + p.covers((Geometry)po));
        }
    }

    public static ArrayDouble.D3 arrayByte3DArrayDouble(ArrayByte bytes) {
        int[] shapeD = bytes.getShape();
        int zD = shapeD[0];
        int yD = shapeD[1];
        int xD = shapeD[2];
        AnalysisLogger.getLogger().debug((Object)(xD + "X" + yD + "X" + zD + "=" + xD * yD * zD));
        ArrayDouble.D3 doublea = new ArrayDouble.D3(zD, yD, xD);
        IndexIterator iterator = bytes.getIndexIterator();
        for (int x = 0; x < xD; ++x) {
            for (int y = 0; y < yD; ++y) {
                for (int z = 0; z < zD; ++z) {
                    Byte bytex = (Byte)iterator.next();
                    doublea.set(z, y, x, bytex.doubleValue());
                }
            }
        }
        return doublea;
    }

    public static ArrayDouble.D2 arrayByte2DArrayDouble(ArrayByte bytes) {
        int[] shapeD = bytes.getShape();
        int yD = shapeD[0];
        int xD = shapeD[1];
        AnalysisLogger.getLogger().debug((Object)(xD + "X" + yD + "=" + xD * yD));
        ArrayDouble.D2 doublea = new ArrayDouble.D2(yD, xD);
        IndexIterator iterator = bytes.getIndexIterator();
        for (int x = 0; x < xD; ++x) {
            for (int y = 0; y < yD; ++y) {
                Byte bytex = (Byte)iterator.next();
                doublea.set(y, x, bytex.doubleValue());
            }
        }
        return doublea;
    }

    public static void main(String[] args) {
        String q = "[[[-10.0011869534696,151.288335840039],[-10.0353384533966,151.27859643813],[-10.0228061679999,151.308700562],[-10.0011869534696,151.288335840039]]], e3c47901-3de5-45d2-a272-c6f7d5df1dec=[[[-8.54674625399991,150.53036499],[-8.83403205899992,150.287445068],[-9.20889866086486,150.195933942647],[-9.20555999999993,150.21039],[-9.20777999999995,150.23218],[-9.27360999999991,150.33095],[-9.38638999999995,150.37717],[-9.39873372345699,150.375441317138],[-9.37888717699991,150.41633606],[-9.64140796699991,150.411376953],[-9.68103313399996,150.684051514],[-9.79481071047286,150.758883440934],[-9.74832999999995,150.75027],[-9.73082999999991,150.74884],[-9.70784999999995,150.76262],[-9.7194399999999,150.78802],[-9.73138999999991,150.80304],[-9.74693999999994,150.82163],[-9.81916999999993,150.90026],[-9.85235999999992,150.93539],[-9.89360999999991,150.96274],[-9.98527999999993,151.03055],[-9.99693999999994,151.03943],[-10.0169399999999,151.05996],[-10.0244399999999,151.07303],[-10.0466,151.11809],[-10.0413899999999,151.13666],[-10.03014,151.14818],[-10.0194499999999,151.14875],[-10.0033999999999,151.13893],[-9.98916999999994,151.13637],[-9.94207999999991,151.18817],[-9.93666999999993,151.20053],[-9.93091343037411,151.222140060489],[-9.68598556499995,150.991424561],[-9.45813846599992,150.936889648],[-9.30954170199993,151.03604126],[-9.13122558599991,150.961669922],[-8.80926608999994,151.055862427],[-8.66848054747773,151.099704833311],[-8.63888999999995,151.10107],[-8.56673125859819,151.063276911059],[-8.52198028599992,150.922012329],[-8.54674625399991,150.53036499]],[[-9.43832999999995,150.66666],[-9.44124999999991,150.67997],[-9.42805999999996,150.73191],[-9.42055999999991,150.7462],[-9.40541999999993,150.7615],[-9.41471999999993,150.77777],[-9.43277999999992,150.80442],[-9.45638999999994,150.8283],[-9.52319999999992,150.88692],[-9.64471999999995,150.93219],[-9.65916999999996,150.93055],[-9.67082999999991,150.92163],[-9.68207999999993,150.90387],[-9.67221999999992,150.89177],[-9.67916999999994,150.87523],[-9.71805999999992,150.84692],[-9.68555999999995,150.84412],[-9.65860999999995,150.80163],[-9.66249999999991,150.76331],[-9.66332999999991,150.69135],[-9.66291999999993,150.65804],[-9.65388999999993,150.62274],[-9.62332999999995,150.51443],[-9.5836099999999,150.4905],[-9.44082999999995,150.42746],[-9.4313899999999,150.42331],[-9.41471999999993,150.41999],[-9.40110999999996,150.41999],[-9.38943999999992,150.4219],[-9.37666999999993,150.42609],[-9.35707999999994,150.43913],[-9.33770999999996,150.48044],[-9.34124999999994,150.5022],[-9.35166999999995,150.53028],[-9.37054999999992,150.57135],[-9.38499999999993,150.59802],[-9.40110999999996,150.62149],[-9.4233299999999,150.63734],[-9.43832999999995,150.66666]]], c905ab63-23c2-4587-bdd6-d6d37a56be51=[[[-8.58588343092737,151.123734225448],[-8.59127089890423,151.123748898655],[-8.58637142199996,151.125274658],[-8.58588343092737,151.123734225448]]], 8471299d-4904-4a10-ab00-c6cc5605bf3b=[[[-10.1228941076499,151.06827675758],[-10.1141699999999,151.02582],[-10.1108299999999,150.99831],[-10.1127799999999,150.98331],[-10.1127665622499,150.982996372512],[-10.1466360089999,151.011245728],[-10.1228941076499,151.06827675758]]], d0a0b923-b401-4cec-ac35-c3d8c837bffc=[[[-10.0506772730004,150.931209804608],[-10.0041699999999,150.91553],[-9.92666999999994,150.87774],[-9.83888999999993,150.8269],[-9.80718113528387,150.767019514441],[-10.0277585979999,150.912094116],[-10.0506772730004,150.931209804608]]]}}";
        q = q.replaceAll("([A-Za-z0-9]|-|_)+=", "");
        System.out.println(q);
        q = q.replaceAll("\\],( )+\\[", "],[");
        System.out.println(q);
    }
}

