/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.util.Arrays;

public class AscRaster {
    protected double[][] data;
    protected double xll;
    protected double yll;
    protected double cellsize;
    protected int cols;
    protected int rows;
    protected String NDATA;
    public static final String DEFAULT_NODATA = "-9999";

    public void print() {
        System.out.println("Rows: " + this.rows + " cols: " + this.cols + " cellsize " + this.cellsize);
        double[][] arr$ = this.data;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double[] row;
            for (double val : row = arr$[i$]) {
                System.out.print(val + " ");
            }
            System.out.println("");
        }
    }

    public AscRaster() {
    }

    public AscRaster(double cellsize, double xll, double yll) {
        this();
        this.setCellsize(cellsize);
        this.setXll(xll);
        this.setYll(yll);
    }

    public AscRaster(double[][] data, double cellsize, double xll, double yll) {
        this(cellsize, xll, yll);
        this.setData(data);
    }

    public AscRaster(int[][] data, double cellsize, double xll, double yll) {
        this(cellsize, xll, yll);
        this.setData(data);
    }

    public static AscRaster getTempRaster(double[][] data, double xll, double yll, double size) {
        return AscRaster.getTempRaster(data, xll, yll, size, DEFAULT_NODATA);
    }

    public static AscRaster getTempRaster(double[][] data, double xll, double yll, double size, String ndata) {
        AscRaster a = new AscRaster();
        a.data = data;
        a.xll = xll;
        a.yll = yll;
        a.cellsize = size;
        a.NDATA = ndata;
        a.rows = data.length;
        a.cols = data[0].length;
        return a;
    }

    public void init(AscRaster other) {
        this.xll = other.xll;
        this.yll = other.yll;
        this.cellsize = other.cellsize;
        this.NDATA = other.NDATA;
        this.setSize(other.getRows(), other.getCols());
    }

    public void initData() {
        this.initData(Double.NaN);
    }

    public void initData(double value) {
        this.data = new double[this.rows][];
        for (int i = 0; i < this.rows; ++i) {
            this.data[i] = new double[this.cols];
            Arrays.fill(this.data[i], value);
        }
    }

    public double[][] getData() {
        return this.data;
    }

    public void setValue(int row, int column, double value) {
        if (row < this.rows && column < this.cols) {
            this.data[row][column] = value;
        }
    }

    public double getValue(int row, int column) {
        if (row < this.rows && column < this.cols) {
            return this.data[row][column];
        }
        return Double.NaN;
    }

    public void setData(double[][] data) {
        this.rows = data.length;
        this.cols = data[0].length;
        this.initData();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = data[i][j];
            }
        }
    }

    public void setData(int[][] data) {
        this.rows = data.length;
        this.cols = data[0].length;
        this.initData();
        for (int i = 0; i < this.rows; ++i) {
            for (int j = 0; j < this.cols; ++j) {
                this.data[i][j] = data[i][j];
            }
        }
    }

    public double getXll() {
        return this.xll;
    }

    public void setXll(double xll) {
        this.xll = xll;
    }

    public double getYll() {
        return this.yll;
    }

    public void setYll(double yll) {
        this.yll = yll;
    }

    public double getCellsize() {
        return this.cellsize;
    }

    public void setCellsize(double cellsize) {
        this.cellsize = cellsize;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setSize(int nrows, int columns) {
        this.rows = nrows;
        this.cols = columns;
        this.initData();
    }

    public String getNDATA() {
        return this.NDATA;
    }

    public void setNDATA(String nDATA) {
        this.NDATA = nDATA;
    }
}

