/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.insertion;

import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.retrieval.GeoIntersector;
import org.gcube.dataanalysis.geo.utils.CSquareCodesConverter;
import org.hibernate.SessionFactory;

public class RasterTable {
    private double[][] valuesMatrix;
    double x1;
    double x2;
    double y1;
    double y2;
    double z;
    double xResolution;
    double yResolution;
    private AlgorithmConfiguration configuration;
    private String tablename = "rstr" + ("" + UUID.randomUUID()).replace("-", "");
    static String createTableStatement = "CREATE TABLE %1$s (id serial, csquarecode character varying, x real, y real, z real, probability real)";
    static String columnsnames = "csquarecode, x , y , z , probability";
    public static String csquareColumn = "csquarecode";
    public static String probabilityColumn = "probability";
    public static String idColumn = "id";

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public RasterTable(double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution, double[][] values, AlgorithmConfiguration configuration) {
        this.valuesMatrix = values;
        this.configuration = configuration;
        this.x1 = x1;
        this.x2 = x2;
        this.y1 = y1;
        this.y2 = y2;
        this.z = z;
        this.xResolution = xResolution;
        this.yResolution = yResolution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpGeoTable() {
        SessionFactory dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.configuration);
        try {
            AnalysisLogger.getLogger().debug((Object)"Database Initialized");
            DatabaseFactory.executeSQLUpdate((String)String.format(createTableStatement, this.tablename), (SessionFactory)dbconnection);
            AnalysisLogger.getLogger().debug((Object)("Table " + this.tablename + " created"));
            List<Tuple<Double>> coordinates = GeoIntersector.generateCoordinateTriplets(this.x1, this.x2, this.y1, this.y2, this.z, this.xResolution, this.yResolution);
            int triplets = coordinates.size();
            AnalysisLogger.getLogger().debug((Object)("Generated " + triplets + " coordinates triples"));
            List<Double> values = GeoIntersector.associateValueToCoordinates(coordinates, this.valuesMatrix);
            AnalysisLogger.getLogger().debug((Object)"Association to values completed - fulfilling buffer");
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < triplets; ++i) {
                Tuple<Double> cset = coordinates.get(i);
                double x = (Double)cset.getElements().get(0);
                double y = (Double)cset.getElements().get(1);
                String csquare = CSquareCodesConverter.convertAtResolution(y, x, this.xResolution);
                Double value = values.get(i);
                if (value.isNaN()) {
                    value = 0.0;
                }
                sb.append("('" + csquare + "'," + x + "," + y + "," + this.z + ",'" + value + "')");
                if (i % 5000 == 0) {
                    String insertStatement = DatabaseUtils.insertFromBuffer((String)this.tablename, (String)columnsnames, (StringBuffer)sb);
                    DatabaseFactory.executeSQLUpdate((String)insertStatement, (SessionFactory)dbconnection);
                    sb = new StringBuffer();
                    continue;
                }
                if (i >= triplets - 1) continue;
                sb.append(",");
            }
            AnalysisLogger.getLogger().debug((Object)("Inserting Final Buffer of " + sb.length() + " Values"));
            if (sb.length() > 0) {
                String insertStatement = DatabaseUtils.insertFromBuffer((String)this.tablename, (String)columnsnames, (StringBuffer)sb);
                DatabaseFactory.executeSQLUpdate((String)insertStatement, (SessionFactory)dbconnection);
                AnalysisLogger.getLogger().debug((Object)"Insertion completed with Success!");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("Error in dumping table: " + e.getLocalizedMessage()));
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
            AnalysisLogger.getLogger().debug((Object)"Raster Geo Table DB closed!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTable() {
        SessionFactory dbconnection = null;
        try {
            dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.configuration);
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.tablename), (SessionFactory)dbconnection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
        }
    }
}

