/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.StandardPointCollectionImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class ThreddsDataExplorer {
    public static String timePrefix = "time:";

    public static List<String> getFiles(String catalogURL) throws Exception {
        String xml = HttpRequest.sendGetRequest((String)catalogURL, null);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xpath.compile("//child::*[local-name()='catalog']/child::*[local-name()='dataset']/child::*[local-name()='dataset']");
        InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        NodeList nodes = (NodeList)xPathExpression.evaluate(inputSource, XPathConstants.NODESET);
        ArrayList<String> fileNames = new ArrayList<String>();
        int i = 0;
        while (i < nodes.getLength()) {
            Node node = nodes.item(i);
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            if (name != null) {
                fileNames.add(name);
            }
            ++i;
        }
        return fileNames;
    }

    public static LinkedHashMap<String, Double> retrieveDataFromNetCDF(String openDapLink, String layer, double x, double y, double z) {
        try {
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            if (ThreddsDataExplorer.isGridDataset(openDapLink)) {
                AnalysisLogger.getLogger().debug((Object)"Managing Grid File");
                return ThreddsDataExplorer.manageGridDataset(layer, openDapLink, x, y, z);
            }
            AnalysisLogger.getLogger().debug((Object)"Warning: the NETCDF file is of an unknown type");
            return map;
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("ERROR: " + e.getMessage()));
            AnalysisLogger.getLogger().debug((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    public static LinkedHashMap<String, Double> manageGridDataset(String layer, String filename, double x, double y, double z) throws Exception {
        LinkedHashMap<String, Double> valuesMap = new LinkedHashMap<String, Double>();
        GridDataset gds = GridDataset.open((String)filename);
        List gridTypes = gds.getGrids();
        for (GridDatatype gdt : gridTypes) {
            AnalysisLogger.getLogger().debug((Object)("Inside File - layer name: " + gdt.getFullName()));
            if (!layer.equalsIgnoreCase(gdt.getFullName())) continue;
            AnalysisLogger.getLogger().debug((Object)("Found layer " + layer + " inside file"));
            GridDatatype grid = gds.findGridDatatype(gdt.getName());
            GridCoordSystem gcs = grid.getCoordinateSystem();
            long timeSteps = 0L;
            Date[] dates = null;
            if (gcs.hasTimeAxis1D()) {
                CoordinateAxis1DTime tAxis1D = gcs.getTimeAxis1D();
                dates = tAxis1D.getTimeDates();
                timeSteps = dates.length;
            } else if (gcs.hasTimeAxis()) {
                CoordinateAxis tAxis = gcs.getTimeAxis();
                timeSteps = tAxis.getSize();
            }
            CoordinateAxis1D zAxis = gdt.getCoordinateSystem().getVerticalAxis();
            double resolutionZ = Math.abs((zAxis.getMaxValue() - zAxis.getMinValue()) / (double)zAxis.getShape()[0]);
            int zint = 0;
            if (resolutionZ > 0.0) {
                zint = (int)Math.round(z / resolutionZ);
            }
            AnalysisLogger.getLogger().debug((Object)("Z index to take: " + zint));
            int[] xy = gcs.findXYindexFromLatLon(y, x, null);
            int j = 0;
            while ((long)j < timeSteps) {
                try {
                    Array data = grid.readDataSlice(j, zint, xy[1], xy[0]);
                    Double val = ThreddsDataExplorer.takeFirstDouble(data);
                    if (!val.isNaN()) {
                        String date = "" + j;
                        if (dates != null) {
                            date = dates[j].toString();
                        }
                        valuesMap.put(String.valueOf(timePrefix) + date, Double.parseDouble("" + val));
                    }
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("Error in getting grid values in (" + x + "," + y + "," + z + "= with zint: " + zint + " resolution: " + resolutionZ + " and shape: " + zAxis.getShape()[0]));
                }
                ++j;
            }
            break block2;
        }
        return valuesMap;
    }

    public static Double takeFirstDouble(Array data) {
        long datal = data.getSize();
        Double val = Double.NaN;
        try {
            int k = 0;
            while ((long)k < datal) {
                Double testVal = data.getDouble(k);
                if (!testVal.isNaN()) {
                    val = testVal;
                    break;
                }
                ++k;
            }
        }
        catch (Exception ee) {
            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> WARNING: Error in getting value: " + ee.getLocalizedMessage()));
        }
        return val;
    }

    public LinkedHashMap<String, String> managePointsDataset(String layer, String filename, double x, double y) throws Exception {
        LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
        float tolerance = 0.25f;
        Formatter errlog = new Formatter();
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)filename, null, (Formatter)errlog);
        PointDatasetImpl ds = (PointDatasetImpl)fdataset;
        List lfc = ds.getPointFeatureCollectionList();
        Iterator iterator = lfc.iterator();
        if (iterator.hasNext()) {
            FeatureCollection fc = (FeatureCollection)iterator.next();
            StandardPointCollectionImpl spf = (StandardPointCollectionImpl)fc;
            PointFeatureIterator iter = null;
            while (y - (double)tolerance > -90.0 && x - (double)tolerance > -180.0 && y + (double)tolerance < 90.0 && x + (double)tolerance < 180.0) {
                LatLonRect rect = new LatLonRect((LatLonPoint)new LatLonPointImpl(y - (double)tolerance, x - (double)tolerance), (LatLonPoint)new LatLonPointImpl(y + (double)tolerance, x + (double)tolerance));
                PointFeatureCollection coll = spf.subset(rect, null);
                iter = coll.getPointFeatureIterator(100000);
                if (iter.getCount() != 0) break;
                iter.finish();
                AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> tolerance = " + (tolerance += 0.25f)));
            }
            if (iter != null) {
                try {
                    while (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> EarthLoc: " + pf.getLocation()));
                        AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> EarthTime: " + pf.getObservationTime()));
                        StructureData sd = pf.getData();
                        List mems = sd.getMembers();
                        for (StructureMembers.Member m : mems) {
                            String unit = m.getUnitsString();
                            if (unit == null || unit.length() <= 0) continue;
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> description: " + m.getDescription()));
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> data param: " + m.getDataParam()));
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> name: " + m.getName()));
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> unit: " + m.getUnitsString()));
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> type: " + m.getDataType()));
                            Array arr = sd.getArray(m.getName());
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> is Time: " + m.getDataType()));
                            Double val = ThreddsDataExplorer.takeFirstDouble(arr);
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> extracted value: " + val));
                        }
                        AnalysisLogger.getLogger().debug((Object)"ThreddsDataExplorer-> EarthTime: ");
                    }
                }
                finally {
                    iter.finish();
                }
            }
        }
        return valuesMap;
    }

    public static boolean isGridDataset(String filename) {
        try {
            AnalysisLogger.getLogger().debug((Object)("Analyzing file " + filename));
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.GRID, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                AnalysisLogger.getLogger().debug((Object)"ThreddsDataExplorer-> NOT GRID");
            }
            return true;
        }
        finally {
            return false;
        }
    }

    public static boolean isPointDataset(String filename) {
        try {
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                AnalysisLogger.getLogger().debug((Object)"ThreddsDataExplorer-> NOT POINT");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDataset(String filename) throws Exception {
        boolean isdataset = false;
        try {
            Formatter errlog = new Formatter();
            FeatureType[] fts = FeatureType.values();
            int i = 0;
            while (i < fts.length) {
                FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)fts[i], (String)filename, null, (Formatter)errlog);
                if (fdataset != null) {
                    AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> " + fts[i] + " OK!"));
                    isdataset = true;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isdataset;
    }

    public static double adjX(double x) {
        return x;
    }

    public static double adjY(double y) {
        return y;
    }

    public static double getMinX(GridCoordSystem gcs) {
        CoordinateAxis xAxis = gcs.getXHorizAxis();
        return ThreddsDataExplorer.adjX(xAxis.getMinValue());
    }

    public static double getMaxX(GridCoordSystem gcs) {
        CoordinateAxis xAxis = gcs.getXHorizAxis();
        return ThreddsDataExplorer.adjX(xAxis.getMaxValue());
    }

    public static double getMinY(GridCoordSystem gcs) {
        CoordinateAxis yAxis = gcs.getYHorizAxis();
        return ThreddsDataExplorer.adjY(yAxis.getMinValue());
    }

    public static double getMaxY(GridCoordSystem gcs) {
        CoordinateAxis yAxis = gcs.getYHorizAxis();
        return ThreddsDataExplorer.adjY(yAxis.getMaxValue());
    }
}

