package org.gcube.dataanalysis.geo.utils;

import java.util.HashMap;
import java.util.LinkedHashMap;

import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.geo.meta.OGCFormatter;

public class EnvDataExplorer {

	private static String callWFS(String geoServer, String layer, double x, double y) {

		float tolerance = 0.25f;
		String wfsURL  = OGCFormatter.getWfsUrl(geoServer, layer, OGCFormatter.pointToBoundingBox(x, y, tolerance), 1, "json");
		AnalysisLogger.getLogger().debug("EnvDataExplorer-> Requesting URL: " + wfsURL);
		String returned = null;
		try {
			returned = HttpRequest.sendGetRequest(wfsURL, null);
		} catch (Exception e) {
			AnalysisLogger.getLogger().debug("EnvDataExplorer-> ERROR " + e.getLocalizedMessage());
		}
		if (returned != null)
			AnalysisLogger.getLogger().debug("EnvDataExplorer-> Found Intersection: " + returned);
		else
			AnalysisLogger.getLogger().debug("EnvDataExplorer-> Found Nothing!");

		return returned;
	}

	public static LinkedHashMap<String, Double> getFeatures(String geoserver, String layer, double x, double y) {
		try {
			String jsonString = callWFS(geoserver, layer, x, y);
			LinkedHashMap<String, Object> map = JsonMapper.parse(jsonString);
			LinkedHashMap<String, String> mapout = (LinkedHashMap<String, String>) ((HashMap<String, Object>) map.get("features")).get("properties");
			LinkedHashMap<String, Double> values =  new LinkedHashMap<String, Double>();
			for (String key:mapout.keySet()){
				values.put(key, Double.parseDouble(mapout.get(key)));
			}
			return values;
		} catch (Exception e) {
			AnalysisLogger.getLogger().debug("EnvDataExplorer-> Error in getting properties");
			return null;
		}
	}
}
