/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.trendylyzeralgorithms;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.HistogramGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.postgresql.Driver;

public class SimpleAlgorithm
extends StandardLocalInfraAlgorithm {
    static String urlParameterName = "DatabaseURL";
    static String userParameterName = "DatabaseUserName";
    static String passwordParameterName = "DatabasePassword";
    Class driverClass;
    Driver driver;
    Connection connection = null;
    LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    private DefaultCategoryDataset defaultcategorydataset;
    private String species = "Species";

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization");
        String driverName = "org.postgresql.Driver";
        this.driverClass = Class.forName(driverName);
        this.driver = (Driver)this.driverClass.newInstance();
    }

    public String getDescription() {
        return null;
    }

    protected void process() throws Exception {
        String userSelectedSp = this.getInputParameter(this.species);
        String databaseJdbc = this.getInputParameter(urlParameterName);
        String databaseUser = this.getInputParameter(userParameterName);
        String databasePwd = this.getInputParameter(passwordParameterName);
        this.connection = DriverManager.getConnection(databaseJdbc, databaseUser, databasePwd);
        Statement stmt = this.connection.createStatement();
        String query = "SELECT numberOfObservation FROM public.count_species_per_year WHERE tname =" + this.species;
        ResultSet rs = stmt.executeQuery(query);
        int i = 0;
        String s = "Species";
        while (rs.next()) {
            String count = rs.getString("numberOfObservation");
            int countOcc = Integer.parseInt(count);
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)count, PrimitiveTypes.STRING, this.species, this.species);
            this.map.put(this.species, (StatisticalType)val);
            if (i >= 16) break;
            this.defaultcategorydataset.addValue((double)countOcc, (Comparable)((Object)s), (Comparable)((Object)this.species));
            ++i;
        }
        this.connection.close();
    }

    protected void setInputParameters() {
        this.addStringInput(this.species, "Slected species", "Solea solea");
        this.addRemoteDatabaseInput("TrendyLyzerObis", urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap((HashMap)this.outputParameters), PrimitiveTypes.MAP, "Discrepancy Analysis", "");
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Gaussian Distribution for the errors");
        HashMap<String, Image> producedImages = new HashMap<String, Image>();
        JFreeChart chart = HistogramGraph.createStaticChart((Dataset)this.defaultcategorydataset);
        Image image = ImageTools.toImage((BufferedImage)chart.createBufferedImage(680, 420));
        producedImages.put("Species Observations", image);
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), producedImages, PrimitiveTypes.IMAGES, "ErrorRepresentation", "Graphical representation of the error spread");
        AnalysisLogger.getLogger().debug((Object)"Bar Charts Species Occurrences Produced");
        this.map.put("Result", (StatisticalType)p);
        this.map.put("Images", (StatisticalType)images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }
}

