package org.gcube.dataanalysis.test;

import java.util.List;
import java.util.UUID;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;

public class TestAverageAnnualPrecipitation {

	/**
	 * @param args
	 */
	public static void main(String[] args) throws Exception {

		System.out.println("TEST of PREC ALGO 1");
		List<ComputationalAgent> trans = null;
		trans = TransducerersFactory.getTransducerers(testConfig());
		trans.get(0).init();
		Regressor.process(trans.get(0));
		StatisticalType st = trans.get(0).getOutput();
		trans = null;
	}

	private static AlgorithmConfiguration testConfig() {
		AlgorithmConfiguration config = Regressor.getConfig();
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		
		config.setAgent("AVERAGE_ANNUAL_PREC");

		config.setParam("DatabaseUserName","postgres");
		config.setParam("DatabasePassword","postgres");
		config.setParam("DatabaseURL","jdbc:postgresql://localhost");
		config.setParam("DatabaseDriver","org.postgresql.Driver");
	    config.setParam("PrecTable", "test");
		config.setParam("PrecColumns", "day" + AlgorithmConfiguration.listSeparator + "precipitation");
		String tablename = "testprec" + (UUID.randomUUID());

		config.setParam("OutputTableName", "Test Prec");
		config.setParam("OutputTable", tablename.replace("-", ""));

		return config;
	}

}
