/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.DatabaseParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;

public abstract class StandardLocalExternalAlgorithm
implements Transducerer {
    protected AlgorithmConfiguration config;
    protected float status = 0.0f;
    protected List<StatisticalType> inputs = new ArrayList<StatisticalType>();
    protected ResourceFactory resourceManager;
    protected LinkedHashMap<String, String> outputParameters = new LinkedHashMap();

    protected void addEnumerateInput(Object itemsList, String name, String description, String defaultvalue) {
        this.inputs.add((StatisticalType)new PrimitiveType(Enum.class.getName(), itemsList, PrimitiveTypes.ENUMERATED, name, description, defaultvalue));
    }

    protected void addRemoteDatabaseInput(String runtimeResourceName, String urlParameterName, String userParameterName, String passwordParameterName, String driverParameterName, String dialectParameterName) {
        this.inputs.add((StatisticalType)new DatabaseType(DatabaseParameters.REMOTEDATABASERRNAME, runtimeResourceName, "RR name"));
        this.inputs.add((StatisticalType)new DatabaseType(DatabaseParameters.REMOTEDATABASEURL, urlParameterName, ""));
        this.inputs.add((StatisticalType)new DatabaseType(DatabaseParameters.REMOTEDATABASEUSERNAME, userParameterName, ""));
        this.inputs.add((StatisticalType)new DatabaseType(DatabaseParameters.REMOTEDATABASEPASSWORD, passwordParameterName, ""));
        this.inputs.add((StatisticalType)new DatabaseType(DatabaseParameters.REMOTEDATABASEDRIVER, driverParameterName, ""));
        this.inputs.add((StatisticalType)new DatabaseType(DatabaseParameters.REMOTEDATABASEDIALECT, dialectParameterName, ""));
    }

    protected void addStringInput(String name, String description, String defaultvalue) {
        this.inputs.add((StatisticalType)new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, name, description, defaultvalue));
    }

    protected void addOutputString(String name, String value) {
        this.outputParameters.put(name, value);
    }

    public void compute() throws Exception {
        AnalysisLogger.setLogger((String)(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        this.status = 0.0f;
        this.process();
        this.status = 100.0f;
    }

    protected void log(Object message) {
        AnalysisLogger.getLogger().trace(message);
    }

    public abstract void init() throws Exception;

    public abstract String getDescription();

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    public List<StatisticalType> getInputParameters() {
        this.setInputParameters();
        return this.inputs;
    }

    protected String getInputParameter(String paramName) {
        return this.config.getParam(paramName);
    }

    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap(this.outputParameters), PrimitiveTypes.MAP, "Species Match", "");
        return p;
    }

    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    public String getResources() {
        return ResourceFactory.getResources((float[])new float[]{100.0f});
    }

    public float getStatus() {
        return this.status;
    }

    protected abstract void process() throws Exception;

    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    protected abstract void setInputParameters();

    public abstract void shutdown();
}

