/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.trendylyzeralgorithms;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.TimeSeriesGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DynamicEnum;
import org.gcube.dataanalysis.trendylyzeralgorithms.Util;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.time.Year;
import org.postgresql.Driver;

public class SpeciesObservationsPerLMEAreaPerYearLineChart
extends StandardLocalExternalAlgorithm {
    static String databaseName = "DatabaseName";
    static String userParameterName = "DatabaseUserName";
    static String passwordParameterName = "DatabasePassword";
    static String urlParameterName = "DatabaseURL";
    private String yearStart = "Start Year";
    private String yearEnd = "End Year";
    private Hashtable areaTable = new Hashtable();
    private static String area = "AreaType";
    private String choseArea = "Area Name:";
    private String selectedAreaName;
    static int justcall = 0;
    private String[] speciesNames;
    LMEenum enuArea = new LMEenum();
    private TimeSeriesCollection dataset;
    protected String fileName;
    BufferedWriter out;
    Connection connection = null;
    String year_start;
    String year_end;
    String table = "count_species_per_lme_per_year";
    String areaName = "lme_name";
    String databaseJdbc = new String();
    String databaseUser = new String();
    String databasePwd = new String();

    protected void setInputParameters() {
        this.addRemoteDatabaseInput("Obis2Repository", urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
        if (justcall == 0) {
            justcall = 1;
            try {
                this.queryArea(this.getStaticConnection());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.addEnumerateInput(LMEenumType.values(), area, "Choose the area name", Util.formatAreaName("NORTH SEA"));
        this.addStringInput(this.yearStart, "Starting year of the analysis", "1800");
        this.addStringInput(this.yearEnd, "Ending year of the analysis", "2020");
        PrimitiveTypesList speciesSelected = new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, "Selected species", "List of the species to analyze", false);
        this.inputs.add(speciesSelected);
    }

    public void queryArea(Connection connection) throws SQLException {
        AnalysisLogger.getLogger().debug((Object)"call queryArea");
        String query = "select distinct(upper(lme_name)) as lme_name from geo.lme order by lme_name";
        Statement stmt = connection.createStatement();
        ResultSet rs = stmt.executeQuery(query);
        while (rs.next()) {
            String area = rs.getString("lme_name");
            AnalysisLogger.getLogger().debug((Object)area);
            this.enuArea.addEnum(LMEenumType.class, area);
        }
        connection.close();
    }

    public Connection getStaticConnection() throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        Class.forName("org.postgresql.Driver");
        Connection connection = null;
        connection = DriverManager.getConnection("jdbc:postgresql://obis2.i-marine.research-infrastructures.eu/obis", "postgres", "0b1s@d4sc13nc3");
        return connection;
    }

    public void shutdown() {
    }

    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap((HashMap)this.outputParameters), PrimitiveTypes.MAP, "", "");
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Line Chart for the errors");
        HashMap<String, Image> producedImages = new HashMap<String, Image>();
        JFreeChart chart = TimeSeriesGraph.createStaticChart((Dataset)this.dataset, (String)"yyyy");
        Image image = ImageTools.toImage((BufferedImage)chart.createBufferedImage(680, 420));
        producedImages.put("Selected species observations per LME area(" + this.selectedAreaName + ")", image);
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), producedImages, PrimitiveTypes.IMAGES, "ErrorRepresentation", "Selected species observations per LME area (" + this.selectedAreaName + ")");
        AnalysisLogger.getLogger().debug((Object)"Line Taxonomy Occurrences Produced");
        LinkedHashMap<String, PrimitiveType> map = new LinkedHashMap<String, PrimitiveType>();
        PrimitiveType f = new PrimitiveType(File.class.getName(), (Object)new File(this.fileName), PrimitiveTypes.FILE, "Species observations per area", "ObsFile");
        map.put("Output", f);
        map.put("Result", p);
        map.put("Images", images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization SpeciesObservationsPerAreaPerYearLineChart");
    }

    public String getDescription() {
        return "Algorithm returning most observed species in a specific years range (data collected from OBIS database).";
    }

    public void fulfilParameters() throws IOException {
        this.dataset = new TimeSeriesCollection();
        this.year_start = this.getInputParameter(this.yearStart);
        this.year_end = this.getInputParameter(this.yearEnd);
        this.table = "count_species_per_lme_per_year";
        this.areaName = "lme_name";
        this.selectedAreaName = this.getInputParameter(area);
        AnalysisLogger.getLogger().debug((Object)("*********NAMEE*******" + this.selectedAreaName));
        this.databaseJdbc = this.getInputParameter(urlParameterName);
        this.databaseUser = this.getInputParameter(userParameterName);
        this.databasePwd = this.getInputParameter(passwordParameterName);
        this.fileName = this.config.getPersistencePath() + "results.csv";
        this.out = new BufferedWriter(new FileWriter(this.fileName));
    }

    protected void process() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Starto to process");
        String driverName = "org.postgresql.Driver";
        Class<?> driverClass = Class.forName(driverName);
        Driver driver = (Driver)driverClass.newInstance();
        this.fulfilParameters();
        this.connection = DriverManager.getConnection(this.databaseJdbc, this.databaseUser, this.databasePwd);
        Statement stmt = this.connection.createStatement();
        for (String spe : this.speciesNames = this.config.getParam("Selected species").split(AlgorithmConfiguration.getListSeparator())) {
            String query = "select lme_name,year,count from " + this.table + " where upper(tname) like upper('" + spe + "') and upper(lme_name) like '" + this.selectedAreaName + "' and year::integer >=" + this.year_start + "AND year::integer <=" + this.year_end + " order by year;";
            AnalysisLogger.getLogger().debug((Object)query);
            ResultSet rs = stmt.executeQuery(query);
            TimeSeries series = new TimeSeries((Comparable)((Object)spe));
            while (rs.next()) {
                if (rs.getString("year") == null) continue;
                AnalysisLogger.getLogger().debug((Object)(rs.getString("year") + " count " + rs.getString("count")));
                int year = Integer.parseInt(rs.getString("year"));
                int count = Integer.parseInt(rs.getString("count"));
                this.write(spe + "," + year + "," + count);
                series.add((RegularTimePeriod)new Year(year), (double)count);
            }
            this.dataset.addSeries(series);
        }
        AnalysisLogger.getLogger().debug((Object)this.dataset.toString());
        this.connection.close();
        this.out.close();
    }

    public void write(String writeSt) {
        try {
            this.out.write(writeSt);
            this.out.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class LMEenum
    extends DynamicEnum {
        LMEenum() {
        }

        public Field[] getFields() {
            Field[] fields = LMEenumType.class.getDeclaredFields();
            return fields;
        }
    }

    static enum LMEenumType {

    }
}

