/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.trendylyzeralgorithms;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.HistogramGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.trendylyzeralgorithms.AreaEnum;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.postgresql.Driver;

public class SpeciesObservationsAreaBarChart
extends StandardLocalExternalAlgorithm {
    static String databaseName = "DatabaseName";
    static String userParameterName = "DatabaseUserName";
    static String passwordParameterName = "DatabasePassword";
    static String urlParameterName = "DatabaseURL";
    private String species = "Species :";
    private String yearStart = "Start year :";
    private String yearEnd = "End year :";
    private String area = "Area :";
    private String selectedSpecies;
    private DefaultCategoryDataset defaultcategorydataset;
    private LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    String databaseJdbc;
    String year_start;
    String year_end;
    String databaseUser;
    String chosenArea;
    String databasePwd;
    String table;
    String areaName;
    Connection connection = null;
    protected String fileName;
    BufferedWriter out;

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"SpeciesObservationsAreaBarChart Initialization");
    }

    public String getDescription() {
        return "An algorithm producing a bar chart for the distribution of a species along a certain type of marine area (e.g. LME or MEOW)";
    }

    public void fulfilParameters() throws IOException {
        this.databaseJdbc = this.getInputParameter(urlParameterName);
        this.year_start = this.getInputParameter(this.yearStart);
        this.year_end = this.getInputParameter(this.yearEnd);
        this.selectedSpecies = this.getInputParameter(this.species);
        this.databaseUser = this.getInputParameter(userParameterName);
        this.chosenArea = this.getInputParameter(this.area);
        this.databasePwd = this.getInputParameter(passwordParameterName);
        this.table = "count_species_per_lme_per_year";
        this.areaName = "lme_name";
        if (this.chosenArea.equals("LME")) {
            this.table = "count_species_per_lme_per_year";
            this.areaName = "lme_name";
        } else if (this.chosenArea.equals("MEOW")) {
            this.table = "count_species_per_meow_per_year";
            this.areaName = "ecoregion";
        }
        this.fileName = this.config.getPersistencePath() + "results.csv";
        this.out = new BufferedWriter(new FileWriter(this.fileName));
    }

    private ResultSet performeQuery() throws SQLException {
        this.connection = DriverManager.getConnection(this.databaseJdbc, this.databaseUser, this.databasePwd);
        Statement stmt = this.connection.createStatement();
        String query = "SELECT  tname," + this.areaName + " ,sum(count) AS count FROM " + this.table + " WHERE upper(tname) like upper('" + this.selectedSpecies + "') AND year::integer >=" + this.year_start + "AND year::integer <=" + this.year_end + "GROUP BY tname ," + this.areaName + " ORDER BY count desc;";
        return stmt.executeQuery(query);
    }

    protected void process() throws Exception {
        this.defaultcategorydataset = new DefaultCategoryDataset();
        String driverName = "org.postgresql.Driver";
        Class<?> driverClass = Class.forName(driverName);
        Driver driver = (Driver)driverClass.newInstance();
        this.fulfilParameters();
        ResultSet rs = this.performeQuery();
        String s = this.selectedSpecies;
        while (rs.next()) {
            String ar = rs.getString(this.areaName);
            String count = rs.getString("count");
            PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)count, PrimitiveTypes.STRING, ar, ar);
            this.write(ar + "," + count);
            this.map.put(ar, (StatisticalType)val);
            int countOcc = Integer.parseInt(count);
            this.defaultcategorydataset.addValue((double)countOcc, (Comparable)((Object)s), (Comparable)((Object)ar));
        }
        this.connection.close();
        this.out.close();
    }

    protected void setInputParameters() {
        this.addStringInput(this.species, "The species to analyze", "");
        this.addEnumerateInput(AreaEnum.values(), this.area, "Choose the area type", AreaEnum.LME.name());
        this.addStringInput(this.yearStart, "Starting year of the analysis", "1800");
        this.addStringInput(this.yearEnd, " Ending year of the analysis", "2020");
        this.addRemoteDatabaseInput("Obis2Repository", urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }

    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap((HashMap)this.outputParameters), PrimitiveTypes.MAP, "", "");
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Bar Chart for the errors");
        HashMap<String, Image> producedImages = new HashMap<String, Image>();
        JFreeChart chart = HistogramGraph.createStaticChart((Dataset)this.defaultcategorydataset);
        Image image = ImageTools.toImage((BufferedImage)chart.createBufferedImage(680, 420));
        producedImages.put("Most observed species", image);
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), producedImages, PrimitiveTypes.IMAGES, "Most observed species", "Most observed species");
        AnalysisLogger.getLogger().debug((Object)"Bar Charts Species Occurrences Produced");
        PrimitiveType f = new PrimitiveType(File.class.getName(), (Object)new File(this.fileName), PrimitiveTypes.FILE, "Species observations per area", "ObsFile");
        this.map.put("Output", (StatisticalType)f);
        this.map.put("Result", (StatisticalType)p);
        this.map.put("Images", (StatisticalType)images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }

    public void write(String writeSt) {
        try {
            this.out.write(writeSt);
            this.out.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

