/**
 * 
 */
package org.gcube.dataanalysis.datasetimporter.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

/**
 * @author Paolo Fabriani
 *
 */
public class TimeUtil {

    public static String toString(Calendar c) {
        if(c==null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(c.getTime());
    }

    public static Calendar toCalendar(String s) throws ParseException {
        if(s==null || s.trim().isEmpty()) {
            return null;
        }
        String[] formats = {
                "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'",
                "yyyy-MM-dd HH:mm:ss",
                "yyyy-MM-dd",
                "yyyyMMdd",
                "yyyyMM",
                "yyyy"
        };
        ParseException outException = null;
        for(String f:formats) {
            SimpleDateFormat format = new SimpleDateFormat(f);
            Calendar c = Calendar.getInstance();
            try {
                c.setTime(format.parse(s));
                return c;
            } catch (ParseException e) {
                outException = e;
                continue;
            }
        }
        throw outException;
    }

    public static Calendar getStartOfNextDay(Calendar c) {
        if(c==null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = c.get(Calendar.YEAR);
        int month = c.get(Calendar.MONTH);
        int day = c.get(Calendar.DATE);
        calendar.set(year, month, day, 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        calendar.add(Calendar.DATE, 1);
        return calendar;
    }
    
    public static Calendar getEndOfDay(Calendar c) {
        if(c==null) {
            return null;
        }
        Calendar out = getStartOfNextDay(c);
        out.add(Calendar.MILLISECOND, -1);
        return out;
    }

    public static Calendar getStartOfNextMonth(Calendar c) {
        if(c==null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = c.get(Calendar.YEAR);
        int month = c.get(Calendar.MONTH);
        calendar.set(year, month, 1, 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        calendar.add(Calendar.MONTH, 1);
        return calendar;
    }

    public static Calendar getEndOfMonth(Calendar c) {
        if(c==null) {
            return null;
        }
        Calendar out = getStartOfNextMonth(c);
        out.add(Calendar.MILLISECOND, -1);
        return out;
    }

    public static Calendar getStartOfNextYear(Calendar c) {
        if(c==null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = c.get(Calendar.YEAR);
        calendar.set(year, 0, 1, 0, 0, 0);
        calendar.set(Calendar.MILLISECOND, 0);
        calendar.add(Calendar.YEAR, 1);
        return calendar;
    }

    public static Calendar getEndOfYear(Calendar c) {
        if(c==null) {
            return null;
        }
        Calendar out = getStartOfNextYear(c);
        out.add(Calendar.MILLISECOND, -1);
        return out;
    }


}
