/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.datasetimporter.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class TimeUtil {
    public static String toString(Calendar c) {
        if (c == null) {
            return null;
        }
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(c.getTime());
    }

    public static Calendar toCalendar(String s) throws ParseException {
        if (s == null || s.trim().isEmpty()) {
            return null;
        }
        String[] formats = new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd", "yyyyMMdd", "yyyyMM", "yyyy"};
        ParseException outException = null;
        for (String f : formats) {
            SimpleDateFormat format = new SimpleDateFormat(f);
            Calendar c = Calendar.getInstance();
            try {
                c.setTime(format.parse(s));
                return c;
            }
            catch (ParseException e) {
                outException = e;
            }
        }
        throw outException;
    }

    public static Calendar getStartOfNextDay(Calendar c) {
        if (c == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        calendar.set(year, month, day, 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(5, 1);
        return calendar;
    }

    public static Calendar getEndOfDay(Calendar c) {
        if (c == null) {
            return null;
        }
        Calendar out = TimeUtil.getStartOfNextDay(c);
        out.add(14, -1);
        return out;
    }

    public static Calendar getStartOfNextMonth(Calendar c) {
        if (c == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2);
        calendar.set(year, month, 1, 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(2, 1);
        return calendar;
    }

    public static Calendar getEndOfMonth(Calendar c) {
        if (c == null) {
            return null;
        }
        Calendar out = TimeUtil.getStartOfNextMonth(c);
        out.add(14, -1);
        return out;
    }

    public static Calendar getStartOfNextYear(Calendar c) {
        if (c == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        int year = c.get(1);
        calendar.set(year, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        calendar.add(1, 1);
        return calendar;
    }

    public static Calendar getEndOfYear(Calendar c) {
        if (c == null) {
            return null;
        }
        Calendar out = TimeUtil.getStartOfNextYear(c);
        out.add(14, -1);
        return out;
    }
}

