/**
 * 
 */
package org.gcube.dataanalysis.datasetimporter.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

/**
 * @author Paolo Fabriani
 *
 */
public class PropertiesUtils {

    public static Map<String, String> getPropertiesFromFile(String path) throws IOException {
        return getProperties(new File(path));
    }

    /**
     * Parse lines in a properties and return <key,value> pairs.
     * @param f
     * @return
     * @throws IOException
     */
    public static Map<String, String> getProperties(File f) throws IOException {
        return getProperties(getLines(f));
    }

    /**
     * 
     * @param lines
     * @return
     */
    public static Map<String, String> getProperties(List<String> lines) {
        Map<String, String> out = new HashMap<>();
        for(String line:lines) {
            int i = line.indexOf(":");
            if(i==-1) {
                continue;
            }
            String key = line.substring(0, i);
            String value = line.substring(i+1);
            out.put(key,  value);
        }
        return out;
    }
    /**
     * Read a file and return all lines.
     * @param file
     * @return
     * @throws IOException
     */
    public static List<String> getLines(File file) throws IOException {
        List<String> out = new Vector<>();
        try (BufferedReader br = new BufferedReader(new FileReader(file))) {
            for (String line; (line = br.readLine()) != null;) {
                out.add(line);
            }
        }
        return out;
    }
    
}
