/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.codegeneration;

import java.util.HashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.StatisticalTypeToWPSType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClassGenerator.class);
    public static String configPath = "./cfg/";
    public static String generationPath = "./src/main/java/org/gcube/dataanalysis/wps/statisticalmanager/synchserver/mappedclasses/";
    public StatisticalTypeToWPSType converter = new StatisticalTypeToWPSType();

    public void generateEcologicalEngineClasses() throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath(configPath);
        HashMap algorithms = ProcessorsFactory.getAllFeatures((AlgorithmConfiguration)config);
        for (String algorithmSet : algorithms.keySet()) {
            List parametersList = (List)algorithms.get(algorithmSet);
            LOGGER.trace(algorithmSet + ":" + parametersList.toString());
            for (String algorithm : parametersList) {
                LOGGER.trace("Algorithm: " + algorithm);
                String description = "";
                String name = "";
                StringBuffer classWriter = new StringBuffer();
                List inputs = null;
                StatisticalType outputs = null;
                name = algorithm;
                config.setAgent(algorithm);
                config.setModel(algorithm);
                config.setAlgorithmClassLoader(Thread.currentThread().getContextClassLoader());
                String packageString = "";
                String interfaceString = "";
                try {
                    if (algorithmSet.equals("DISTRIBUTIONS")) {
                        packageString = "generators";
                        interfaceString = "IGenerator";
                        inputs = GeneratorsFactory.getAlgorithmParameters((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                        description = GeneratorsFactory.getDescription((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                        outputs = GeneratorsFactory.getAlgorithmOutput((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                    } else if (algorithmSet.equals("TRANSDUCERS")) {
                        packageString = "transducerers";
                        interfaceString = "ITransducer";
                        inputs = TransducerersFactory.getTransducerParameters((AlgorithmConfiguration)config, (String)algorithm);
                        description = TransducerersFactory.getDescription((AlgorithmConfiguration)config, (String)algorithm);
                        outputs = TransducerersFactory.getTransducerOutput((AlgorithmConfiguration)config, (String)algorithm);
                    } else if (algorithmSet.equals("MODELS")) {
                        packageString = "modellers";
                        interfaceString = "IModeller";
                        inputs = ModelersFactory.getModelParameters((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                        description = ModelersFactory.getDescription((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                        outputs = ModelersFactory.getModelOutput((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                    } else if (algorithmSet.equals("CLUSTERERS")) {
                        packageString = "clusterers";
                        interfaceString = "IClusterer";
                        inputs = ClusterersFactory.getClustererParameters((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                        description = ClusterersFactory.getDescription((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                        outputs = ClusterersFactory.getClustererOutput((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                    } else if (!algorithmSet.equals("TEMPORAL_ANALYSIS") && algorithmSet.equals("EVALUATORS")) {
                        packageString = "evaluators";
                        interfaceString = "IEvaluator";
                        inputs = EvaluatorsFactory.getEvaluatorParameters((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                        description = EvaluatorsFactory.getDescription((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                        outputs = EvaluatorsFactory.getEvaluatorOutput((String)configPath, (String)algorithm, (AlgorithmConfiguration)config);
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Error in retrieving output: ", (Throwable)e);
                }
                classWriter.append(((String)StatisticalTypeToWPSType.templates.get("package")).replace("#PACKAGE#", packageString) + "\n" + (String)StatisticalTypeToWPSType.templates.get("import") + "\n");
                LOGGER.trace("Class preamble: \n" + classWriter.toString());
                String classdescription = (String)StatisticalTypeToWPSType.templates.get("description");
                classdescription = classdescription.replace("#TITLE#", name).replace("#ABSTRACT#", description).replace("#CLASSNAME#", name).replace("#PACKAGE#", packageString);
                LOGGER.trace("Class description : \n" + classdescription);
                String classdefinition = (String)StatisticalTypeToWPSType.templates.get("class_definition");
                classdefinition = classdefinition.replace("#CLASSNAME#", name).replace("#INTERFACE#", interfaceString);
                LOGGER.trace("Class definition: \n" + classdefinition);
                classWriter.append(classdescription + "\n");
                classWriter.append(classdefinition + "\n");
                for (StatisticalType input : inputs) {
                    LOGGER.trace("input is {}", (Object)input);
                    String wpsInput = this.converter.convert2WPSType(input, true, config);
                    if (wpsInput == null) continue;
                    classWriter.append(wpsInput + "\n");
                    LOGGER.trace("Input:\n {}", (Object)wpsInput);
                }
                if (outputs != null) {
                    LOGGER.trace("Alg. Output:\n {}", (Object)outputs);
                    String wpsOutput = this.converter.convert2WPSType(outputs, false, config);
                    classWriter.append(wpsOutput + "\n");
                    LOGGER.trace("Output:\n  {}", (Object)wpsOutput);
                } else {
                    LOGGER.trace("Output is empty!");
                }
                classWriter.append(StatisticalTypeToWPSType.templates.getProperty("optionalOutput") + "\n");
                classWriter.append((String)StatisticalTypeToWPSType.templates.get("class_closure"));
                LOGGER.trace("Class:\n {}", (Object)classWriter.toString());
                LOGGER.trace("Saving...");
                FileTools.saveString((String)(generationPath + packageString + "/" + algorithm + ".java"), (String)classWriter.toString(), (boolean)true, (String)"UTF-8");
            }
        }
    }
}

