package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;

import net.opengis.wps.x100.ProcessDescriptionType;

import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.server.IAlgorithm;
import org.n52.wps.server.IAlgorithmRepository;
import org.reflections.Reflections;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.util.FilterBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GcubeAlgorithmRepository implements IAlgorithmRepository {

	private static long UPDATE_TIME_IN_MILLIS = 60000;

	private static Logger log = LoggerFactory.getLogger(GcubeAlgorithmRepository.class);

	//private static GcubeAlgorithmRepository instance= new GcubeAlgorithmRepository();

	private static Long lastUpdate = 0l;

	private static Reflections reflection;


	public GcubeAlgorithmRepository(){
		updateRepository();
	}

	public ProcessDescriptionType getProcessDescription(String identifier){
		updateRepository();
		log.info("getProcessDescription with identifier {} ",identifier);
		try{
			Set<Class<?>> classes = reflection.getTypesAnnotatedWith(Algorithm.class);	
			for (Class<?> _class: classes){
				if (_class.getAnnotation(Algorithm.class).identifier().equals(identifier)){
					return ((IAlgorithm)_class.newInstance()).getDescription();
				}
			}
		}catch(Exception e){}
		throw new RuntimeException(String.format("Algorithm with process id %s not found", identifier));
	}

	public boolean containsAlgorithm(String identifier) {
		updateRepository();
		log.info("containsAlgorithm with identifier {} ",identifier);
		Set<Class<?>> classes = reflection.getTypesAnnotatedWith(Algorithm.class);	
		for (Class<?> _class: classes){
			if (_class.getAnnotation(Algorithm.class).identifier().equals(identifier)){
				return true;
			}
		}
		return false;
	}

	public IAlgorithm getAlgorithm(String identifier){
		updateRepository();
		log.info("getAlgorithm with identifier {} ",identifier);
		try{
			Set<Class<?>> classes = reflection.getTypesAnnotatedWith(Algorithm.class);	
			for (Class<?> _class: classes){
				if (_class.getAnnotation(Algorithm.class).identifier().equals(identifier)){
					if (IAlgorithm.class.isAssignableFrom(_class)){
						return (IAlgorithm)_class.newInstance();
					} else {
						log.warn("found algorothm class {} is no assignable from {}",_class.getName(), IAlgorithm.class.getName());
						break;
					}
				}
			}
		}catch(Exception e){}
		throw new RuntimeException(String.format("Algorithm with id %s not found", identifier));
	}

	public static Set<Class<?>> getAllAlgorithms() {
		updateRepository();
		return reflection.getTypesAnnotatedWith(Algorithm.class);
	}

	private static synchronized void updateRepository(){
		if ((System.currentTimeMillis()-lastUpdate)>UPDATE_TIME_IN_MILLIS){
			log.info("update time passed, updating repository");
			String packageToFind = "org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses";
			ConfigurationBuilder confBuilder = new ConfigurationBuilder()
			.filterInputsBy(new FilterBuilder().include(FilterBuilder.prefix(packageToFind)))
			.setUrls(ClasspathHelper.forClassLoader());
			reflection = new Reflections(confBuilder);
			lastUpdate = System.currentTimeMillis();
		}
	}

	@Override
	public Collection<String> getAlgorithmNames() {
		updateRepository();
		Collection<String> toReturn = new ArrayList<String>(); 
		Set<Class<?>> classes = reflection.getTypesAnnotatedWith(Algorithm.class);	
		for (Class<?> _class: classes){
			toReturn.add(_class.getAnnotation(Algorithm.class).title());
		}
		return toReturn;
	}

	@Override
	public void shutdown() {
		lastUpdate = 0l;
		reflection = null;
	}
}
