/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.map.CaseInsensitiveMap;
import org.apache.commons.io.IOUtils;
import org.gcube.common.authorization.library.AuthorizedTasks;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.capabilities.GetCapabilitiesBuilder;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.web.ExecuteRequest;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.web.ExecuteResponse;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.WebProcessingService;
import org.n52.wps.server.handler.RequestExecutor;
import org.n52.wps.server.request.CapabilitiesRequest;
import org.n52.wps.server.request.DescribeProcessRequest;
import org.n52.wps.server.request.Request;
import org.n52.wps.server.request.RetrieveResultRequest;
import org.n52.wps.server.response.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class RequestHandler {
    public static final String VERSION_ATTRIBUTE_NAME = "version";
    protected static RequestExecutor pool = new RequestExecutor();
    protected OutputStream os;
    private static Logger LOGGER = LoggerFactory.getLogger(RequestHandler.class);
    protected String responseMimeType;
    protected Request req;
    private Map<String, String[]> params;

    protected RequestHandler() {
    }

    public RequestHandler(Map<String, String[]> params, OutputStream os) throws ExceptionReport {
        Object req;
        String requestType;
        this.os = os;
        this.params = params;
        CaseInsensitiveMap ciMap = new CaseInsensitiveMap(params);
        String serviceType = Request.getMapValue((String)"service", (CaseInsensitiveMap)ciMap, (boolean)true);
        if (!serviceType.equalsIgnoreCase("WPS")) {
            throw new ExceptionReport("Parameter <service> is not correct, expected: WPS, got: " + serviceType, "InvalidParameterValue", "service");
        }
        String language = Request.getMapValue((String)"language", (CaseInsensitiveMap)ciMap, (boolean)false);
        if (language != null) {
            Request.checkLanguageSupported((String)language);
        }
        if ((requestType = Request.getMapValue((String)"request", (CaseInsensitiveMap)ciMap, (boolean)true)).equalsIgnoreCase("GetCapabilities")) {
            req = new CapabilitiesRequest(ciMap);
        } else if (requestType.equalsIgnoreCase("DescribeProcess")) {
            req = new DescribeProcessRequest(ciMap);
        } else if (requestType.equalsIgnoreCase("Execute")) {
            req = new ExecuteRequest(ciMap);
            this.setResponseMimeType((ExecuteRequest)((Object)req));
        } else if (requestType.equalsIgnoreCase("RetrieveResult")) {
            req = new RetrieveResultRequest(ciMap);
        } else {
            throw new ExceptionReport("The requested Operation is not supported or not applicable to the specification: " + requestType, "OperationNotSupported", requestType);
        }
        this.req = req;
    }

    public RequestHandler(InputStream is, OutputStream os) throws ExceptionReport {
        String nodeURI;
        String localName;
        String nodeName;
        Document doc;
        String version = null;
        this.os = os;
        boolean isCapabilitiesNode = false;
        try {
            System.out.println("Parsing Document...");
            System.setProperty("javax.xml.parsers.DocumentBuilderFactory", "org.apache.xerces.jaxp.DocumentBuilderFactoryImpl");
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setNamespaceAware(true);
            doc = fac.newDocumentBuilder().parse(is);
            System.out.println("Document Parsing OK");
            Node child = doc.getFirstChild();
            while (child.getNodeName().compareTo("#comment") == 0) {
                child = child.getNextSibling();
            }
            System.out.println("Skipped comments OK");
            nodeName = child.getNodeName();
            localName = child.getLocalName();
            nodeURI = child.getNamespaceURI();
            Node versionNode = child.getAttributes().getNamedItem(VERSION_ATTRIBUTE_NAME);
            System.out.println("Version OK");
            Node serviceNode = child.getAttributes().getNamedItem("service");
            if (serviceNode == null) {
                throw new ExceptionReport("Parameter <service> not specified.", "MissingParameterValue", "service");
            }
            if (!serviceNode.getNodeValue().equalsIgnoreCase("WPS")) {
                throw new ExceptionReport("Parameter <service> not specified.", "InvalidParameterValue", "service");
            }
            System.out.println("Service Node OK");
            isCapabilitiesNode = nodeName.toLowerCase().contains("capabilities");
            if (versionNode == null && !isCapabilitiesNode) {
                throw new ExceptionReport("Parameter <version> not specified.", "MissingParameterValue", VERSION_ATTRIBUTE_NAME);
            }
            if (!isCapabilitiesNode) {
                version = child.getAttributes().getNamedItem(VERSION_ATTRIBUTE_NAME).getNodeValue();
            }
            System.out.println("Capabilities Node OK");
            Node languageNode = child.getAttributes().getNamedItem("language");
            if (languageNode != null) {
                String language = languageNode.getNodeValue();
                Request.checkLanguageSupported((String)language);
            }
            System.out.println("Language Node OK " + languageNode);
        }
        catch (SAXException e) {
            throw new ExceptionReport("There went something wrong with parsing the POST data: " + e.getMessage(), "NoApplicableCode", (Throwable)e);
        }
        catch (IOException e) {
            throw new ExceptionReport("There went something wrong with the network connection.", "NoApplicableCode", (Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new ExceptionReport("There is a internal parser configuration error", "NoApplicableCode", (Throwable)e);
        }
        if (!isCapabilitiesNode && version == null) {
            System.out.println("EXCEPTION: Parameter <version> not specified.MissingParameterValue version");
            throw new ExceptionReport("Parameter <version> not specified.", "MissingParameterValue", VERSION_ATTRIBUTE_NAME);
        }
        if (!isCapabilitiesNode && !version.equals("1.0.0")) {
            System.out.println("EXCEPTION: Version not supported.InvalidParameterValueversion");
            throw new ExceptionReport("Version not supported.", "InvalidParameterValue", VERSION_ATTRIBUTE_NAME);
        }
        if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("Execute")) {
            System.out.println("Detected Request to Execute!");
            this.req = new ExecuteRequest(doc);
            this.setResponseMimeType((ExecuteRequest)this.req);
            System.out.println("Request to Execute Configured!");
        } else if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("GetCapabilities")) {
            System.out.println("Detected GetCapabilities!");
            this.req = new CapabilitiesRequest(doc);
            this.responseMimeType = "text/xml";
        } else if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE) && localName.equals("DescribeProcess")) {
            System.out.println("Detected DescribeProcess!");
            this.req = new DescribeProcessRequest(doc);
            this.responseMimeType = "text/xml";
        } else {
            if (!localName.equals("Execute")) {
                System.out.println("EXCEPTION Detected NON-supported Request The requested Operation not supported or not applicable to the specification: " + nodeName + "OperationNotSupported" + localName);
                throw new ExceptionReport("The requested Operation not supported or not applicable to the specification: " + nodeName, "OperationNotSupported", localName);
            }
            if (nodeURI.equals(WebProcessingService.WPS_NAMESPACE)) {
                System.out.println("specified namespace is not supported: " + nodeURI + "InvalidParameterValue");
                throw new ExceptionReport("specified namespace is not supported: " + nodeURI, "InvalidParameterValue");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle() throws ExceptionReport {
        Response resp = null;
        if (this.req == null) {
            throw new ExceptionReport("Internal Error", "");
        }
        if (this.req instanceof ExecuteRequest) {
            System.out.println("Request for execution");
            ExecuteRequest execReq = (ExecuteRequest)this.req;
            System.out.println("Accepted request for execution");
            execReq.updateStatusAccepted();
            Callable execCallable = AuthorizedTasks.bind((Callable)((Object)execReq));
            ExceptionReport exceptionReport = null;
            try {
                if (execReq.isStoreResponse()) {
                    System.out.println("Execution with output storing");
                    resp = new ExecuteResponse(execReq);
                    InputStream is = resp.getAsStream();
                    IOUtils.copy((InputStream)is, (OutputStream)this.os);
                    is.close();
                    pool.submit(execCallable);
                    return;
                }
                try {
                    System.out.println("Execution without storing output");
                    try {
                        resp = (Response)pool.submit(execCallable).get();
                    }
                    catch (ExecutionException ee) {
                        LOGGER.warn("exception while handling ExecuteRequest.");
                        System.out.println("exception while handling ExecuteRequest.");
                        ee.printStackTrace();
                        if (ee.getCause() instanceof ExceptionReport) {
                            exceptionReport = (ExceptionReport)ee.getCause();
                        }
                        exceptionReport = new ExceptionReport("An error occurred in the computation: " + ee.getMessage(), "NoApplicableCode");
                    }
                    catch (InterruptedException ie) {
                        LOGGER.warn("interrupted while handling ExecuteRequest.");
                        System.out.println("interrupted while handling ExecuteRequest.");
                        exceptionReport = new ExceptionReport("The computation in the process was interrupted.", "NoApplicableCode");
                    }
                }
                finally {
                    if (exceptionReport != null) {
                        LOGGER.debug("ExceptionReport not null: " + exceptionReport.getMessage());
                        System.out.println("ExceptionReport not null: " + exceptionReport.getMessage());
                        throw exceptionReport;
                    }
                    if (resp == null) {
                        LOGGER.warn("null response handling ExecuteRequest.");
                        System.out.println("null response handling ExecuteRequest.");
                        throw new ExceptionReport("Problem with handling threads in RequestHandler", "NoApplicableCode");
                    }
                    if (!execReq.isStoreResponse()) {
                        InputStream is = resp.getAsStream();
                        IOUtils.copy((InputStream)is, (OutputStream)this.os);
                        is.close();
                        LOGGER.info("Served ExecuteRequest.");
                        System.out.println("Served ExecuteRequest.");
                    }
                }
            }
            catch (RejectedExecutionException ree) {
                LOGGER.warn("exception handling ExecuteRequest.", (Throwable)ree);
                System.out.println("exception handling ExecuteRequest." + ree.getLocalizedMessage());
                throw new ExceptionReport("The requested process was rejected. Maybe the server is flooded with requests.", "ServerBusy");
            }
            catch (Exception e) {
                LOGGER.error("exception handling ExecuteRequest.", (Throwable)e);
                System.out.println("exception handling ExecuteRequest." + e.getLocalizedMessage());
                if (e instanceof ExceptionReport) {
                    throw (ExceptionReport)((Object)e);
                }
                throw new ExceptionReport("Could not read from response stream.", "NoApplicableCode");
            }
        } else {
            resp = this.req.call();
            try {
                InputStream is = null;
                if (this.req instanceof CapabilitiesRequest) {
                    GetCapabilitiesBuilder builder = new GetCapabilitiesBuilder();
                    String getCapabilitiesStringFromInfra = "";
                    try {
                        getCapabilitiesStringFromInfra = builder.buildGetCapabilities(this.params);
                    }
                    catch (Exception e) {
                        throw new ExceptionReport("Error in building GetCapabilities", "getcapabilities", (Throwable)e);
                    }
                    is = IOUtils.toInputStream((String)getCapabilitiesStringFromInfra, (String)"UTF-8");
                } else {
                    is = resp.getAsStream();
                }
                IOUtils.copy((InputStream)is, (OutputStream)this.os);
                is.close();
            }
            catch (IOException e) {
                throw new ExceptionReport("Could not read from response stream.", "NoApplicableCode");
            }
        }
    }

    protected void setResponseMimeType(ExecuteRequest req) {
        this.responseMimeType = req.isRawData() ? req.getExecuteResponseBuilder().getMimeType() : "text/xml";
    }

    public String getResponseMimeType() {
        if (this.responseMimeType == null) {
            return "text/xml";
        }
        return this.responseMimeType.toLowerCase();
    }
}

