/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.lang.StringEscapeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GML2CSV {
    public static void main(String[] args) throws Exception {
        GML2CSV.parseGML("test.gml", "test.csv");
    }

    public static void convertHTMLToXML(String gmlhtmlFile, String gmlxmlFile) throws Exception {
        BufferedWriter filew = new BufferedWriter(new FileWriter(new File(gmlxmlFile)));
        BufferedReader filer = new BufferedReader(new FileReader(new File(gmlhtmlFile)));
        String line = filer.readLine();
        while (line != null) {
            filew.write(StringEscapeUtils.unescapeHtml((String)line) + "\n");
            line = filer.readLine();
        }
        filer.close();
        filew.close();
    }

    public static void parseGML(String gmlFile, String csvFile) {
        try {
            String gmlXMLFile = gmlFile + ".xml";
            GML2CSV.convertHTMLToXML(gmlFile, gmlXMLFile);
            gmlFile = gmlXMLFile;
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            final BufferedWriter filew = new BufferedWriter(new FileWriter(new File(csvFile)));
            DefaultHandler handler = new DefaultHandler(){
                String lastTagContent = "";
                int tagcounter = 0;
                int maxtags = 0;
                boolean startrecording = false;
                boolean skiprecording = false;
                boolean headerwritten = false;
                ArrayList<String> row = new ArrayList();
                ArrayList<String> header = new ArrayList();

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equals("gml:featureMember")) {
                        this.startrecording = true;
                    }
                    if (this.startrecording && qName.equals("ogr:geometryProperty")) {
                        this.skiprecording = true;
                    }
                    if (this.startrecording & !this.skiprecording) {
                        ++this.tagcounter;
                        if (this.maxtags < this.tagcounter) {
                            this.maxtags = this.tagcounter;
                        }
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.startrecording && !this.skiprecording) {
                        if (this.tagcounter == this.maxtags) {
                            if (this.lastTagContent != null && this.lastTagContent.trim().length() > 0) {
                                this.row.add(this.lastTagContent);
                                String headerStr = qName.substring(qName.indexOf(":") + 1);
                                this.header.add(headerStr);
                            }
                        } else {
                            try {
                                if (this.row.size() > 0) {
                                    if (!this.headerwritten) {
                                        String stringheader = GML2CSV.Array2CSVString(this.header);
                                        filew.write(stringheader + "\n");
                                        this.headerwritten = true;
                                    }
                                    String stringrow = GML2CSV.Array2CSVString(this.row);
                                    filew.write(stringrow + "\n");
                                    this.row = new ArrayList();
                                }
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        --this.tagcounter;
                    }
                    if (qName.equals("ogr:geometryProperty")) {
                        this.skiprecording = false;
                    }
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.startrecording & !this.skiprecording) {
                        String element;
                        this.lastTagContent = element = new String(ch, start, length);
                    }
                }
            };
            saxParser.parse(gmlFile, handler);
            filew.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String Array2CSVString(ArrayList<String> row) {
        StringBuffer sb = new StringBuffer();
        int rowl = row.size();
        for (int i = 0; i < rowl; ++i) {
            String csvr = row.get(i).trim();
            if (csvr.contains(",")) {
                csvr = "\"" + csvr + "\"";
            }
            sb.append(csvr);
            if (i >= rowl - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }
}

