/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import java.io.File;
import java.io.InputStream;
import java.net.Inet4Address;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.n52.wps.commons.WPSConfig;

public class ConfigurationManager {
    public static String serviceUserNameParameterVariable = "ServiceUserName";
    public static String processingSessionVariable = "Session";
    public static String webpathVariable = "WebPath";
    public static String webPersistencePathVariable = "";
    public static String usernameParameter = "user.name";
    public static String scopeParameter = "scope";
    public static String defaultScope = "/gcube/devsec";
    public static String defaultUsername = "statistical.wps";
    private static Integer maxComputations = null;
    private static Boolean useStorage = null;
    static boolean simulationMode = false;
    private AlgorithmConfiguration config;
    private String scope;
    private String username;

    public static synchronized Integer getMaxComputations() {
        return maxComputations;
    }

    public static synchronized Boolean useStorage() {
        return useStorage;
    }

    public static synchronized Boolean isSimulationMode() {
        return simulationMode;
    }

    public void getInitializationProperties() {
        try {
            if (maxComputations == null) {
                Properties options = new Properties();
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("templates/setup.cfg");
                options.load(is);
                is.close();
                maxComputations = Integer.parseInt(options.getProperty("maxcomputations"));
                useStorage = Boolean.parseBoolean(options.getProperty("saveond4sstorage"));
                simulationMode = Boolean.parseBoolean(options.getProperty("simulationMode"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getScope() {
        return this.scope;
    }

    public String getUsername() {
        return this.username;
    }

    public ConfigurationManager() {
        this.getInitializationProperties();
    }

    public AlgorithmConfiguration getConfig() {
        return this.config;
    }

    public void configAlgorithmEnvironment(LinkedHashMap<String, Object> inputs) throws Exception {
        String host;
        this.config = new AlgorithmConfiguration();
        String webperspath = String.valueOf(WPSConfig.getConfigDir()) + "../persistence/";
        String persistencePath = String.valueOf(WPSConfig.getConfigDir()) + "../ecocfg/";
        String configPath = persistencePath;
        if (!new File(configPath).isDirectory()) {
            configPath = "./cfg/";
            persistencePath = "./";
        }
        System.out.println("Taking configuration from " + new File(configPath).getAbsolutePath() + " and persistence in " + persistencePath);
        this.config.setPersistencePath(persistencePath);
        this.config.setConfigPath(configPath);
        this.config.setNumberOfResources(Integer.valueOf(1));
        AnalysisLogger.setLogger((String)(String.valueOf(configPath) + "/" + AlgorithmConfiguration.defaultLoggerFile));
        AnalysisLogger.getLogger().debug((Object)("Taking configuration from " + configPath + " and persistence in " + persistencePath));
        String webapp = WPSConfig.getInstance().getWPSConfig().getServer().getWebappPath();
        if (webapp == null) {
            webapp = "wps";
        }
        if ((host = WPSConfig.getInstance().getWPSConfig().getServer().getHostname()).toLowerCase().equals("localhost")) {
            host = Inet4Address.getLocalHost().getHostAddress();
        }
        String port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        AnalysisLogger.getLogger().debug((Object)("Host: " + host + " Port: " + port + " Webapp: " + webapp + " "));
        AnalysisLogger.getLogger().debug((Object)("Web persistence path: " + webperspath));
        String webPath = "http://" + host + ":" + port + "/" + webapp + "/persistence/";
        AnalysisLogger.getLogger().debug((Object)("Web app path: " + webPath));
        this.scope = (String)inputs.get(scopeParameter);
        AnalysisLogger.getLogger().debug((Object)("Retrieved scope: " + this.scope));
        if (this.scope == null) {
            throw new Exception("Error: scope parameter (scope) not set! This violates e-Infrastructure security policies");
        }
        if (!this.scope.startsWith("/")) {
            this.scope = "/" + this.scope;
        }
        this.username = (String)inputs.get(usernameParameter);
        AnalysisLogger.getLogger().debug((Object)("User name used by the client: " + this.username));
        if (this.username == null || this.username.trim().length() == 0) {
            throw new Exception("Error: user name parameter (user.name) not set! This violates e-Infrastructure security policies");
        }
        this.config.setGcubeScope(this.scope);
        this.config.setParam(serviceUserNameParameterVariable, this.username);
        this.config.setParam(processingSessionVariable, "" + UUID.randomUUID());
        this.config.setParam(webpathVariable, webPath);
        this.config.setParam(webPersistencePathVariable, webperspath);
    }
}

