/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.process;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Algorithm;
import org.gcube.dataanalysis.dataminer.poolmanager.datamodel.Dependency;

/*
 * Exception performing whole class analysis ignored.
 */
public class AlgorithmPackageParser {
    private static final String METADATA_FILE_NAME = "Info.txt";
    private static final String METADATA_ALGORITHM_NAME = "Algorithm Name";
    private static final String METADATA_ALGORITHM_DESCRIPTION = "Algorithm Description";
    private static final String METADATA_CLASS_NAME = "Class Name";
    private static final String METADATA_PACKAGES = "Packages";
    private static final String METADATA_KEY_VALUE_SEPARATOR = ":";
    private static final int BUFFER_SIZE = 4096;

    public Algorithm parsePackage(String url) throws IOException {
        String packageMetadata = this.getPackageMetadata(url);
        if (packageMetadata == null) {
            System.out.println("WARNING: No metadata found for " + url);
            return null;
        }
        Map parsedMetadata = this.parseMetadata(packageMetadata);
        Algorithm a = this.createAlgorithm(parsedMetadata);
        a.setPackageURL(url);
        return a;
    }

    private String getPackageMetadata(String url) throws IOException {
        InputStream is = new URL(url).openStream();
        ZipInputStream zipIs = new ZipInputStream(is);
        ZipEntry entry = zipIs.getNextEntry();
        String out = null;
        while (entry != null) {
            if ("Info.txt".equalsIgnoreCase(entry.getName())) {
                out = this.getEntryContent(zipIs);
                break;
            }
            entry = zipIs.getNextEntry();
        }
        is.close();
        zipIs.close();
        return out;
    }

    private String getEntryContent(ZipInputStream zipIn) throws IOException {
        StringBuilder s = new StringBuilder();
        byte[] buffer = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(buffer)) != -1) {
            s.append(new String(buffer, 0, read));
        }
        return s.toString();
    }

    private Map<String, List<String>> parseMetadata(String metadata) {
        HashMap<String, List<String>> out = new HashMap<String, List<String>>();
        String[] lines = metadata.split("\n");
        String key = null;
        String value = null;
        for (String line : lines) {
            if (line.trim().isEmpty()) continue;
            String[] parts = line.split(":");
            if (parts.length > 1) {
                key = parts[0].trim();
                value = line.substring(parts[0].length() + 1).trim();
            } else if (parts.length == 1) {
                if (line.trim().endsWith(":")) {
                    key = parts[0].trim();
                    value = null;
                } else {
                    value = line.trim();
                }
            }
            if (key == null || value == null) continue;
            Vector<String> values = (Vector<String>)out.get(key);
            if (values == null) {
                values = new Vector<String>();
                out.put(key, values);
            }
            values.add(value);
            System.out.println(key + ":" + " " + values);
        }
        return out;
    }

    private Algorithm createAlgorithm(Map<String, List<String>> metadata) {
        List cdependencies;
        List gitdependencies;
        List osdependencies;
        List defdependencies;
        Algorithm out = new Algorithm();
        out.setName(AlgorithmPackageParser.extractSingleValue(metadata, (String)"Algorithm Name"));
        out.setDescription(AlgorithmPackageParser.extractSingleValue(metadata, (String)"Algorithm Description"));
        out.setClazz(AlgorithmPackageParser.extractSingleValue(metadata, (String)"Class Name"));
        List rdependencies = AlgorithmPackageParser.extractMultipleValues(metadata, (String)"cran");
        if (rdependencies != null) {
            for (Object pkg : rdependencies) {
                Dependency dep = new Dependency();
                dep.setName((String)pkg);
                dep.setType("cran");
                out.addDependency(dep);
            }
        }
        if ((defdependencies = AlgorithmPackageParser.extractMultipleValues(metadata, (String)"Packages")) != null) {
            for (Object pkg : defdependencies) {
                Dependency dep = new Dependency();
                dep.setName((String)pkg);
                dep.setType("os");
                out.addDependency(dep);
            }
        }
        if ((osdependencies = AlgorithmPackageParser.extractMultipleValues(metadata, (String)"os")) != null) {
            for (Object pkg : osdependencies) {
                Dependency dep = new Dependency();
                dep.setName((String)pkg);
                dep.setType("os");
                out.addDependency(dep);
            }
        }
        if ((gitdependencies = AlgorithmPackageParser.extractMultipleValues(metadata, (String)"github")) != null) {
            for (String pkg : gitdependencies) {
                Dependency dep = new Dependency();
                dep.setName(pkg);
                dep.setType("github");
                out.addDependency(dep);
            }
        }
        if ((cdependencies = AlgorithmPackageParser.extractMultipleValues(metadata, (String)"custom")) != null) {
            for (String pkg : cdependencies) {
                Dependency dep = new Dependency();
                dep.setName(pkg);
                dep.setType("custom");
                out.addDependency(dep);
            }
        }
        return out;
    }

    private static String extractSingleValue(Map<String, List<String>> metadata, String key) {
        List<String> l = metadata.get(key);
        if (l != null && l.size() == 1) {
            return l.get(0);
        }
        return null;
    }

    private static List<String> extractMultipleValues(Map<String, List<String>> metadata, String key) {
        List<String> l = metadata.get(key);
        if (l != null) {
            return new Vector<String>(l);
        }
        return null;
    }
}

