/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.service.validation;

import java.util.Calendar;
import java.util.Collection;
import java.util.Vector;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ChunkTimespan;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ValidationError;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsProduct;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.Variable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class RequestValidator {
    private static Logger logger = LoggerFactory.getLogger(RequestValidator.class);
    private static final String MOTU = "motu (m)";
    private static final String PRODUCT = "product (p)";
    private static final String DATASET = "dataset (d)";
    private static final String XLO = "xlo";
    private static final String XHI = "xhi";
    private static final String YLO = "ylo";
    private static final String YHI = "yhi";
    private static final String ZLO = "zlo";
    private static final String ZHI = "zhi";
    private static final String TLO = "tlo";
    private static final String THI = "thi";
    private static final String VARIABLE = "variable (v)";
    private static final String BACKTIME = "backTime (b)";
    private static final String CHUNKSPAN = "chunkSpan (s)";
    private static final String SCHEDULE = "importSchedule (f)";

    public static Collection<ValidationError> validateForProductMetadata(ImportOptions options) {
        Vector<ValidationError> out = new Vector<ValidationError>();
        out.addAll(RequestValidator.checkSet((String)"product (p)", (Object)options.getProduct()));
        out.addAll(RequestValidator.checkSet((String)"dataset (d)", (Object)options.getDataset()));
        return out;
    }

    public static Collection<ValidationError> checkScheduleOptions(ImportOptions options) throws Exception {
        Vector<ValidationError> errors = new Vector<ValidationError>();
        Integer backTime = options.getBackTime();
        if (backTime != null && backTime < 0) {
            errors.add(new ValidationError("backTime (b)", "backTime (b) can't be negative"));
        }
        return errors;
    }

    public static ImportOptions applyDefaults(ImportOptions options, CmemsProduct product) {
        if (RequestValidator.isEmpty((Object)options.getMotu())) {
            options.setMotu(product.getMotuServer());
        }
        return options;
    }

    public static ImportOptions applyDefaults(ImportOptions options, ProductMetadataInfo product) {
        if (RequestValidator.isEmpty((Object)options.gettLo())) {
            options.settLo(product.getFirstAvailableTimeCode());
        }
        if (RequestValidator.isEmpty((Object)options.gettHi())) {
            options.settHi(product.getLastAvailableTimeCode());
        }
        if (RequestValidator.isEmpty((Object)options.getxLo())) {
            options.setxLo(Double.valueOf(Double.parseDouble(product.getXAxis().getLower())));
        }
        if (RequestValidator.isEmpty((Object)options.getxHi())) {
            options.setxHi(Double.valueOf(Double.parseDouble(product.getXAxis().getUpper())));
        }
        if (RequestValidator.isEmpty((Object)options.getyLo())) {
            options.setyLo(Double.valueOf(Double.parseDouble(product.getYAxis().getLower())));
        }
        if (RequestValidator.isEmpty((Object)options.getyHi())) {
            options.setyHi(Double.valueOf(Double.parseDouble(product.getYAxis().getUpper())));
        }
        if (RequestValidator.isEmpty((Object)options.getzLo())) {
            options.setzLo(Double.valueOf(Double.parseDouble(product.getZAxis().getLower())));
        }
        if (RequestValidator.isEmpty((Object)options.getzHi())) {
            options.setzHi(Double.valueOf(Double.parseDouble(product.getZAxis().getUpper())));
        }
        if (options.getVariables() == null || options.getVariables().isEmpty()) {
            for (Variable var : product.getVariables()) {
                options.addVariable(var.getName());
            }
        }
        if (RequestValidator.isEmpty((Object)options.getBackTime())) {
            options.setBackTime(0);
        }
        if (RequestValidator.isEmpty((Object)options.getChunkSpan())) {
            options.setChunkSpan(ChunkTimespan.MONTH);
        }
        if (RequestValidator.isEmpty((Object)options.getImportSchedule())) {
            options.setImportSchedule(RequestValidator.generateRandomMonthlyCron());
        }
        return options;
    }

    private static String generateRandomMonthlyCron() {
        Long hour = Math.round(Math.random() * 24.0);
        Long minute = Math.round(Math.random() * 60.0);
        Long day = Math.round(Math.random() * 28.0);
        return String.format("0 %d %d %d 1/1 ? *", minute, hour, day);
    }

    public static Collection<ValidationError> validate(ImportOptions options, ProductMetadataInfo product) throws InvalidParameterException {
        Vector<ValidationError> errors = new Vector<ValidationError>();
        logger.debug("checking basic metadata.");
        errors.addAll(RequestValidator.checkSet((String)"motu (m)", (Object)options.getMotu()));
        errors.addAll(RequestValidator.checkSet((String)"product (p)", (Object)options.getProduct()));
        errors.addAll(RequestValidator.checkSet((String)"dataset (d)", (Object)options.getDataset()));
        logger.debug(errors.size() + " errors so far.");
        logger.debug("checking variables.");
        if (options.getVariables().isEmpty()) {
            errors.add(new ValidationError("variable (v)", "At least one variable must be set"));
        }
        logger.debug(errors.size() + " errors so far.");
        logger.debug("checking longitude range");
        errors.addAll(RequestValidator.checkRange((Double)options.getxLo(), (Double)options.getxHi(), (String)product.getXAxis().getLower(), (String)product.getXAxis().getUpper(), (String)"xlo", (String)"xhi"));
        logger.debug(errors.size() + " errors so far.");
        logger.debug("checking latitude range");
        errors.addAll(RequestValidator.checkRange((Double)options.getyLo(), (Double)options.getyHi(), (String)product.getYAxis().getLower(), (String)product.getYAxis().getUpper(), (String)"ylo", (String)"yhi"));
        logger.debug(errors.size() + " errors so far.");
        logger.debug("checking depth range");
        errors.addAll(RequestValidator.checkRange((Double)options.getzLo(), (Double)options.getzHi(), (String)product.getZAxis().getLower(), (String)product.getZAxis().getUpper(), (String)"zlo", (String)"zhi"));
        logger.debug(errors.size() + " errors so far.");
        logger.debug("checking time range");
        errors.addAll(RequestValidator.checkRange((Calendar)options.gettLo(), (Calendar)options.gettHi(), (Calendar)product.getFirstAvailableTimeCode(), (Calendar)product.getLastAvailableTimeCode(), (String)"tlo", (String)"thi"));
        if (errors.size() > 0) {
            return errors;
        }
        logger.debug(errors.size() + " errors so far.");
        logger.debug("checking at least one time tick");
        logger.debug(product.getAvailableTimeCodes().size() + " time ticks in the dataset");
        if (product.getTimeCodesInInterval(options.gettLo(), options.gettHi()).isEmpty()) {
            errors.add(new ValidationError("tlo, thi", "No data available for the given time range"));
        }
        logger.debug(errors.size() + " errors so far.");
        return errors;
    }

    public static boolean isEmpty(Object value) {
        if (value == null) {
            return true;
        }
        return value instanceof String && ((String)value).trim().isEmpty();
    }

    private static boolean ordered(Double min, Double max) {
        return RequestValidator.isEmpty((Object)min) || RequestValidator.isEmpty((Object)max) || !(max < min);
    }

    private static Collection<ValidationError> checkRange(Double rMin, Double rMax, String dMin, String dMax, String minKey, String maxKey) {
        return RequestValidator.checkRange((Double)rMin, (Double)rMax, (Double)Double.parseDouble(dMin), (Double)Double.parseDouble(dMax), (String)minKey, (String)maxKey);
    }

    private static Collection<ValidationError> checkRange(Calendar rMin, Calendar rMax, Calendar dMin, Calendar dMax, String minKey, String maxKey) {
        return RequestValidator.checkRange((Long)rMin.getTimeInMillis(), (Long)rMax.getTimeInMillis(), (Long)dMin.getTimeInMillis(), (Long)dMax.getTimeInMillis(), (String)minKey, (String)maxKey);
    }

    private static Collection<ValidationError> checkRange(Long rMin, Long rMax, Long dMin, Long dMax, String minKey, String maxKey) {
        return RequestValidator.checkRange((Double)new Double(rMin.longValue()), (Double)new Double(rMax.longValue()), (Double)new Double(dMin.longValue()), (Double)new Double(dMax.longValue()), (String)minKey, (String)maxKey);
    }

    private static Collection<ValidationError> checkRange(Double rMin, Double rMax, Double dMin, Double dMax, String minKey, String maxKey) {
        Vector<ValidationError> errors = new Vector<ValidationError>();
        String ORDERED = "'%s' must be lower than '%s'";
        String TOO_SMALL = "'%s' is less than range lower bound (%f)";
        String TOO_BIG = "'%s' is greater than range upper bound (%s)";
        errors.addAll(RequestValidator.checkSet((String)minKey, (Object)rMin));
        errors.addAll(RequestValidator.checkSet((String)maxKey, (Object)rMax));
        if (!RequestValidator.ordered((Double)rMin, (Double)rMax)) {
            errors.add(new ValidationError(minKey + "," + maxKey, String.format("'%s' must be lower than '%s'", minKey, maxKey)));
        }
        if (rMin < dMin) {
            errors.add(new ValidationError(minKey, String.format("'%s' is less than range lower bound (%f)", minKey, dMin)));
        }
        if (rMax > dMax) {
            errors.add(new ValidationError(maxKey, String.format("'%s' is greater than range upper bound (%s)", maxKey, dMax)));
        }
        for (ValidationError err : errors) {
            System.out.println(err.getMessage());
        }
        return errors;
    }

    private static Collection<ValidationError> checkSet(String key, Object value) {
        String MUST_BE_SET = "Field '%s' must be set";
        Vector<ValidationError> errors = new Vector<ValidationError>();
        if (RequestValidator.isEmpty((Object)value)) {
            errors.add(new ValidationError(key, String.format("Field '%s' must be set", key)));
        }
        return errors;
    }
}

