/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.service;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.AlreadyThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.MalformedElementException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.StoreException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.model.comparator.TaskLastExecutionTimeComparator;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.TaskStoreHelper;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ImportTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskStore {
    private static Logger logger = LoggerFactory.getLogger(TaskStore.class);
    private static final String DEFAULT_PERSISTENCY_PATH = "/tmp/cmems-tasks";
    private static final Integer DEFAULT_LIMIT = 100;
    private TaskStoreHelper fileStoreHelper;

    public TaskStore() throws InvalidParameterException {
        this(DEFAULT_PERSISTENCY_PATH);
    }

    public TaskStore(String persistencyPath) throws InvalidParameterException {
        if (persistencyPath == null) {
            logger.error("no persistency path given");
            throw new InvalidParameterException("", "bad persistency path: " + persistencyPath);
        }
        File file = new File(persistencyPath);
        if (!file.exists()) {
            logger.info("persistency path does not exist. Creating it: " + persistencyPath);
            file.mkdirs();
        }
        if (file.exists() && !file.isDirectory()) {
            logger.error("persistency path is not a directory");
            throw new InvalidParameterException("", "persistency path: " + persistencyPath + " is not a directory");
        }
        logger.debug("Using report store at " + persistencyPath);
        this.fileStoreHelper = new TaskStoreHelper(persistencyPath);
    }

    public File getRoot() {
        return this.fileStoreHelper.getRoot();
    }

    public List<ImportTask> searchTasks(String user, String scope, String token, Integer limit) {
        if (limit == null) {
            limit = DEFAULT_LIMIT;
        }
        TreeSet<ImportTask> sortedTasks = new TreeSet<ImportTask>((Comparator<ImportTask>)new TaskLastExecutionTimeComparator());
        for (String id : this.fileStoreHelper.getAllTasks()) {
            try {
                ImportTask t = this.getTask(id);
                if (user != null && !user.equals(t.getSubmissionInfo().getUser()) || scope != null && t.getSubmissionInfo().getScheduled() != null && !t.getSubmissionInfo().getScope().startsWith(scope) || token != null && !token.equals(t.getSubmissionInfo().getToken())) continue;
                sortedTasks.add(t);
            }
            catch (InvalidParameterException | MalformedElementException | NotThereException | StoreException e) {
                e.printStackTrace();
            }
        }
        Vector<ImportTask> out = new Vector<ImportTask>();
        int i = 0;
        for (ImportTask t : sortedTasks) {
            if (i >= limit) break;
            out.add(t);
            ++i;
        }
        for (ImportTask t : out) {
            t.getSubmissionInfo().setToken(null);
        }
        return out;
    }

    public ImportTask getTask(String taskId) throws InvalidParameterException, MalformedElementException, NotThereException, StoreException {
        ImportTask t;
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new InvalidParameterException("id", "task id is null");
        }
        try {
            t = this.fileStoreHelper.deserializeTask(taskId);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new MalformedElementException(taskId);
        }
        catch (FileNotFoundException e) {
            logger.info(e.getMessage());
            throw new NotThereException(taskId);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
            throw new StoreException(taskId);
        }
        String lastExecId = this.fileStoreHelper.getLastExecution(taskId);
        if (lastExecId != null) {
            t.setLastExecution(this.getExecution(taskId, lastExecId));
        }
        t.getSubmissionInfo().setToken(null);
        return t;
    }

    public boolean hasExecution(String taskId, String executionId) {
        File f = this.fileStoreHelper.getExecutionInfoFile(taskId, executionId);
        return f.exists();
    }

    public List<Execution> getExecutions(String taskId) throws InvalidParameterException, StoreException, MalformedElementException, NotThereException {
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new InvalidParameterException("id", "task id is null");
        }
        Vector<Execution> out = new Vector<Execution>();
        File executionsDir = this.fileStoreHelper.getExecutionsRoot(taskId);
        if (executionsDir.exists()) {
            for (String executionId : this.fileStoreHelper.getAllExecutions(taskId)) {
                out.add(this.getExecution(taskId, executionId));
            }
        }
        return out;
    }

    public Execution getExecution(String taskId, String executionId) throws InvalidParameterException, StoreException, NotThereException, MalformedElementException {
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new InvalidParameterException("id", "task id is null");
        }
        if (executionId == null || executionId.trim().isEmpty()) {
            throw new InvalidParameterException("id", "execution id is null");
        }
        try {
            Execution e = this.fileStoreHelper.deserializeExecution(taskId, executionId);
            e.setReports((Collection)this.getReports(taskId, executionId));
            return e;
        }
        catch (FileNotFoundException e) {
            logger.info(e.getMessage());
            throw new NotThereException(taskId + "/" + executionId);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
            throw new StoreException(taskId + "/" + executionId);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new MalformedElementException(taskId + "/" + executionId);
        }
    }

    public Execution getLastExecution(String taskId) throws InvalidParameterException, StoreException, NotThereException, MalformedElementException {
        String lastExecId = this.fileStoreHelper.getLastExecution(taskId);
        if (lastExecId == null) {
            lastExecId = "non-existing-execution-id";
        }
        return this.getExecution(taskId, lastExecId);
    }

    public String getLastExecutionId(String taskId) {
        return this.fileStoreHelper.getLastExecution(taskId);
    }

    public List<ExecutionReport> getReports(String taskId, String executionId) throws InvalidParameterException, NotThereException, MalformedElementException {
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new InvalidParameterException("id", "task id is null");
        }
        if (executionId == null || executionId.trim().isEmpty()) {
            throw new InvalidParameterException("id", "execution id is null");
        }
        Vector<ExecutionReport> out = new Vector<ExecutionReport>();
        File reportsDir = this.fileStoreHelper.getExecutionReportsRoot(taskId, executionId);
        if (reportsDir.exists()) {
            for (String r : this.fileStoreHelper.getAllExecutionReports(taskId, executionId)) {
                ExecutionReport report = this.getReport(taskId, executionId, r);
                report.setText(null);
                out.add(report);
            }
        }
        return out;
    }

    public ExecutionReport getReport(String taskId, String executionId, String reportName) throws InvalidParameterException, NotThereException, MalformedElementException {
        String text;
        File reportFile;
        if (taskId == null || taskId.trim().isEmpty()) {
            throw new InvalidParameterException("id", "task id is null");
        }
        if (executionId == null || executionId.trim().isEmpty()) {
            throw new InvalidParameterException("id", "execution id is null");
        }
        if (reportName == null || reportName.trim().isEmpty()) {
            throw new InvalidParameterException("name", "report name is null");
        }
        try {
            reportFile = this.fileStoreHelper.ensureReport(taskId, executionId, reportName);
        }
        catch (FileNotFoundException e) {
            logger.info(e.getMessage());
            throw new NotThereException(taskId + "/" + executionId + "/" + reportName);
        }
        ExecutionReport out = new ExecutionReport();
        out.setName(reportName);
        out.setSize(Long.valueOf(reportFile.length()));
        try {
            text = TaskStoreHelper.getContent((File)reportFile);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MalformedElementException(taskId + "/" + executionId + "/" + reportName);
        }
        out.setText(text);
        if (text.length() > 1000) {
            out.setSnippet(text.substring(0, 500) + "...");
        } else {
            out.setSnippet(text);
        }
        return out;
    }

    public Execution update(String taskId, Execution execution) throws InvalidParameterException, NotThereException, MalformedElementException, StoreException {
        File execFile;
        if (taskId == null) {
            throw new InvalidParameterException("id", "task id is null");
        }
        if (execution == null) {
            throw new InvalidParameterException("execution", "execution is null");
        }
        if (execution.getId() == null) {
            throw new InvalidParameterException("id", "execution id is null");
        }
        try {
            execFile = this.fileStoreHelper.ensureExecutionInfo(taskId, execution.getId());
        }
        catch (FileNotFoundException e) {
            logger.info(e.getMessage());
            throw new NotThereException(taskId + "/" + execution.getId());
        }
        Execution existing = this.getExecution(taskId, execution.getId());
        if (execution.getEnd() != null) {
            existing.setEnd(execution.getEnd());
        }
        if (execution.getStatus() != null) {
            existing.setStatus(execution.getStatus());
        }
        if (execution.getProgress() != null) {
            existing.setProgress(execution.getProgress());
        }
        existing.setLastUpdate(Calendar.getInstance());
        try {
            TaskStoreHelper.serializeExecution((File)execFile, (Execution)existing);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
            throw new StoreException(taskId + "/" + execution.getId());
        }
        return this.getExecution(taskId, execution.getId());
    }

    private void touchExecution(String taskId, String executionId) throws InvalidParameterException, StoreException, MalformedElementException, NotThereException {
        Execution execution = this.getExecution(taskId, executionId);
        this.touchExecution(taskId, execution);
    }

    private void touchExecution(String taskId, Execution execution) throws InvalidParameterException, StoreException, MalformedElementException, NotThereException {
        this.update(taskId, execution);
    }

    public ExecutionReport update(String taskId, String executionId, ExecutionReport report) throws InvalidParameterException, NotThereException, MalformedElementException, StoreException {
        File reportFile;
        if (taskId == null) {
            throw new InvalidParameterException("id", "task id is null");
        }
        if (executionId == null) {
            throw new InvalidParameterException("id", "execution id is null");
        }
        if (report == null) {
            throw new InvalidParameterException("report", "report is null");
        }
        if (report.getName() == null || report.getName().trim().isEmpty()) {
            throw new InvalidParameterException("name", "report name is null");
        }
        try {
            reportFile = this.fileStoreHelper.ensureReport(taskId, executionId, report.getName());
        }
        catch (FileNotFoundException e) {
            logger.info(e.getMessage());
            throw new NotThereException(taskId + "/" + executionId + "/" + report.getName());
        }
        try {
            TaskStoreHelper.writeContent((File)reportFile, (String)report.getText());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new StoreException(taskId + "/" + executionId + "/" + report.getName());
        }
        this.touchExecution(taskId, executionId);
        return this.getReport(taskId, executionId, report.getName());
    }

    public ImportTask addTask(ImportTask task) throws InvalidParameterException, AlreadyThereException, StoreException, NotThereException, MalformedElementException {
        File taskDir;
        if (task == null) {
            throw new InvalidParameterException("task", "task is null");
        }
        if (task.getId() == null) {
            throw new InvalidParameterException("id", "task id is null");
        }
        try {
            taskDir = this.fileStoreHelper.ensureTaskMiss(task.getId());
        }
        catch (FileAlreadyExistsException e) {
            throw new AlreadyThereException(task.getId());
        }
        try {
            TaskStoreHelper.serializeTask((File)taskDir, (ImportTask)task);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
            throw new StoreException(task.getId());
        }
        return this.getTask(task.getId());
    }

    public Execution addExecution(String taskId, Execution execution) throws InvalidParameterException, AlreadyThereException, NotThereException, StoreException, MalformedElementException {
        File executionFile;
        if (taskId == null) {
            throw new InvalidParameterException("id", "task id is null");
        }
        if (execution == null) {
            throw new InvalidParameterException("execution", "execution is null");
        }
        if (execution.getId() == null) {
            throw new InvalidParameterException("id", "execution id is null");
        }
        try {
            executionFile = this.fileStoreHelper.ensureExecutionInfoMiss(taskId, execution.getId());
        }
        catch (FileAlreadyExistsException e) {
            e.printStackTrace();
            throw new AlreadyThereException(taskId + "/" + execution.getId());
        }
        catch (FileNotFoundException e) {
            logger.info(e.getMessage());
            throw new NotThereException(taskId);
        }
        execution.setLastUpdate(Calendar.getInstance());
        try {
            TaskStoreHelper.serializeExecution((File)executionFile, (Execution)execution);
        }
        catch (IOException | JAXBException e) {
            e.printStackTrace();
            throw new StoreException(taskId + "/" + execution.getId());
        }
        return this.getExecution(taskId, execution.getId());
    }

    public ExecutionReport addReport(String taskId, String executionId, ExecutionReport report) throws InvalidParameterException, NotThereException, AlreadyThereException, StoreException, MalformedElementException {
        File reportFile;
        if (taskId == null) {
            throw new InvalidParameterException("id", "task id is null");
        }
        if (executionId == null) {
            throw new InvalidParameterException("id", "execution id is null");
        }
        if (report == null) {
            throw new InvalidParameterException("report", "report is null");
        }
        if (report.getName() == null || report.getName().trim().isEmpty()) {
            throw new InvalidParameterException("name", "report name is null");
        }
        try {
            reportFile = this.fileStoreHelper.ensureReportMiss(taskId, executionId, report.getName());
        }
        catch (FileAlreadyExistsException e) {
            e.printStackTrace();
            throw new AlreadyThereException(taskId + "/" + executionId + "/" + report.getName());
        }
        catch (FileNotFoundException e) {
            logger.info(e.getMessage());
            throw new NotThereException(taskId + "/" + executionId);
        }
        try {
            TaskStoreHelper.serializeReport((File)reportFile, (ExecutionReport)report);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new StoreException(taskId + "/" + executionId + "/" + report.getName());
        }
        this.touchExecution(taskId, executionId);
        return this.getReport(taskId, executionId, report.getName());
    }
}

