/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import java.util.Vector;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task.PreviewResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.DatasetBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewResource
extends AbstractImporterResource {
    private static Logger logger = LoggerFactory.getLogger(PreviewResource.class);

    @Path(value="check")
    @GET
    public Response check(@Context UriInfo uriInfo) {
        try {
            ImportOptions options = this.extractImportParameters(uriInfo);
            Vector errors = new Vector();
            errors.addAll(this.check(options));
            errors.addAll(this.checkSchedule(options));
            if (!errors.isEmpty()) {
                1 entity = new /* Unavailable Anonymous Inner Class!! */;
                logger.info("there are errors: " + errors.size());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entity).build();
            }
        }
        catch (InvalidParameterException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok().build();
    }

    @Path(value="sizes/dataset")
    @GET
    public Response datasetSize(@Context UriInfo uriInfo) {
        ImportOptions options = null;
        try {
            options = this.extractImportParameters(uriInfo);
            Vector errors = new Vector();
            errors.addAll(this.check(options));
            errors.addAll(this.checkSchedule(options));
            if (!errors.isEmpty()) {
                2 entity = new /* Unavailable Anonymous Inner Class!! */;
                logger.info("there are errors: " + errors.size());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entity).build();
            }
        }
        catch (InvalidParameterException e) {
            logger.error(e.toString());
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            logger.error(e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        try {
            Long size = new DatasetBrowser().datasetSize(options);
            return Response.ok((Object)size.toString()).build();
        }
        catch (Exception e) {
            logger.error(e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="sizes/chunk")
    @GET
    public Response chunkSize(@Context UriInfo uriInfo) {
        ImportOptions options = null;
        try {
            options = this.extractImportParameters(uriInfo);
            Vector errors = new Vector();
            errors.addAll(this.check(options));
            errors.addAll(this.checkSchedule(options));
            if (!errors.isEmpty()) {
                3 entity = new /* Unavailable Anonymous Inner Class!! */;
                logger.info("there are errors: " + errors.size());
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entity).build();
            }
        }
        catch (InvalidParameterException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        catch (Exception e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        try {
            Long size = new DatasetBrowser().chunkSize(options);
            return Response.ok((Object)size.toString()).build();
        }
        catch (Exception e) {
            logger.error(e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
}

