/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import java.util.Collection;
import java.util.Vector;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;
import javax.ws.rs.core.UriInfo;

import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ValidationError;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.DatasetBrowser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Paolo Fabriani
 *
 */
public class PreviewResource extends AbstractImporterResource {

    private static Logger logger = LoggerFactory.getLogger(PreviewResource.class); 

    @Path("check")
    @GET
    public Response check(@Context UriInfo uriInfo) {
        // extract params and check parameters
        try {
            ImportOptions options = this.extractImportParameters(uriInfo);
            Collection<ValidationError> errors = new Vector<>(); 
            errors.addAll(this.check(options));
            errors.addAll(this.checkSchedule(options));
            if(!errors.isEmpty()) {
                GenericEntity<Collection<ValidationError>> entity = new GenericEntity<Collection<ValidationError>>(errors) {};
                logger.info("there are errors: " + errors.size());
                return Response.status(Status.BAD_REQUEST).entity(entity).build();
            }
        } catch(InvalidParameterException e) {
            e.printStackTrace();
            return Response.status(Status.BAD_REQUEST).build();
        } catch(Exception e) {
            e.printStackTrace();
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
        return Response.ok().build();
    }

    @Path("sizes/dataset")
    @GET
    public Response datasetSize(@Context UriInfo uriInfo) {

        // extract options and validate them
        ImportOptions options = null;
        try {
            options = this.extractImportParameters(uriInfo);
            Collection<ValidationError> errors = new Vector<>(); 
            errors.addAll(this.check(options));
            errors.addAll(this.checkSchedule(options));
            if(!errors.isEmpty()) {
                GenericEntity<Collection<ValidationError>> entity = new GenericEntity<Collection<ValidationError>>(errors) {};
                logger.info("there are errors: " + errors.size());
                return Response.status(Status.BAD_REQUEST).entity(entity).build();
            }
        } catch(InvalidParameterException e) {
            logger.error(e.toString());
            return Response.status(Status.BAD_REQUEST).build();
        } catch(Exception e) {
            logger.error(e.toString());
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
        
        // compute the size
        try {
            // get the size
            Long size = new DatasetBrowser().datasetSize(options);
            // return to client
            return Response.ok(size.toString()).build();
        } catch(Exception e) {
            logger.error(e.toString());
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path("sizes/chunk")
    @GET
    public Response chunkSize(@Context UriInfo uriInfo) {
        
        // extract options and validate them
        ImportOptions options = null;
        try {
            options = this.extractImportParameters(uriInfo);
            Collection<ValidationError> errors = new Vector<>(); 
            errors.addAll(this.check(options));
            errors.addAll(this.checkSchedule(options));
            if(!errors.isEmpty()) {
                GenericEntity<Collection<ValidationError>> entity = new GenericEntity<Collection<ValidationError>>(errors) {};
                logger.info("there are errors: " + errors.size());
                return Response.status(Status.BAD_REQUEST).entity(entity).build();
            }
        } catch(InvalidParameterException e) {
            return Response.status(Status.BAD_REQUEST).build();
        } catch(Exception e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
        
        // compute the size
        try {
            // get the size
            Long size = new DatasetBrowser().chunkSize(options);
            // return to client
            return Response.ok(size.toString()).build();
        } catch(Exception e) {
            logger.error(e.toString());
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        }
        
    }

}
