/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import java.util.Collection;
import java.util.List;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Response.Status;

import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.AlreadyThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.MalformedElementException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.StoreException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.TaskStore;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.Execution;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;

/**
 * @author Paolo Fabriani
 *
 */
public class ExecutionResource extends AbstractImporterResource {
    
    private String taskId;
    private String executionId;
    
    public ExecutionResource(String taskId, String executionId) {
        this.taskId = taskId;
        try {
            if("last".equals(executionId)) {
                this.executionId = new TaskStore().getLastExecutionId(taskId);
            } else {
                this.executionId = executionId;
            }
        } catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    @GET
    public Response getExecution() {
        try {
            Execution execution = new TaskStore().getExecution(this.taskId, this.executionId);
            return Response.ok().entity(execution).build();
        } catch (MalformedElementException | StoreException | InvalidParameterException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path("reports")
    public Response getReports() {
        try {
            List<ExecutionReport> reports = new TaskStore().getReports(this.taskId, this.executionId);
            GenericEntity<Collection<ExecutionReport>> out = new GenericEntity<Collection<ExecutionReport>>(reports) {};
            return Response.ok(out).build();
        } catch (MalformedElementException | InvalidParameterException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        }
    }        


    @Path("reports/{reportId}")
    public ReportResource getReport(@PathParam("reportId") String reportId) {
        return new ReportResource(this.taskId, this.executionId, reportId);
    }        

    @POST
    @Path("reports")
    @Produces(MediaType.APPLICATION_XML)
    @Consumes(MediaType.APPLICATION_XML)
    public Response addReport(ExecutionReport report) {
        try {
            ExecutionReport out = new TaskStore().addReport(this.taskId, this.executionId, report);
            return Response.ok().entity(out).build();
        } catch (MalformedElementException | StoreException | InvalidParameterException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        } catch (AlreadyThereException e) {
            return Response.status(Status.BAD_REQUEST).build();
        }
    }
    
    /**
     * Update the execution. Only end date, status and progress can be updated.
     * 
     * @param report
     * @return
     */
    @PUT
    @Produces(MediaType.APPLICATION_XML)
    @Consumes(MediaType.APPLICATION_XML)
    public Response update(Execution execution) {
        try {
            execution.setId(this.executionId);
            Execution out = new TaskStore().update(this.taskId, execution);
            return Response.ok().entity(out).build();
        } catch (MalformedElementException | StoreException | InvalidParameterException e) {
            return Response.status(Status.INTERNAL_SERVER_ERROR).build();
        } catch (NotThereException e) {
            return Response.status(Status.NOT_FOUND).build();
        }
    }
    
}
