/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.client;

import java.net.URL;
import java.text.ParseException;
import java.util.Collection;
import java.util.Vector;

import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * @author Paolo Fabriani
 *
 */
public class CmemsImporterClient {

    private URL endpoint;
    
    private static final String CMEMS_IMPORTER_PLUGIN_NAME = "cmems-importer-se-plugin";

    private static Logger LOGGER = LoggerFactory.getLogger(CmemsImporterClient.class);
       

    public CmemsImporterClient() {
    }

    public CmemsImporterClient(URL endpoint) {
        this();
        this.endpoint = endpoint;
    }
    
    /**
     * List scheduled tasks.
     */
    public Collection<String> listTasks() {
        // TODO: interact with the smart executor
        return new Vector<>();
    }

    /**
     * Return the options associated with the import task.
     * @param taskId
     * @return
     */
    public ImportOptions getJobOptions(String taskId) {
        /*
         * We have two alternative ways to retrieve this information:
         * 
         * 1. interact with the smart executor, retrieving launch parameters
         * 
         * 2. given the job hash, go the thredds, retrieve the ncml. Here we
         * enter the options for improved human readability.
         */
        return new ImportOptions();
    }

    /**
     * Schedule a new import job.
     */
    public String scheduleJob(ImportOptions options) throws ExecutorException, ParseException {

//        SmartExecutorProxy proxy = ExecutorPlugin
//                .getExecutorProxy(CMEMS_IMPORTER_PLUGIN_NAME).build();
//        Map<String, Object> params = new HashMap<>();
//        params.put("debug", Boolean.FALSE);
//        params.put("removeTmpFiles", Boolean.TRUE);
//        params.put("uploadWithCurl", Boolean.TRUE);
//        params.put("intervalSize", new Integer(3));
//        LaunchParameter parameter = new LaunchParameter(
//                CMEMS_IMPORTER_PLUGIN_NAME, params);
//
//        CronExpression cronExpression = new CronExpression("0 */10 * * * ?");
//        Scheduling scheduling = new Scheduling(cronExpression, true);
//        parameter.setScheduling(scheduling);

        // after a while you can check the status of the launch
//        String uuidPluginLaunched = proxy.launch(parameter);
//        LOGGER.debug(uuidPluginLaunched);

        // PluginStateEvolution state =
        // proxy.getStateEvolution(uuidPluginLaunched);
        // System.out.println(state.getPluginState());

        return "";

    }

    /**
     * Un-schedule a task.
     */
    public void unscheduleTask(String taskId) throws ExecutorException {
//        LOGGER.info("TODO: unschedule task with id " + taskId);
//        SmartExecutorProxy proxy = ExecutorPlugin.getExecutorProxy(CMEMS_IMPORTER_PLUGIN_NAME).build();
//        Boolean unscheduled = proxy.unSchedule(taskId, true);
//        LOGGER.info(unscheduled.toString());
    }

    /**
     * Get the status of a task.
     */
    public void taskStatus(String taskId) {
//        LOGGER.info("TODO: retrieve the status of the task " + taskId);
    }

}
