package org.gcube.dataanalysis.copernicus.cmems.importer.task;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
@XmlEnum
public enum ExecutionStatus {

    // The Task is created but not still running.
    @XmlEnumValue("created")
    CREATED("created"),

    // The Task is running.
    @XmlEnumValue("running")
    RUNNING("running"),

    // The Task has been stopped.
    @XmlEnumValue("stopped")
    STOPPED("stopped"),

    // The Task terminated successfully.
    @XmlEnumValue("done")
    DONE("done"),

    // The Task failed the execution.
    @XmlEnumValue("failed")
    FAILED("failed"),

    // The Task has been discarded by the scheduler. This happen only for
    // repetitive or recurrent tasks and only when the launch parameter require
    // that the previous task must be completed.
    @XmlEnumValue("discarded")
    DISCARDED("discarded");

    private final String value;

    ExecutionStatus(String v) {
        this.value = v;
    }

    public String value() {
        return this.value;
    }

    public static ExecutionStatus fromValue(String s) throws Exception {
        for (ExecutionStatus c : ExecutionStatus.values()) {
            if (c.value.equals(s)) {
                return c;
            }
        }
        throw new IllegalArgumentException(s);
    }

    public String toString() {
        return this.value;
    }

}
