/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.model;

import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

/**
 * @author Paolo Fabriani
 *
 */
@XmlRootElement(name="dataset")
public class CmemsDataset {

    private String protocol;
    private String name;
    private String url;

    public CmemsDataset() {
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }
    
    @XmlTransient
    public String getProductOnMotu() {
        if(this.url!=null) {
            for(NameValuePair nvp:URLEncodedUtils.parse(this.getUrl(), null)) {
                if(nvp.getName().equals("service"))
                    return nvp.getValue();
            }
            return null;
        }
        return null;
    }

    @XmlTransient
    public String getDatasetOnMotu() {
        if(this.url!=null) {
            for(NameValuePair nvp:URLEncodedUtils.parse(this.getUrl(), null)) {
                if(nvp.getName().equals("product"))
                    return nvp.getValue();
            }
            return null;
        }
        return null;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
