/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.util.Calendar;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequestEnvelope;
import org.gcube.dataanalysis.copernicus.motu.client.MotuClient;
import org.gcube.dataanalysis.copernicus.motu.client.ThreadedWorker;
import org.gcube.dataanalysis.copernicus.motu.model.StatusModeResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedSubmitter
extends ThreadedWorker<DownloadRequestEnvelope> {
    private static Logger logger = LoggerFactory.getLogger(ThreadedSubmitter.class);
    private static final Long CHECK_INTERVAL = 10000L;
    private MotuClient motu;

    public ThreadedSubmitter(MotuClient motu) {
        this.motu = motu;
    }

    @Override
    public void doWork(DownloadRequestEnvelope chunk) throws Exception {
        StatusModeResponse submitStatus = this.motu.queueProductDownload(chunk);
        chunk.setStart(Calendar.getInstance());
        chunk.setStatus(submitStatus);
        while (true) {
            logger.info("checking status of request " + chunk);
            StatusModeResponse checkStatus = this.motu.checkStatus(chunk.getStatus().getRequestId());
            if (checkStatus.isError()) {
                if (checkStatus.getMessage().startsWith("004-1 : Sorry, the system is currently not available. Please try again later")) {
                    this.doWork(chunk);
                    break;
                }
                chunk.setStatus(checkStatus);
                break;
            }
            if (checkStatus.isReady()) {
                logger.info("request " + chunk + " is complete.");
                logger.info("file can be downloaded from " + checkStatus.getRemoteUri());
                chunk.setStatus(checkStatus);
                break;
            }
            logger.info("waiting a bit...");
            Thread.sleep(CHECK_INTERVAL);
        }
    }
}

