/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.motu.client;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequest;
import org.gcube.dataanalysis.copernicus.motu.client.DownloadRequestEnvelope;
import org.gcube.dataanalysis.copernicus.motu.client.MapUtil;
import org.gcube.dataanalysis.copernicus.motu.client.MotuClient;
import org.gcube.dataanalysis.copernicus.motu.model.ProductMetadataInfo;
import org.gcube.dataanalysis.copernicus.motu.model.RequestSize;
import org.gcube.dataanalysis.copernicus.motu.model.Variable;
import org.gcube.dataanalysis.datasetimporter.util.SizeUtils;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestSplitter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequestSplitter.class);
    private MotuClient motuClient;
    private DownloadRequest request;
    private Long chunkSize;

    public RequestSplitter(DownloadRequest request) {
        this.request = request;
    }

    private Collection<DownloadRequestEnvelope> splitAlongVariables(DownloadRequestEnvelope request) throws Exception {
        Vector<String> variables = new Vector<String>();
        if (request.getVariables() == null || request.getVariables().size() == 0) {
            ProductMetadataInfo pmi = this.getMotuClient().describeProduct(request);
            for (Variable variable : pmi.getVariables()) {
                variables.add(variable.getName());
            }
        } else {
            variables.addAll(request.getVariables());
        }
        HashMap<String, Long> sizes = new HashMap<String, Long>();
        for (String string : variables) {
            DownloadRequestEnvelope envelope = new DownloadRequestEnvelope(request);
            envelope.setVariables(null);
            envelope.addVariable(string);
            RequestSize size = this.getMotuClient().getSize(envelope);
            sizes.put(string, size.getSizeInBytes());
        }
        Map sortedSizes = MapUtil.sortByValue(sizes);
        Vector<DownloadRequestEnvelope> vector = new Vector<DownloadRequestEnvelope>();
        HashMap<DownloadRequestEnvelope, Long> chunkSizes = new HashMap<DownloadRequestEnvelope, Long>();
        Long maxSize = this.getChunkSize(request);
        int seq = 0;
        for (Map.Entry entry : sortedSizes.entrySet()) {
            String variable = (String)entry.getKey();
            Long varSize = (Long)entry.getValue();
            boolean found = false;
            for (DownloadRequestEnvelope chunk : vector) {
                Long chunkSize = (Long)chunkSizes.get(chunk);
                if (chunkSize + varSize >= maxSize) continue;
                chunk.addVariable(variable);
                chunkSizes.put(chunk, chunkSize + varSize);
                found = true;
                break;
            }
            if (found) continue;
            DownloadRequestEnvelope chunk = new DownloadRequestEnvelope(request);
            chunk.setVariables(null);
            chunk.addVariable(variable);
            vector.add(chunk);
            String nameSuffix = String.format("-%s%02d", "v", seq);
            String name = request.getName() + nameSuffix;
            chunk.setName(name);
            ++seq;
            chunkSizes.put(chunk, varSize);
        }
        return vector;
    }

    private Collection<DownloadRequestEnvelope> splitAlongTimeNew(DownloadRequestEnvelope request) throws Exception {
        LOGGER.info("splitting along time");
        Vector<DownloadRequestEnvelope> output = new Vector<DownloadRequestEnvelope>();
        Long minTime = request.gettLo().getTimeInMillis();
        Long maxTime = request.gettHi().getTimeInMillis();
        Long reqSize = request.getSize().getSizeInBytes();
        Long maxSize = this.getChunkSize(request);
        int nr = (int)Math.round(Math.ceil((double)reqSize.longValue() * 1.0 / (double)maxSize.longValue() * 1.1));
        Double step = ((double)maxTime.longValue() * 1.0 - (double)minTime.longValue() * 1.0) / (double)nr * 1.0;
        ProductMetadataInfo pmi = this.getMotuClient().describeProduct(request);
        List<Calendar> timeSteps = pmi.getTimeCodesInInterval(request.gettLo(), request.gettHi());
        LOGGER.debug("found " + timeSteps.size() + " time codes in interval");
        LOGGER.debug("we need at least " + nr + " chunks");
        int ticksPerChunk = (int)Math.ceil((double)timeSteps.size() / (double)nr);
        LOGGER.debug("preparing chunks of time size: " + ticksPerChunk);
        int seq = 0;
        for (int i = 0; i < timeSteps.size(); i += ticksPerChunk) {
            Calendar from = timeSteps.get(i);
            int toIndex = i + ticksPerChunk - 1;
            if (toIndex >= timeSteps.size()) {
                toIndex = timeSteps.size() - 1;
            }
            Calendar to = timeSteps.get(toIndex);
            LOGGER.debug("request from " + i + " to " + toIndex);
            LOGGER.debug("request from " + TimeUtil.toString((Calendar)from) + " to " + TimeUtil.toString((Calendar)to));
            DownloadRequestEnvelope chunk = new DownloadRequestEnvelope(request);
            chunk.settRange(from, to);
            String nameSuffix = String.format("-%s%02d", "t", seq);
            String name = request.getName() + nameSuffix;
            chunk.setName(name);
            output.add(chunk);
            ++seq;
        }
        return output;
    }

    @Deprecated
    private Collection<DownloadRequestEnvelope> splitAlongTime(DownloadRequestEnvelope request) throws Exception {
        LOGGER.info("splitting along time");
        Vector<DownloadRequestEnvelope> output = new Vector<DownloadRequestEnvelope>();
        Long minTime = request.gettLo().getTimeInMillis();
        Long maxTime = request.gettHi().getTimeInMillis();
        Long reqSize = request.getSize().getSizeInBytes();
        Long maxSize = this.getChunkSize(request);
        Long nr = Math.round(Math.ceil((double)reqSize.longValue() * 1.0 / (double)maxSize.longValue() * 1.1));
        Double step = ((double)maxTime.longValue() * 1.0 - (double)minTime.longValue() * 1.0) / (double)nr.longValue() * 1.0;
        LOGGER.debug("we need to do " + nr + " requests to split along time");
        int seq = 0;
        int i = 0;
        while ((long)i < nr) {
            Double chunkStart = (double)minTime.longValue() + (double)i * step;
            DownloadRequestEnvelope chunk = new DownloadRequestEnvelope(request);
            Calendar from = Calendar.getInstance();
            from.setTimeInMillis(Math.round(chunkStart));
            Calendar to = Calendar.getInstance();
            to.setTimeInMillis(Math.round(chunkStart + step));
            chunk.settRange(from, to);
            String nameSuffix = String.format("-%s%02d", "t", seq);
            String name = request.getName() + nameSuffix;
            chunk.setName(name);
            output.add(chunk);
            ++seq;
            ++i;
        }
        return output;
    }

    private Collection<DownloadRequestEnvelope> splitAlongAxis(DownloadRequestEnvelope request, String axis) throws Exception {
        Vector<DownloadRequestEnvelope> output = new Vector<DownloadRequestEnvelope>();
        Double min = Double.parseDouble(request.getParametersMap().getFirst(axis + "_lo"));
        Double max = Double.parseDouble(request.getParametersMap().getFirst(axis + "_hi"));
        Long reqSize = request.getSize().getSizeInBytes();
        Long maxSize = this.getChunkSize(request);
        Long nr = Math.round(Math.ceil((double)reqSize.longValue() * 1.0 / (double)maxSize.longValue() * 1.1));
        Double step = (max - min) / (double)nr.longValue();
        int seq = 0;
        int i = 0;
        while ((long)i < nr) {
            Double var = min + (double)i * step;
            DownloadRequestEnvelope chunk = new DownloadRequestEnvelope(request);
            if (axis.equals("x")) {
                chunk.setxRange(var, Math.min(var + step, max));
            }
            if (axis.equals("y")) {
                chunk.setyRange(var, Math.min(var + step, max));
            }
            if (axis.equals("z")) {
                chunk.setzRange(var, Math.min(var + step, max));
            }
            String nameSuffix = String.format("-%s%02d", axis, seq);
            String name = request.getName() + nameSuffix;
            chunk.setName(name);
            ++seq;
            output.add(chunk);
            ++i;
        }
        return output;
    }

    public Collection<DownloadRequestEnvelope> splitRequest(String ... splitParameters) throws Exception {
        DownloadRequestEnvelope envelope = new DownloadRequestEnvelope(this.request);
        envelope.setName("chunk");
        envelope.setSize(this.getMotuClient().getSize(this.request));
        return this.splitRequest(envelope, splitParameters);
    }

    private Collection<DownloadRequestEnvelope> splitRequest(DownloadRequestEnvelope request, String ... splitParameters) throws Exception {
        Long size = request.getSize().getSizeInBytes();
        Long chunkSize = this.getChunkSize(request);
        LOGGER.debug("Request size is " + SizeUtils.humanReadableBinarySize((Long)size));
        LOGGER.debug("Max chunk size is " + SizeUtils.humanReadableBinarySize((Long)chunkSize));
        Vector<DownloadRequestEnvelope> output = new Vector<DownloadRequestEnvelope>();
        if (size <= chunkSize) {
            LOGGER.info("request size is within limits. Proceeding");
            output.add(request);
        } else {
            String splitParam = splitParameters[0];
            LOGGER.info("request size is too big. Splitting along the " + splitParam + " dimension");
            Collection<DownloadRequestEnvelope> chunks = null;
            if (splitParam.equals("v")) {
                chunks = this.splitAlongVariables(request);
            } else if (splitParam.equals("x") || splitParam.equals("y") || splitParam.equals("z")) {
                chunks = this.splitAlongAxis(request, splitParam);
            } else if (splitParam.equals("t")) {
                chunks = this.splitAlongTimeNew(request);
            } else {
                LOGGER.error("unable to split along " + splitParam);
            }
            String[] newsp = Arrays.copyOfRange(splitParameters, 1, splitParameters.length);
            for (DownloadRequestEnvelope chunk : chunks) {
                if (chunk.getSize() != null) continue;
                chunk.setSize(this.getMotuClient().getSize(chunk));
            }
            if (splitParameters.length > 1) {
                for (DownloadRequestEnvelope chunk : chunks) {
                    output.addAll(this.splitRequest(chunk, newsp));
                }
            } else {
                output.addAll(chunks);
            }
        }
        return output;
    }

    private Long getChunkSize(DownloadRequestEnvelope request) throws Exception {
        if (this.chunkSize == null) {
            if (request.getSize() == null) {
                request.setSize(this.motuClient.getSize(request));
            }
            this.chunkSize = Math.min(request.getSize().getMaxAllowedSizeInBytes(), this.getMotuClient().getPreferredDownloadSize());
        }
        return this.chunkSize;
    }

    public MotuClient getMotuClient() {
        return this.motuClient;
    }

    public void setMotuClient(MotuClient motuClient) {
        this.motuClient = motuClient;
    }
}

