/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Vector;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDataset;
import org.gcube.dataanalysis.copernicus.cmems.model.CmemsDocument;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
@XmlRootElement(name="product")
public class CmemsProduct {
    private String abztract;
    private String id;
    private String display_priority;
    private String external_shortname;
    private String version;
    private String short_description;
    private String creation_date;
    private String update_date;
    private String quicklooks;
    private String feature_type;
    private String forecast_length;
    private String all_keywords;
    private String geographical_area;
    private String mission_type;
    private String model_assimilation;
    private String ocean_variables;
    private String ocean_keys;
    private String processing_level;
    private String west;
    private String east;
    private String south;
    private String north;
    private String spatial_resolution_row;
    private String spatial_resolution_row_unit;
    private String spatial_resolution_column;
    private String spatial_resolution_column_unit;
    private String coord_ref_sys;
    private String vertical_min;
    private String vertical_max;
    private String vertical_crs;
    private String vertical_levels;
    private String temporal_resolution;
    private String vertical_coverage;
    private String temporal_begin;
    private String temporal_end;
    private String temporal_extent;
    private String temporal_scale;
    private String update_frequency;
    private String update_schedule;
    private String production_unit;
    private String credit;
    private String documentation;
    private String mail;
    private String ftp;
    private String dgf;
    private String tds;
    private String wms;
    private String service_desk;
    private String upstream_production;
    private String upstream_validation;
    private String downstream_validation;
    private String downstream_production;
    private String MYO_OK;
    private String _version;

    @JsonProperty(value="abstract")
    public String getAbstract() {
        return this.abztract;
    }

    public void setAbstract(String abztract) {
        this.abztract = abztract;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="display_priority")
    public String getDisplayPriority() {
        return this.display_priority;
    }

    public void setDisplayPriority(String display_priority) {
        this.display_priority = display_priority;
    }

    @JsonProperty(value="external_shortname")
    public String getExternalShortname() {
        return this.external_shortname;
    }

    public void setExternalShortname(String external_shortname) {
        this.external_shortname = external_shortname;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="short_description")
    public String getShortDescription() {
        return this.short_description;
    }

    public void setShortDescription(String short_description) {
        this.short_description = short_description;
    }

    @JsonProperty(value="creation_date")
    public String getCreationDate() {
        return this.creation_date;
    }

    public void setCreationDate(String creation_date) {
        this.creation_date = creation_date;
    }

    @JsonProperty(value="update_date")
    public String getUpdateDate() {
        return this.update_date;
    }

    public void setUpdateDate(String update_date) {
        this.update_date = update_date;
    }

    public String getQuicklooks() {
        return this.quicklooks;
    }

    public void setQuicklooks(String quicklooks) {
        this.quicklooks = quicklooks;
    }

    @JsonProperty(value="feature_type")
    public String getFeatureType() {
        return this.feature_type;
    }

    public void setFeatureType(String feature_type) {
        this.feature_type = feature_type;
    }

    @JsonProperty(value="forecast_length")
    public String getForecastLength() {
        return this.forecast_length;
    }

    public void setForecastLength(String forecast_length) {
        this.forecast_length = forecast_length;
    }

    @JsonProperty(value="all_keywords")
    public String getAllKeywords() {
        return this.all_keywords;
    }

    public void setAllKeywords(String all_keywords) {
        this.all_keywords = all_keywords;
    }

    @JsonProperty(value="geographical_area")
    @XmlElementWrapper(name="geographicalAreas")
    @XmlElement(name="area")
    public String[] getGeographicalArea() {
        if (this.geographical_area != null) {
            return this.geographical_area.split(",");
        }
        return new String[0];
    }

    public void setGeographical_area(String geographical_area) {
        this.geographical_area = geographical_area;
    }

    @JsonProperty(value="mission_type")
    public String getMissionType() {
        return this.mission_type;
    }

    public void setMissionType(String mission_type) {
        this.mission_type = mission_type;
    }

    @JsonProperty(value="model_assimilation")
    public String getModelAssimilation() {
        return this.model_assimilation;
    }

    public void setModelAssimilation(String model_assimilation) {
        this.model_assimilation = model_assimilation;
    }

    @JsonProperty(value="ocean_variables")
    @XmlElementWrapper(name="oceanVariables")
    @XmlElement(name="variable")
    public String[] getOceanVariables() {
        if (this.ocean_variables != null) {
            return this.ocean_variables.split("\\s*,\\s*");
        }
        return new String[0];
    }

    public void setOcean_variables(String ocean_variables) {
        this.ocean_variables = ocean_variables;
    }

    @JsonProperty(value="ocean_keys")
    @XmlElementWrapper(name="oceanKeys")
    @XmlElement(name="key")
    public String[] getOceanKeys() {
        if (this.ocean_keys != null) {
            return this.ocean_keys.split("\\s*,\\s*");
        }
        return new String[0];
    }

    public void setOcean_keys(String ocean_keys) {
        this.ocean_keys = ocean_keys;
    }

    @JsonProperty(value="processing_level")
    public String getProcessingLevel() {
        return this.processing_level;
    }

    public void setProcessingLevel(String processing_level) {
        this.processing_level = processing_level;
    }

    public String getWest() {
        return this.west;
    }

    public void setWest(String west) {
        this.west = west;
    }

    public String getEast() {
        return this.east;
    }

    public void setEast(String east) {
        this.east = east;
    }

    public String getSouth() {
        return this.south;
    }

    public void setSouth(String south) {
        this.south = south;
    }

    public String getNorth() {
        return this.north;
    }

    public void setNorth(String north) {
        this.north = north;
    }

    @JsonProperty(value="spatial_resolution_row")
    public String getSpatialResolutionRow() {
        return this.spatial_resolution_row;
    }

    public void setSpatialResolutionRow(String spatial_resolution_row) {
        this.spatial_resolution_row = spatial_resolution_row;
    }

    @JsonProperty(value="spatial_resolution_row_unit")
    public String getSpatialResolutionRowUnit() {
        return this.spatial_resolution_row_unit;
    }

    public void setSpatialResolutionRowUnit(String spatial_resolution_row_unit) {
        this.spatial_resolution_row_unit = spatial_resolution_row_unit;
    }

    @JsonProperty(value="spatial_resolution_column")
    public String getSpatialResolutionColumn() {
        return this.spatial_resolution_column;
    }

    public void setSpatialResolutionColumn(String spatial_resolution_column) {
        this.spatial_resolution_column = spatial_resolution_column;
    }

    @JsonProperty(value="spatial_resolution_column_unit")
    public String getSpatialResolutionColumnUnit() {
        return this.spatial_resolution_column_unit;
    }

    public void setSpatialResolutionColumnUnit(String spatial_resolution_column_unit) {
        this.spatial_resolution_column_unit = spatial_resolution_column_unit;
    }

    @JsonProperty(value="coord_ref_sys")
    public String getCoordRefSys() {
        return this.coord_ref_sys;
    }

    public void setCoordRefSys(String coord_ref_sys) {
        this.coord_ref_sys = coord_ref_sys;
    }

    @JsonProperty(value="vertical_min")
    public String getVerticalMin() {
        return this.vertical_min;
    }

    public void setVerticalMin(String vertical_min) {
        this.vertical_min = vertical_min;
    }

    @JsonProperty(value="vertical_max")
    public String getVerticalMax() {
        return this.vertical_max;
    }

    public void setVerticalMax(String vertical_max) {
        this.vertical_max = vertical_max;
    }

    @JsonProperty(value="vertical_crs")
    public String getVerticalCrs() {
        return this.vertical_crs;
    }

    public void setVerticalCrs(String vertical_crs) {
        this.vertical_crs = vertical_crs;
    }

    @JsonProperty(value="vertical_levels")
    public String getVerticalLevels() {
        return this.vertical_levels;
    }

    public void setVerticalLevels(String vertical_levels) {
        this.vertical_levels = vertical_levels;
    }

    @JsonProperty(value="temporal_resolution")
    public String getTemporalResolution() {
        return this.temporal_resolution;
    }

    public void setTemporalResolution(String temporal_resolution) {
        this.temporal_resolution = temporal_resolution;
    }

    @JsonProperty(value="vertical_coverage")
    public String getVerticalCoverage() {
        return this.vertical_coverage;
    }

    public void setVerticalCoverage(String vertical_coverage) {
        this.vertical_coverage = vertical_coverage;
    }

    @JsonProperty(value="temporal_begin")
    @XmlElement
    public Calendar getTemporalBegin() throws ParseException {
        return TimeUtil.toCalendar((String)this.temporal_begin);
    }

    public void setTemporalBegin(String temporal_begin) {
        this.temporal_begin = temporal_begin;
    }

    @JsonProperty(value="temporal_end")
    @XmlElement
    public Calendar getTemporalEnd() throws ParseException {
        if (this.temporal_end != null) {
            return TimeUtil.toCalendar((String)this.temporal_end);
        }
        return null;
    }

    public void setTemporalEnd(String temporal_end) {
        this.temporal_end = temporal_end;
    }

    @JsonProperty(value="temporal_extent")
    public String getTemporalExtent() {
        return this.temporal_extent;
    }

    public void setTemporalExtent(String temporal_extent) {
        this.temporal_extent = temporal_extent;
    }

    @JsonProperty(value="temporal_scale")
    @XmlElementWrapper(name="temporalScale")
    @XmlElement(name="scale")
    public String[] getTemporalScale() {
        if (this.temporal_scale != null) {
            return this.temporal_scale.split(",");
        }
        return new String[0];
    }

    public void setTemporalScale(String temporal_scale) {
        this.temporal_scale = temporal_scale;
    }

    @JsonProperty(value="update_frequency")
    public String getUpdateFrequency() {
        return this.update_frequency;
    }

    public void setUpdateFrequency(String update_frequency) {
        this.update_frequency = update_frequency;
    }

    @JsonProperty(value="update_schedule")
    public String getUpdateSchedule() {
        return this.update_schedule;
    }

    public void setUpdateSchedule(String update_schedule) {
        this.update_schedule = update_schedule;
    }

    @JsonProperty(value="production_unit")
    public String getProductionUnit() {
        return this.production_unit;
    }

    public void setProductionUnit(String production_unit) {
        this.production_unit = production_unit;
    }

    public String getCredit() {
        return this.credit;
    }

    public void setCredit(String credit) {
        this.credit = credit;
    }

    public Collection<CmemsDocument> getDocuments() {
        String[] documents;
        Vector<CmemsDocument> out = new Vector<CmemsDocument>();
        for (String d : documents = this.documentation.split(",")) {
            CmemsDocument doc = new CmemsDocument();
            String[] attrs = d.split(";");
            if (attrs.length > 0) {
                doc.setTitle(attrs[0]);
            }
            if (attrs.length > 1) {
                doc.setUrl(attrs[1]);
            }
            if (attrs.length > 2) {
                doc.setDate(attrs[2]);
            }
            if (doc.isEmpty()) continue;
            out.add(doc);
        }
        return out;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    @JsonProperty(value="MAIL")
    public String getMail() {
        return this.mail;
    }

    public void setMail(String mail) {
        this.mail = mail;
    }

    @JsonProperty(value="FTP")
    public String getFtp() {
        return this.ftp;
    }

    public void setFtp(String ftp) {
        this.ftp = ftp;
    }

    @JsonProperty(value="DGF")
    public String getDgf() {
        return this.dgf;
    }

    public void setDgf(String dgf) {
        this.dgf = dgf;
    }

    @JsonProperty(value="TDS")
    public String getTds() {
        return this.tds;
    }

    public void setTds(String tds) {
        this.tds = tds;
    }

    @JsonProperty(value="WMS")
    public String getWms() {
        return this.wms;
    }

    public void setWms(String wms) {
        this.wms = wms;
    }

    @JsonProperty(value="service_desk")
    public String getServiceDesk() {
        return this.service_desk;
    }

    public void setServiceDesk(String service_desk) {
        this.service_desk = service_desk;
    }

    @JsonProperty(value="upstream-production")
    public String getUpstreamProduction() {
        return this.upstream_production;
    }

    public void setUpstreamProduction(String upstream_production) {
        this.upstream_production = upstream_production;
    }

    @JsonProperty(value="upstream-validation")
    public String getUpstreamValidation() {
        return this.upstream_validation;
    }

    public void setUpstreamValidation(String upstream_validation) {
        this.upstream_validation = upstream_validation;
    }

    @JsonProperty(value="downstream-validation")
    public String getDownstreamValidation() {
        return this.downstream_validation;
    }

    public void setDownstreamValidation(String downstream_validation) {
        this.downstream_validation = downstream_validation;
    }

    @JsonProperty(value="downstream-production")
    public String getDownstreamProduction() {
        return this.downstream_production;
    }

    public void setDownstreamProduction(String downstream_production) {
        this.downstream_production = downstream_production;
    }

    @JsonProperty(value="MYO-OK")
    public String getMYO_OK() {
        return this.MYO_OK;
    }

    public void setMYO_OK(String mYO_OK) {
        this.MYO_OK = mYO_OK;
    }

    public String getVersion_() {
        return this._version;
    }

    @JsonProperty(value="_version_")
    public void setVersion_(String _version) {
        this._version = _version;
    }

    public String getMotuServer() {
        if (this.tds != null && !this.tds.equalsIgnoreCase("undefined")) {
            String url = this.tds.substring(0, this.tds.indexOf("?"));
            return url;
        }
        return null;
    }

    public Collection<CmemsDataset> getTdsDatasets() {
        return this.extractDatasets(this.getTds(), "TDS");
    }

    public Collection<CmemsDataset> getDgfDatasets() {
        return this.extractDatasets(this.getDgf(), "DGF");
    }

    public Collection<CmemsDataset> getFtpDatasets() {
        return this.extractDatasets(this.getFtp(), "FTP");
    }

    public Collection<CmemsDataset> getWmsDatasets() {
        return this.extractDatasets(this.getWms(), "WMS");
    }

    private Collection<CmemsDataset> extractDatasets(String datasetString, String protocol) {
        String[] parts;
        Vector<CmemsDataset> out = new Vector<CmemsDataset>();
        if (datasetString != null && (parts = datasetString.split(";")).length > 1) {
            String[] urls = parts[0].split(",");
            String[] names = parts[1].split(",");
            if (names.length == urls.length && names.length > 0) {
                for (int i = 0; i < urls.length; ++i) {
                    CmemsDataset ds = new CmemsDataset();
                    ds.setProtocol(protocol);
                    ds.setName(names[i].trim());
                    ds.setUrl(urls[i].trim());
                    out.add(ds);
                }
            }
        }
        return out;
    }
}

