package org.gcube.dataanalysis.executor.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;

public class StorageUtils {

	public static void downloadInputFile(String fileurl, String destinationFile) throws Exception{
		try {
			Handler.activateProtocol();
			URL smpFile = new URL(fileurl);
			URLConnection uc = (URLConnection) smpFile.openConnection();
			InputStream is = uc.getInputStream();
			AnalysisLogger.getLogger().debug("GenericWorker-> Retrieving from " + fileurl + " to :" + destinationFile);
			inputStreamToFile(is, destinationFile);
			is.close();
		} catch (Exception e) {
			throw e;
		}
	}

	public static void inputStreamToFile(InputStream is, String path) throws FileNotFoundException, IOException {
		FileOutputStream out = new FileOutputStream(new File(path));
		byte buf[] = new byte[1024];
		int len = 0;
		while ((len = is.read(buf)) > 0)
			out.write(buf, 0, len);
		out.close();
	}

	public static String uploadFilesOnStorage(String scope, String user, String localFolder, String file) throws Exception {
		try {
			ScopeProvider.instance.set(scope);
			AnalysisLogger.getLogger().info("Loading file on scope: " + scope);
			IClient client = new StorageClient(AlgorithmConfiguration.StatisticalManagerClass, AlgorithmConfiguration.StatisticalManagerService, user, AccessType.SHARED, MemoryType.VOLATILE).getClient();
			String remotef = "/"+file;
			client.put(true).LFile(new File(localFolder,file).getAbsolutePath()).RFile(remotef);
			String url = client.getUrl().RFile(remotef);
			AnalysisLogger.getLogger().info("Loading finished");
			System.gc();
			return url;
		} catch (Exception e) {
			AnalysisLogger.getLogger().info("Error in uploading file: " + e.getLocalizedMessage());
			throw e;
		}
	}

	
	public static void downloadFilefromStorage(String scope, String user, String localFolder, String file) throws Exception {
		try {
			ScopeProvider.instance.set(scope);
			AnalysisLogger.getLogger().info("Retrieving file on scope: " + scope);
			IClient client = new StorageClient(AlgorithmConfiguration.StatisticalManagerClass, AlgorithmConfiguration.StatisticalManagerService, user, AccessType.SHARED, MemoryType.VOLATILE).getClient();
			String remotef = "/"+file;
			client.get().LFile(new File(localFolder,file).getAbsolutePath()).RFile(remotef);
			AnalysisLogger.getLogger().info("Retrieving finished");
			System.gc();
		} catch (Exception e) {
			AnalysisLogger.getLogger().info("Error in retrieving file: " + e.getLocalizedMessage());
			throw e;
		}
	}

	
	public static void main(String args[]) throws Exception{
		
		uploadFilesOnStorage("/gcube", "CMSY", "./", "tacsat.csv");
		downloadFilefromStorage("/gcube", "CMSY", "./PARALLEL_PROCESSING", "tacsat.csv");
	}
}
