/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers.bionym;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.ActorNode;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.executor.generators.D4ScienceDistributedProcessing;
import org.gcube.dataanalysis.executor.job.management.QueueJobManager;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.MatcherOutput;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.SingleEntry;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.implementations.matchers.FuzzyMatcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.implementations.matchers.GsayMatcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.implementations.matchers.LevensteinMatcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.implementations.matchers.MixedLexicalMatcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.implementations.matchers.SoundexMatcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.implementations.matchers.TrigramMatcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.implementations.workflows.BiOnymWF;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.interfaces.Matcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.utils.YasmeenGlobalParameters;
import org.gcube.dataanalysis.executor.scripts.OSCommand;
import org.hibernate.SessionFactory;

public class BionymFlexibleWorkflowTransducer
extends ActorNode {
    protected AlgorithmConfiguration currentconfig;
    protected SessionFactory dbconnection;
    boolean haspostprocessed = false;
    float status;
    public int prevbroadcastTimePeriod;
    public int prevmaxNumberOfStages;
    public int prevmaxMessages;
    String destinationTable;
    String destinationTableLabel;
    public static String headers = "SOURCE_DATA,TARGET_DATA_SCIENTIFIC_NAME,TARGET_DATA_AUTHORITY,MATCHING_SCORE,TARGET_DATA_SOURCE,TARGET_DATA_ID";
    private static String createOutputTable = "CREATE TABLE %1$s (SOURCE_DATA character varying(255),  TARGET_DATA_SCIENTIFIC_NAME character varying(255), TARGET_DATA_AUTHORITY character varying(255), MATCHING_SCORE real,TARGET_DATA_SOURCE character varying, TARGET_DATA_ID character varying)";
    public int rawnamescount = 0;
    public static String destinationTableParam = "OutputTable";
    public static String destinationTableLableParam = "OutputTableLabel";
    public static String originTableParam = "RawTaxaNamesTable";
    public static String rawnamesColumnParam = "RawNamesColumn";
    public static String matcherParamPrefix = "Matcher";
    public static String thresholdParamPrefix = "Threshold";
    public static String maxresultsParamPrefix = "MaxResults";
    public static int maxMatchersInterface = 5;
    public static int maxMatchersReal = 20;

    public static Matcher getEnum2Matcher(YasmeenGlobalParameters.BuiltinMatchers matcher, String sandboxFolder, double threshold, int maxResults, HashMap<String, String> parameters) {
        switch (matcher) {
            case GSAy: {
                return new GsayMatcher(sandboxFolder, threshold, maxResults, parameters);
            }
            case FUZZYMATCH: {
                return new FuzzyMatcher(sandboxFolder, threshold, maxResults, parameters);
            }
            case LEVENSHTEIN: {
                return new LevensteinMatcher(sandboxFolder, threshold, maxResults, parameters);
            }
            case TRIGRAM: {
                return new TrigramMatcher(sandboxFolder, threshold, maxResults, parameters);
            }
            case SOUNDEX: {
                return new SoundexMatcher(sandboxFolder, threshold, maxResults, parameters);
            }
            case LEV_SDX_TRIG: {
                return new MixedLexicalMatcher(sandboxFolder, threshold, maxResults, parameters);
            }
            case NONE: {
                return null;
            }
        }
        return null;
    }

    public List<Matcher> buildMatcherList(AlgorithmConfiguration config, String sandboxFolder, HashMap<String, String> globalparameters) {
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        int i = 1;
        while (i <= maxMatchersReal) {
            String matchername = config.getParam(String.valueOf(matcherParamPrefix) + "_" + i);
            String threshold = config.getParam(String.valueOf(thresholdParamPrefix) + "_" + i);
            String maxResultS = config.getParam(String.valueOf(maxresultsParamPrefix) + "_" + i);
            if (matchername != null) {
                Matcher m;
                double thr = 0.2;
                if (threshold != null) {
                    thr = Double.parseDouble(threshold);
                }
                int maxResults = 10;
                if (maxResultS != null) {
                    maxResults = Integer.parseInt(maxResultS);
                }
                if ((m = BionymFlexibleWorkflowTransducer.getEnum2Matcher(YasmeenGlobalParameters.BuiltinMatchers.valueOf(matchername), sandboxFolder, thr, maxResults, globalparameters)) != null) {
                    matchers.add(m);
                }
            }
            ++i;
        }
        return matchers;
    }

    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public String getName() {
        return "BIONYM";
    }

    public String getDescription() {
        return "An algorithm implementing BiOnym, a flexible workflow approach to taxon name matching. The workflow allows to activate several taxa names matching algorithms and to get the list of possible transcriptions for a list of input raw species names with possible authorship indication.";
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<TableTemplates> templateLWRInput = new ArrayList<TableTemplates>();
        templateLWRInput.add(TableTemplates.GENERIC);
        InputTable p1 = new InputTable(templateLWRInput, originTableParam, "Input table containing raw taxa names that you want to match", "byonym");
        ColumnType p2 = new ColumnType(originTableParam, rawnamesColumnParam, "The column containing the raw taxa names with or without authoship information", "rawnames", false);
        ServiceType p3 = new ServiceType(ServiceParameters.RANDOMSTRING, destinationTableParam, "name of the table that will contain the matches", "bion_");
        PrimitiveType p4 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, destinationTableLableParam, "Name of the table which will contain the matches", "bionout");
        PrimitiveType p5 = new PrimitiveType(Enum.class.getName(), (Object)YasmeenGlobalParameters.BuiltinDataSources.values(), PrimitiveTypes.ENUMERATED, YasmeenGlobalParameters.taxaAuthorityFileParam, "The reference dataset to use", "" + (Object)((Object)YasmeenGlobalParameters.BuiltinDataSources.FISHBASE));
        PrimitiveType p6 = new PrimitiveType(Enum.class.getName(), (Object)YasmeenGlobalParameters.BuiltinParsers.values(), PrimitiveTypes.ENUMERATED, YasmeenGlobalParameters.parserNameParam, "The Species - Authority parser", "" + (Object)((Object)YasmeenGlobalParameters.BuiltinParsers.SIMPLE));
        PrimitiveType p7 = new PrimitiveType(Boolean.class.getName(), null, PrimitiveTypes.BOOLEAN, YasmeenGlobalParameters.activatePreParsingProcessing, "Use preparsing rules to correct common errors", "true");
        PrimitiveType p8 = new PrimitiveType(Boolean.class.getName(), null, PrimitiveTypes.BOOLEAN, YasmeenGlobalParameters.useStemmedGenusAndSpecies, "Process using Genus and Species names without declension", "false");
        PrimitiveType p9 = new PrimitiveType(Enum.class.getName(), (Object)YasmeenGlobalParameters.Performance.values(), PrimitiveTypes.ENUMERATED, YasmeenGlobalParameters.performanceParam, "A trade-off between recognition speed and accuracy. Max speed corresponds to search for strings with the same length only.", "" + (Object)((Object)YasmeenGlobalParameters.Performance.MAX_ACCURACY));
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        parameters.add((StatisticalType)p1);
        parameters.add((StatisticalType)p3);
        parameters.add((StatisticalType)p2);
        parameters.add((StatisticalType)p4);
        parameters.add((StatisticalType)p5);
        parameters.add((StatisticalType)p6);
        parameters.add((StatisticalType)p7);
        parameters.add((StatisticalType)p8);
        parameters.add((StatisticalType)p9);
        PrimitiveType pgsay = new PrimitiveType(Enum.class.getName(), (Object)YasmeenGlobalParameters.BuiltinMatchers.values(), PrimitiveTypes.ENUMERATED, String.valueOf(matcherParamPrefix) + "_" + 1, "Choose a Matcher", YasmeenGlobalParameters.BuiltinMatchers.GSAy.name());
        PrimitiveType pthrgsay = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(thresholdParamPrefix) + "_" + 1, "Threshold", "0.6", true);
        PrimitiveType pmrgsay = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(maxresultsParamPrefix) + "_" + 1, "The maximum number of matching candidates per each raw input species", "10");
        PrimitiveType ptaxa = new PrimitiveType(Enum.class.getName(), (Object)YasmeenGlobalParameters.BuiltinMatchers.values(), PrimitiveTypes.ENUMERATED, String.valueOf(matcherParamPrefix) + "_" + 2, "Choose a Matcher", YasmeenGlobalParameters.BuiltinMatchers.FUZZYMATCH.name());
        PrimitiveType pthrtaxa = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(thresholdParamPrefix) + "_" + 2, "Threshold", "0.6", true);
        PrimitiveType pmrtaxa = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(maxresultsParamPrefix) + "_" + 2, "The maximum number of matching candidates per each raw input species", "10");
        PrimitiveType plev = new PrimitiveType(Enum.class.getName(), (Object)YasmeenGlobalParameters.BuiltinMatchers.values(), PrimitiveTypes.ENUMERATED, String.valueOf(matcherParamPrefix) + "_" + 3, "Choose a Matcher", YasmeenGlobalParameters.BuiltinMatchers.LEVENSHTEIN.name());
        PrimitiveType pthrlev = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(thresholdParamPrefix) + "_" + 3, "Threshold", "0.4", true);
        PrimitiveType pmrlev = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(maxresultsParamPrefix) + "_" + 3, "The maximum number of matching candidates per each raw input species", "5");
        PrimitiveType ptrig = new PrimitiveType(Enum.class.getName(), (Object)YasmeenGlobalParameters.BuiltinMatchers.values(), PrimitiveTypes.ENUMERATED, String.valueOf(matcherParamPrefix) + "_" + 4, "Choose a Matcher", YasmeenGlobalParameters.BuiltinMatchers.TRIGRAM.name());
        PrimitiveType pthrtrig = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(thresholdParamPrefix) + "_" + 4, "Threshold", "0.4");
        PrimitiveType pmrtrig = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(maxresultsParamPrefix) + "_" + 4, "The maximum number of matching candidates per each raw input species", "5");
        parameters.add((StatisticalType)pgsay);
        parameters.add((StatisticalType)pthrgsay);
        parameters.add((StatisticalType)pmrgsay);
        parameters.add((StatisticalType)ptaxa);
        parameters.add((StatisticalType)pthrtaxa);
        parameters.add((StatisticalType)pmrtaxa);
        parameters.add((StatisticalType)plev);
        parameters.add((StatisticalType)pthrlev);
        parameters.add((StatisticalType)pmrlev);
        parameters.add((StatisticalType)ptrig);
        parameters.add((StatisticalType)pthrtrig);
        parameters.add((StatisticalType)pmrtrig);
        int i = 5;
        while (i <= maxMatchersInterface) {
            PrimitiveType p = new PrimitiveType(Enum.class.getName(), (Object)YasmeenGlobalParameters.BuiltinMatchers.values(), PrimitiveTypes.ENUMERATED, String.valueOf(matcherParamPrefix) + "_" + i, "Choose a Matcher (Optional)", YasmeenGlobalParameters.BuiltinMatchers.NONE.name(), true);
            PrimitiveType pn = new PrimitiveType(Double.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(thresholdParamPrefix) + "_" + i, "Threshold (def. 0.2)", "0.2", true);
            PrimitiveType pr = new PrimitiveType(Integer.class.getName(), null, PrimitiveTypes.NUMBER, String.valueOf(maxresultsParamPrefix) + "_" + i, "The maximum number of matching candidates per each raw input species", "0");
            parameters.add((StatisticalType)p);
            parameters.add((StatisticalType)pn);
            parameters.add((StatisticalType)pr);
            ++i;
        }
        DatabaseType.addDefaultDBPars(parameters);
        return parameters;
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> template = new ArrayList<TableTemplates>();
        template.add(TableTemplates.GENERIC);
        OutputTable p = new OutputTable(template, this.destinationTableLabel, this.destinationTable, "Output  table");
        return p;
    }

    public void initSingleNode(AlgorithmConfiguration config) {
    }

    public float getInternalStatus() {
        return this.status;
    }

    public int executeNode(int leftStartIndex, int numberOfLeftElementsToProcess, int rightStartIndex, int numberOfRightElementsToProcess, boolean duplicate, String sandboxFolder, String nodeConfigurationFileObject, String logfileNameToProduce) {
        String uuid = ("" + UUID.randomUUID()).replace("-", "");
        String inputParserFile = "inputParser" + uuid + ".txt";
        String outputParserFile = "outputParser" + uuid + ".txt";
        try {
            try {
                this.status = 0.0f;
                long t0 = System.currentTimeMillis();
                System.out.println("Restoring configuration");
                AlgorithmConfiguration config = Transformations.restoreConfig((String)new File(sandboxFolder, nodeConfigurationFileObject).getAbsolutePath());
                config.setConfigPath(sandboxFolder);
                this.dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)config);
                String destinationTable = config.getParam(destinationTableParam);
                String originTable = config.getParam(originTableParam);
                String rawnamesColumn = config.getParam(rawnamesColumnParam);
                String parser = config.getParam(YasmeenGlobalParameters.parserNameParam);
                String accuracyvsspeed = config.getParam(YasmeenGlobalParameters.performanceParam);
                String reference = config.getParam(YasmeenGlobalParameters.taxaAuthorityFileParam);
                String doPreprocess = config.getParam(YasmeenGlobalParameters.activatePreParsingProcessing);
                String usestemming = config.getParam(YasmeenGlobalParameters.useStemmedGenusAndSpecies);
                String overallMaxResults = config.getParam(YasmeenGlobalParameters.overallMaxResults);
                System.out.println("Destination Table: " + destinationTable);
                System.out.println("Origin Table: " + originTable);
                System.out.println("Column of names: " + rawnamesColumn);
                System.out.println("Parser to use: " + parser);
                System.out.println("Accuracy vs Speed: " + accuracyvsspeed);
                System.out.println("Reference Dataset: " + reference);
                System.out.println("Do Preprocessing: " + doPreprocess);
                System.out.println("Use Stemming:" + usestemming);
                System.out.println("Overall MaxResults:" + overallMaxResults);
                HashMap<String, String> globalparameters = new HashMap<String, String>();
                globalparameters.put(YasmeenGlobalParameters.parserInputFileParam, inputParserFile);
                globalparameters.put(YasmeenGlobalParameters.parserOutputFileParam, outputParserFile);
                globalparameters.put(YasmeenGlobalParameters.activatePreParsingProcessing, doPreprocess);
                globalparameters.put(YasmeenGlobalParameters.parserNameParam, parser);
                globalparameters.put(YasmeenGlobalParameters.performanceParam, accuracyvsspeed);
                globalparameters.put(YasmeenGlobalParameters.taxaAuthorityFileParam, reference);
                globalparameters.put(YasmeenGlobalParameters.useStemmedGenusAndSpecies, usestemming);
                System.out.println("Configuration Restored! - Time: " + (System.currentTimeMillis() - t0));
                long t1 = System.currentTimeMillis();
                System.out.println("Retrieving names to process");
                String query = String.valueOf(DatabaseUtils.getDinstictElements((String)originTable, (String)rawnamesColumn, (String)"")) + " offset " + rightStartIndex + " limit " + numberOfRightElementsToProcess;
                List rawnames = DatabaseFactory.executeSQLQuery((String)query, (SessionFactory)this.dbconnection);
                System.out.println("Retrieved a total of " + rawnames.size() + " species");
                rightStartIndex = 0;
                int end = rightStartIndex + numberOfRightElementsToProcess;
                System.out.println("Processing from " + rightStartIndex + " to " + end);
                ArrayList<String> rawnamesFiltered = new ArrayList<String>();
                int i = rightStartIndex;
                while (i < end) {
                    String raw = "" + rawnames.get(i);
                    rawnamesFiltered.add(raw.replaceAll("^'", "").replaceAll("'$", ""));
                    ++i;
                }
                int rawscounter = rawnamesFiltered.size();
                System.out.println("Retrieve from DB - Time: " + (System.currentTimeMillis() - t1));
                long t2 = System.currentTimeMillis();
                System.out.println("Processing " + rawscounter + " species..");
                try {
                    OSCommand.ExecuteGetLine("chmod +x *", null);
                }
                catch (Exception e) {
                    System.out.println("WARNING: could not change the permissions");
                }
                int overallMR = 10;
                if (overallMaxResults != null) {
                    overallMR = Integer.parseInt(overallMaxResults);
                }
                BiOnymWF bionym = new BiOnymWF(sandboxFolder, overallMR, globalparameters);
                List<Matcher> matchers = this.buildMatcherList(config, sandboxFolder, globalparameters);
                if (matchers != null) {
                    bionym.resetMatchers(matchers);
                }
                System.out.println("WF Initialization - Time: " + (System.currentTimeMillis() - t2));
                MatcherOutput output = bionym.executeChainedWorkflow(rawnamesFiltered);
                System.out.println("Workflow Executed");
                long t3 = System.currentTimeMillis();
                int nEntries = output.getEntriesNumber();
                ArrayList<String[]> toWrite = new ArrayList<String[]>();
                int i2 = 0;
                while (i2 < nEntries) {
                    SingleEntry se = output.getEntry(i2);
                    String[] srow = new String[]{se.originalName, se.targetScientificName, se.targetAuthor, "" + se.matchingScore, reference, se.targetID};
                    toWrite.add(srow);
                    ++i2;
                }
                DatabaseUtils.insertChunksIntoTable((String)destinationTable, (String)headers, toWrite, (int)5000, (SessionFactory)this.dbconnection);
                System.out.println("Write on DB - Time: " + (System.currentTimeMillis() - t3));
                System.out.println("The procedure finished successfully. Processed " + rawscounter + " species.");
                System.out.println("Elapsed Time " + (System.currentTimeMillis() - t0) + " ms");
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("warning: error in node execution " + e.getLocalizedMessage());
                System.err.println("Error in node execution " + e.getLocalizedMessage());
                if (this.dbconnection != null) {
                    try {
                        this.dbconnection.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                try {
                    new File(sandboxFolder, inputParserFile).delete();
                    new File(sandboxFolder, outputParserFile).delete();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.status = 1.0f;
                return -1;
            }
        }
        finally {
            if (this.dbconnection != null) {
                try {
                    this.dbconnection.close();
                }
                catch (Exception exception) {}
            }
            try {
                new File(sandboxFolder, inputParserFile).delete();
                new File(sandboxFolder, outputParserFile).delete();
            }
            catch (Exception exception) {}
            this.status = 1.0f;
        }
        return 0;
    }

    public void setup(AlgorithmConfiguration config) throws Exception {
        this.haspostprocessed = false;
        AnalysisLogger.getLogger().info((Object)"Initializing DB Connection");
        this.dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)config);
        this.destinationTable = config.getParam(destinationTableParam);
        this.destinationTableLabel = config.getParam(destinationTableLableParam);
        String originTable = config.getParam(originTableParam);
        String rawnamesColumn = config.getParam(rawnamesColumnParam);
        List rawnames = DatabaseFactory.executeSQLQuery((String)DatabaseUtils.getDinstictElements((String)originTable, (String)rawnamesColumn, (String)""), (SessionFactory)this.dbconnection);
        this.rawnamescount = rawnames.size();
        AnalysisLogger.getLogger().info((Object)("Creating Destination Table " + this.destinationTable));
        try {
            DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.destinationTable), (SessionFactory)this.dbconnection);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().info((Object)("Table " + this.destinationTable + " did not exist"));
        }
        DatabaseFactory.executeSQLUpdate((String)String.format(createOutputTable, this.destinationTable), (SessionFactory)this.dbconnection);
        this.prevmaxMessages = D4ScienceDistributedProcessing.maxMessagesAllowedPerJob;
        D4ScienceDistributedProcessing.maxMessagesAllowedPerJob = 50;
        this.prevbroadcastTimePeriod = QueueJobManager.broadcastTimePeriod;
        QueueJobManager.broadcastTimePeriod = 1800000;
        this.prevmaxNumberOfStages = QueueJobManager.maxNumberOfStages;
        QueueJobManager.maxNumberOfStages = 10000;
        AnalysisLogger.getLogger().info((Object)("Destination Table Created! Addressing " + this.rawnamescount + " names"));
    }

    public int getNumberOfRightElements() {
        return this.rawnamescount;
    }

    public int getNumberOfLeftElements() {
        return 1;
    }

    public void stop() {
        if (!this.haspostprocessed) {
            try {
                AnalysisLogger.getLogger().info((Object)("The procedure did NOT correctly postprocessed ....Removing Table " + this.destinationTable + " because of computation stop!"));
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.destinationTable), (SessionFactory)this.dbconnection);
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().info((Object)("Table " + this.destinationTable + " did not exist"));
            }
        } else {
            AnalysisLogger.getLogger().info((Object)"The procedure has correctly postprocessed: shutting down the connection!");
        }
        if (this.dbconnection != null) {
            try {
                this.dbconnection.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void postProcess(boolean manageDuplicates, boolean manageFault) {
        QueueJobManager.broadcastTimePeriod = this.prevbroadcastTimePeriod;
        QueueJobManager.maxNumberOfStages = this.prevmaxNumberOfStages;
        D4ScienceDistributedProcessing.maxMessagesAllowedPerJob = this.prevmaxMessages;
        this.haspostprocessed = true;
    }
}

