package org.gcube.dataanalysis.executor.scripts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.UUID;

import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.resource.StorageObject;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;

public class GetExecuteScript {

	private float status;
	private static String JOBOUTPUT = "job.txt";
	GCUBELog logger;
	
	public float getStatus(){
		return status;
	}
	
	public GetExecuteScript(){
		
	}
	
	public GetExecuteScript(GCUBELog logger){
		this.logger=logger;
	}
	
	public void executeScript(List<String> localfileNames,List<String> remotefiles, String tempRootDir, String toExecute, String argument,String identifier,String scope,String serviceClass,String serviceName,String owner,String remoteDirectory,String session, boolean deletefiles) throws Exception{
		status = 0f;
		StringBuffer sb = new StringBuffer();
		try {
			Handler.activateProtocol();
			String locDir = session;
			if (session == null)
				locDir = (""+UUID.randomUUID()).replace("-", "");
			String randomu = new File(tempRootDir).getAbsolutePath() + "/" + locDir+"/";
			logger.debug("ExecuteScript-> Creating local directory "+randomu);
			sb.append("Creating local directory "+randomu+"\n");
			File tempDir = new File(randomu);
			boolean dirc = true;
			if (!tempDir.exists())
				dirc = tempDir.mkdir();
			if (dirc) {
				logger.debug("ExecuteScript-> Retrieving files");
				sb.append("Retrieving files\n");
				int i =0;
				for (String fileurl : remotefiles) {
					URL smpFile = new URL(fileurl);
					URLConnection uc = ( URLConnection ) smpFile.openConnection ( );
					InputStream is=uc.getInputStream();
					logger.debug("ExecuteScript-> Retrieving from "+fileurl+" to :"+tempDir.getAbsolutePath()+"/"+localfileNames.get(i));
					sb.append("Retrieving from "+fileurl+" to :"+tempDir.getAbsolutePath()+"/"+localfileNames.get(i));
					inputStreamToFile(is, tempDir.getAbsolutePath()+"/"+localfileNames.get(i));
					is.close();
					
					i++;
				}
				logger.debug("ExecuteScript-> Files Retrieved");
				sb.append("Files Retrieved\n");
				logger.debug("ExecuteScript-> Executing script in "+System.getProperty("os.name"));
				sb.append("Executing script\n");
				String line = "";
				if (System.getProperty("os.name").startsWith("Windows"))
					line = new OSCommandGenericWorker().ExecuteGetLine("cmd /c cd " + tempDir.getAbsolutePath() + "\n " + toExecute + " " + argument + "\n exit\n",logger);
				else{
					line = new OSCommandGenericWorker().ExecuteGetLine("chmod +x "+tempDir.getAbsolutePath() +"/"+toExecute+"",logger);
					line = new OSCommandGenericWorker().ExecuteGetLine(tempDir.getAbsolutePath()+"/"+toExecute + " "+tempDir.getAbsolutePath() + "/ " + argument + "\nexit\n",logger);
				}
				if ((line != null) && (line.equals("ERROR")))
					throw new Exception("ERROR executing script");
				
				logger.debug("ExecuteScript-> Script executed: " + line);
				sb.append("Script executed: " + line+"\n");
				
				String outputfile = randomu+JOBOUTPUT;
				BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outputfile))); 
				bw.write(sb.toString());
				bw.flush();
				bw.close();
				logger.debug("ExecuteScript-> writing back output");
				sb.append("writing back output\n");
				save2Storage(JOBOUTPUT,"_"+identifier,randomu,remoteDirectory,scope,serviceClass,serviceName,owner);
				
				if (deletefiles){
				logger.debug("ExecuteScript-> write back ok ... deleting local files");
				//delete all after execution
				for (File singlefile : tempDir.listFiles()) {
					boolean del = singlefile.delete();
					if (!del)
						logger.debug("ExecuteScript-> ERROR deleting "+singlefile.getName()+" "+del);
					else
						logger.debug("ExecuteScript-> deleted LOCAL FILE "+singlefile.getName()+" "+del);
				}
				logger.debug("ExecuteScript-> deleting temporary directory");
				tempDir.delete();
				}
				
				logger.debug("ExecuteScript-> all done");
			} else{
				logger.debug("ExecuteScript-> Failed to create directory");
			}
			status = 100f;
		} catch (Exception e) {
			e.printStackTrace();
			logger.debug("ExecuteScript-> ERROR: " + e.getLocalizedMessage());
			status = 100f;
			throw e;
		}
	}

	private void save2Storage(String filename,String suffix,String localdirectory,String remotedirectory,String scope$,String serviceClass,String serviceName,String owner) {
		try{
//			System.out.println("ExecuteScript-> getting scope "+scope$);
			logger.debug("ExecuteScript-> getting scope "+scope$);
//			GCUBEScope scope = GCUBEScope.getScope(scope$);
			ScopeProvider.instance.set(scope$);
			IClient client = new StorageClient(serviceClass, serviceName, owner, AccessType.SHARED).getClient();
			String localf = localdirectory+filename;
			String remotef = remotedirectory+filename;
			logger.debug("ExecuteScript-> updating file "+localf +" to "+remotef);
//			FileInputStream fis = new FileInputStream(new File(localf)); 
			String id=client.put(true).LFile(localf).RFile(remotef);
//			fis.close();
		}catch(Exception e){
			e.printStackTrace();
			logger.debug(e);
			}
	}
	
	private static void inputStreamToFile(InputStream is, String path)
			throws FileNotFoundException, IOException {
		FileOutputStream out=new FileOutputStream(new File(path));				
		byte buf[]=new byte[1024];
		int len=0;
		while((len=is.read(buf))>0)
			  out.write(buf,0,len);
		out.close();
	}
}
