/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.scripts;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.UUID;
import org.gcube.common.core.scope.GCUBEScope;
import org.gcube.common.core.utils.logging.GCUBELog;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanager.storageclient.model.protocol.smp.Handler;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.dataanalysis.executor.scripts.OSCommandGenericWorker;

public class GetExecuteScript {
    private float status;
    private static String JOBOUTPUT = "job.txt";
    GCUBELog logger;

    public float getStatus() {
        return this.status;
    }

    public GetExecuteScript() {
    }

    public GetExecuteScript(GCUBELog logger) {
        this.logger = logger;
    }

    public void executeScript(List<String> localfileNames, List<String> remotefiles, String tempRootDir, String toExecute, String argument, String identifier, String scope, String serviceClass, String serviceName, String owner, String remoteDirectory, String session, boolean deletefiles) throws Exception {
        this.status = 0.0f;
        StringBuffer sb = new StringBuffer();
        try {
            Handler.activateProtocol();
            String locDir = session;
            if (session == null) {
                locDir = ("" + UUID.randomUUID()).replace("-", "");
            }
            String randomu = new File(tempRootDir).getAbsolutePath() + "/" + locDir + "/";
            this.logger.debug((Object)("ExecuteScript-> Creating local directory " + randomu));
            sb.append("Creating local directory " + randomu + "\n");
            File tempDir = new File(randomu);
            boolean dirc = true;
            if (!tempDir.exists()) {
                dirc = tempDir.mkdir();
            }
            if (dirc) {
                this.logger.debug((Object)"ExecuteScript-> Retrieving files");
                sb.append("Retrieving files\n");
                int i = 0;
                for (String fileurl : remotefiles) {
                    URL smpFile = new URL(fileurl);
                    URLConnection uc = smpFile.openConnection();
                    InputStream is = uc.getInputStream();
                    this.logger.debug((Object)("ExecuteScript-> Retrieving from " + fileurl + " to :" + tempDir.getAbsolutePath() + "/" + localfileNames.get(i)));
                    sb.append("Retrieving from " + fileurl + " to :" + tempDir.getAbsolutePath() + "/" + localfileNames.get(i));
                    GetExecuteScript.inputStreamToFile(is, tempDir.getAbsolutePath() + "/" + localfileNames.get(i));
                    is.close();
                    ++i;
                }
                this.logger.debug((Object)"ExecuteScript-> Files Retrieved");
                sb.append("Files Retrieved\n");
                this.logger.debug((Object)("ExecuteScript-> Executing script in " + System.getProperty("os.name")));
                sb.append("Executing script\n");
                String line = "";
                if (System.getProperty("os.name").startsWith("Windows")) {
                    line = new OSCommandGenericWorker().ExecuteGetLine("cmd /c cd " + tempDir.getAbsolutePath() + "\n " + toExecute + " " + argument + "\n exit\n", this.logger);
                } else {
                    line = new OSCommandGenericWorker().ExecuteGetLine("chmod +x " + tempDir.getAbsolutePath() + "/" + toExecute + "", this.logger);
                    line = new OSCommandGenericWorker().ExecuteGetLine(tempDir.getAbsolutePath() + "/" + toExecute + " " + tempDir.getAbsolutePath() + "/ " + argument + "\nexit\n", this.logger);
                }
                if (line != null && line.equals("ERROR")) {
                    throw new Exception("ERROR executing script");
                }
                this.logger.debug((Object)("ExecuteScript-> Script executed: " + line));
                sb.append("Script executed: " + line + "\n");
                String outputfile = randomu + JOBOUTPUT;
                BufferedWriter bw = new BufferedWriter(new FileWriter(new File(outputfile)));
                bw.write(sb.toString());
                bw.flush();
                bw.close();
                this.logger.debug((Object)"ExecuteScript-> writing back output");
                sb.append("writing back output\n");
                this.save2Storage(JOBOUTPUT, "_" + identifier, randomu, remoteDirectory, scope, serviceClass, serviceName, owner);
                if (deletefiles) {
                    this.logger.debug((Object)"ExecuteScript-> write back ok ... deleting local files");
                    for (File singlefile : tempDir.listFiles()) {
                        boolean del = singlefile.delete();
                        if (!del) {
                            this.logger.debug((Object)("ExecuteScript-> ERROR deleting " + singlefile.getName() + " " + del));
                            continue;
                        }
                        this.logger.debug((Object)("ExecuteScript-> deleted LOCAL FILE " + singlefile.getName() + " " + del));
                    }
                    this.logger.debug((Object)"ExecuteScript-> deleting temporary directory");
                    tempDir.delete();
                }
                this.logger.debug((Object)"ExecuteScript-> all done");
            } else {
                this.logger.debug((Object)"ExecuteScript-> Failed to create directory");
            }
            this.status = 100.0f;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)("ExecuteScript-> ERROR: " + e.getLocalizedMessage()));
            this.status = 100.0f;
            throw e;
        }
    }

    private void save2Storage(String filename, String suffix, String localdirectory, String remotedirectory, String scope$, String serviceClass, String serviceName, String owner) {
        try {
            this.logger.debug((Object)("ExecuteScript-> getting scope " + scope$));
            GCUBEScope scope = GCUBEScope.getScope((String)scope$);
            IClient client = new StorageClient(serviceClass, serviceName, owner, AccessType.SHARED, scope).getClient();
            String localf = localdirectory + filename;
            String remotef = remotedirectory + filename;
            this.logger.debug((Object)("ExecuteScript-> updating file " + localf + " to " + remotef));
            String id = client.put(true).LFile(localf).RFile(remotef);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.debug((Object)e);
        }
    }

    private static void inputStreamToFile(InputStream is, String path) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(new File(path));
        byte[] buf = new byte[1024];
        int len = 0;
        while ((len = is.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.close();
    }
}

