package org.gcube.dataanalysis.executor.tests;

import java.io.File;

import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.executor.generators.D4ScienceDistributedProcessing;
import org.gcube.dataanalysis.executor.nodes.transducers.OccurrenceMergingNode;

public class TestD4ScienceQueueMaps2_1 {

	public static void main(String[] args) throws Exception {
		String scope = "/gcube";
		
		AlgorithmConfiguration config = Regressor.getConfig();
		config.setConfigPath("./cfg/");
		config.setPersistencePath("./");
		
//		config.setAgent("OCCURRENCES_MERGER");
//		config.setAgent("OCCURRENCES_INTERSECTOR");
		config.setAgent("OCCURRENCES_SUBTRACTION");
		
		config.setParam("longitudeColumn", "decimallongitude");
		config.setParam("latitudeColumn", "decimallatitude");
		config.setParam("recordedByColumn", "recordedby");
		config.setParam("scientificNameColumn", "scientificname");
		config.setParam("eventDateColumn", "eventdate");
		config.setParam("lastModificationColumn", "modified");
		
		config.setParam("leftTableName", "occurrencesintersected");
		config.setParam("rightTableName", "occurrencesintersected");
		
		config.setParam("finalTableName", "occurrencesintersect_distib");
		config.setParam("spatialTolerance", "0.00");
		config.setParam("confidence", "100");
		
		config.setParam("DatabaseUserName","utente");
		config.setParam("DatabasePassword","d4science");
		config.setParam("DatabaseURL","jdbc:postgresql://dbtest.research-infrastructures.eu/testdb");
		config.setParam("DatabaseDriver","org.postgresql.Driver");

		config.setGcubeScope(scope);
		config.setParam("ServiceUserName", "gianpaolo.coro");
		
		generate(config);
		
		/*
		OccurrenceProcessingNode opn = new OccurrenceProcessingNode();
		opn.setup(config);
		String dump = "./cfg/dumped.dat";
		Transformations.dumpConfig(dump, config);
		opn.executeNode(0, 1, 0, 1, false, "./cfg/", dump, "");
		*/
	}

	
	
	
	public static void generate(AlgorithmConfiguration config) throws Exception {

		D4ScienceDistributedProcessing generator = new D4ScienceDistributedProcessing(config);
		generator.init();

		if (generator != null) {
			long t0 = System.currentTimeMillis();
			TestGenerator tgs = new TestGenerator(generator);
			Thread t = new Thread(tgs);
			t.start();
			while (generator.getStatus() < 100) {

				String resLoad = generator.getResourceLoad();
				String ress = generator.getResources();
				String species = generator.getLoad();
				System.out.println("LOAD: " + resLoad);
				System.out.println("RESOURCES: " + ress);
				System.out.println("SPECIES: " + species);
				System.out.println("STATUS: " + generator.getStatus());
				Thread.sleep(20000);
			}
			System.out.println("FINAL STATUS: " + generator.getStatus()+ " ELAPSED "+(System.currentTimeMillis()-t0));
			
		} 
		else
			System.out.println("Generator Algorithm Not Supported");
			
//			generator.generate();
//	}
	}
}
