/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server.request.strategy;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import net.opengis.wps.x100.InputType;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DecompressingHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicHeader;
import org.n52.wps.server.ExceptionReport;
import org.n52.wps.server.request.strategy.IReferenceStrategy;
import org.n52.wps.server.request.strategy.ReferenceInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultReferenceStrategy
implements IReferenceStrategy {
    Logger logger = LoggerFactory.getLogger(DefaultReferenceStrategy.class);
    static final HttpHost proxy = null;

    @Override
    public boolean isApplicable(InputType input) {
        return true;
    }

    @Override
    public ReferenceInputStream fetchData(InputType input) throws ExceptionReport {
        String href = input.getReference().getHref();
        String mimeType = input.getReference().getMimeType();
        try {
            if (input.getReference().isSetBodyReference()) {
                String bodyHref = input.getReference().getBodyReference().getHref();
                StringWriter writer = new StringWriter();
                IOUtils.copy((InputStream)this.httpGet(bodyHref, null), (Writer)writer);
                String body = writer.toString();
                return this.httpPost(href, body, mimeType);
            }
            if (input.getReference().isSetBody()) {
                String body = input.getReference().getBody().toString();
                return this.httpPost(href, body, mimeType);
            }
            return this.httpGet(href, mimeType);
        }
        catch (RuntimeException e) {
            throw new ExceptionReport("Error occured while parsing XML", "NoApplicableCode", (Throwable)e);
        }
        catch (MalformedURLException e) {
            String inputID = input.getIdentifier().getStringValue();
            throw new ExceptionReport("The inputURL of the execute is wrong: inputID: " + inputID + " | dataURL: " + href, "InvalidParameterValue");
        }
        catch (IOException e) {
            String inputID = input.getIdentifier().getStringValue();
            throw new ExceptionReport("Error occured while receiving the complexReferenceURL: inputID: " + inputID + " | dataURL: " + href, "InvalidParameterValue");
        }
    }

    private ReferenceInputStream httpGet(String dataURLString, String mimeType) throws IOException {
        DefaultHttpClient backend = new DefaultHttpClient();
        DecompressingHttpClient httpclient = new DecompressingHttpClient((HttpClient)backend);
        HttpGet httpget = new HttpGet(dataURLString);
        if (mimeType != null) {
            httpget.addHeader((Header)new BasicHeader("Content-type", mimeType));
        }
        return this.processResponse(httpclient.execute((HttpUriRequest)httpget));
    }

    private ReferenceInputStream httpPost(String dataURLString, String body, String mimeType) throws IOException {
        DefaultHttpClient backend = new DefaultHttpClient();
        DecompressingHttpClient httpclient = new DecompressingHttpClient((HttpClient)backend);
        HttpPost httppost = new HttpPost(dataURLString);
        if (mimeType != null) {
            httppost.addHeader((Header)new BasicHeader("Content-type", mimeType));
        }
        StringEntity postEntity = new StringEntity(body);
        httppost.setEntity((HttpEntity)postEntity);
        return this.processResponse(httpclient.execute((HttpUriRequest)httppost));
    }

    private ReferenceInputStream processResponse(HttpResponse response) throws IOException {
        HttpEntity entity = response.getEntity();
        Header header = entity.getContentType();
        String mimeType = header == null ? null : header.getValue();
        header = entity.getContentEncoding();
        String encoding = header == null ? null : header.getValue();
        return new ReferenceInputStream(entity.getContent(), mimeType, encoding);
    }
}

