/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.n52.wps.algorithm.descriptor.AlgorithmDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataInputDescriptor;
import org.n52.wps.algorithm.descriptor.LiteralDataOutputDescriptor;
import org.n52.wps.algorithm.descriptor.OutputDescriptor;
import org.n52.wps.io.data.IData;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;
import org.n52.wps.server.AbstractDescriptorAlgorithm;

public class StringReverseSelfDescribingAlgorithm
extends AbstractDescriptorAlgorithm {
    public static final String INPUT_STRING = "INPUT_STRING";
    public static final String OUTPUT_STRING = "OUTPUT_STRING";
    private static AlgorithmDescriptor DESCRIPTOR;

    protected static synchronized AlgorithmDescriptor getAlgorithmDescriptorStatic() {
        if (DESCRIPTOR == null) {
            DESCRIPTOR = ((AlgorithmDescriptor.Builder)((AlgorithmDescriptor.Builder)AlgorithmDescriptor.builder(StringReverseSelfDescribingAlgorithm.class).version("0.0.1").title("String Reverse Algorithm (Self Describing)")).abstrakt("This is an example algorithm implementation described using a chained builder that reverses a string.")).statusSupported(false).storeSupported(false).addInputDescriptor(((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)((LiteralDataInputDescriptor.Builder)LiteralDataInputDescriptor.stringBuilder((String)INPUT_STRING).title("Input String")).abstrakt("The input string you want reversed.")).minOccurs(1)).maxOccurs(1)).addOutputDescriptor((OutputDescriptor.Builder)((LiteralDataOutputDescriptor.Builder)LiteralDataOutputDescriptor.stringBuilder((String)OUTPUT_STRING).title("Output String")).abstrakt("The reverse of the input string.")).build();
        }
        return DESCRIPTOR;
    }

    public AlgorithmDescriptor createAlgorithmDescriptor() {
        return StringReverseSelfDescribingAlgorithm.getAlgorithmDescriptorStatic();
    }

    public Map<String, IData> run(Map<String, List<IData>> inputMap) {
        List<IData> inputDataList = inputMap.get(INPUT_STRING);
        if (inputDataList == null || inputDataList.isEmpty()) {
            this.addError("Missing input string!");
            return null;
        }
        IData inputData = inputDataList.get(0);
        if (inputData == null || !(inputData instanceof LiteralStringBinding)) {
            this.addError("Something wierd happened with the request parser!");
            return null;
        }
        String inputString = ((LiteralStringBinding)inputData).getPayload();
        String outputString = new StringBuffer(inputString).reverse().toString();
        HashMap<String, IData> outputMap = new HashMap<String, IData>();
        outputMap.put(OUTPUT_STRING, (IData)new LiteralStringBinding(outputString));
        return outputMap;
    }
}

