/*
 * Decompiled with CFR 0.152.
 */
package org.n52.wps.server;

import net.opengis.wps.x100.ProcessDescriptionType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.algorithm.annotation.Execute;
import org.n52.wps.algorithm.annotation.LiteralDataInput;
import org.n52.wps.algorithm.annotation.LiteralDataOutput;
import org.n52.wps.server.AbstractAnnotatedAlgorithm;
import org.n52.wps.server.ServiceLoaderAlgorithmRepository;

public class ServiceLoaderAlgorithmTest {
    private ServiceLoaderAlgorithmRepository repo;

    @Before
    public void init() {
        this.repo = new ServiceLoaderAlgorithmRepository();
        Assert.assertNotNull((Object)this.repo);
    }

    @Test
    public void shouldFindAlgorithms() {
        String identified = "dummy-test-identifier";
        Assert.assertThat((Object)this.repo.containsAlgorithm(identified), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)this.repo.getAlgorithm(identified), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)this.repo.getAlgorithm(DummyAnnotatedAlgorithm.class.getCanonicalName()), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    public void shouldNotFindAlgorithm() {
        String identified = "not-in-there";
        Assert.assertThat((Object)this.repo.containsAlgorithm(identified), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)true)));
        Assert.assertThat((Object)this.repo.getAlgorithm(identified), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void shouldFindTwoRegisteredAlgorithms() {
        Assert.assertThat((Object)this.repo.getAlgorithmNames().size(), (Matcher)CoreMatchers.is((Object)2));
    }

    @Test
    public void shouldResolveProcessDescription() {
        ProcessDescriptionType description = this.repo.getProcessDescription(DummyAnnotatedAlgorithm.class.getCanonicalName());
        Assert.assertThat((Object)description, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)description, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ProcessDescriptionType.class)));
    }

    @Algorithm(version="0.1", identifier="dummy-test-identifier")
    public static class DummyIdentifiedAnnotatedAlgorithm
    extends DummyAnnotatedAlgorithm {
        private String output;
        @LiteralDataInput(identifier="input")
        public String input;

        @Override
        @LiteralDataOutput(identifier="output")
        public String getOutput() {
            return this.output;
        }

        @Override
        @Execute
        public void myRunMethodFollowingNoSyntaxNoArgumentsAllowed() {
            this.output = "works like a charm.";
        }
    }

    @Algorithm(version="0.1")
    public static class DummyAnnotatedAlgorithm
    extends AbstractAnnotatedAlgorithm {
        private String output;
        @LiteralDataInput(identifier="input")
        public String input;

        @LiteralDataOutput(identifier="output")
        public String getOutput() {
            return this.output;
        }

        @Execute
        public void myRunMethodFollowingNoSyntaxNoArgumentsAllowed() {
            this.output = "works like a charm.";
        }
    }
}

